/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.in.TiffReader;
import loci.formats.services.OMEXMLServiceImpl;
import loci.formats.tiff.TiffParser;
import loci.formats.tools.CommandLineTools;

public class XMLValidate {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validate(BufferedReader in, String label) throws IOException {
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            in.close();
        }
        return XMLTools.validateXML(sb.toString(), label, OMEXMLServiceImpl.SCHEMA_CLASSPATH_READER);
    }

    @Deprecated
    public static void process(String label, BufferedReader in) throws IOException {
        XMLValidate.validate(in, label);
    }

    public static boolean validate(String file2) throws IOException {
        String[] files = new String[]{file2};
        return XMLValidate.validate(files)[0];
    }

    public static boolean[] validate(String[] files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("No files to validate");
        }
        boolean[] results = new boolean[files.length];
        List<String> extensions = Arrays.asList(TiffReader.TIFF_SUFFIXES);
        for (int i = 0; i < files.length; ++i) {
            String file2 = files[i];
            if (file2 == null || file2.trim().length() == 0) {
                results[i] = false;
                continue;
            }
            String extension = file2.substring(file2.lastIndexOf(".") + 1);
            if (extensions.contains(extension.toLowerCase())) {
                String comment = "";
                try (RandomAccessInputStream stream = new RandomAccessInputStream(file2);){
                    comment = new TiffParser(stream).getComment();
                }
                results[i] = XMLValidate.validate(new BufferedReader(new StringReader(comment)), file2);
                continue;
            }
            results[i] = XMLValidate.validate(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8")), file2);
        }
        return results;
    }

    public static void main(String[] args) throws Exception {
        CommandLineTools.runUpgradeCheck(args);
        boolean result = true;
        if (args.length == 0) {
            result = XMLValidate.validate(new BufferedReader(new InputStreamReader(System.in, "UTF-8")), "<stdin>");
        } else {
            boolean[] results = XMLValidate.validate(args);
            int count = 0;
            for (int i = 0; i < results.length; ++i) {
                if (!results[i]) continue;
                ++count;
            }
            boolean bl = result = count == results.length;
        }
        if (result) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }
}

