/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;
import loci.poi.util.StringUtil;

public class FileSharingRecord
extends Record {
    public static final short sid = 91;
    private short field_1_readonly;
    private short field_2_password;
    private byte field_3_username_length;
    private short field_4_unknown;
    private String field_5_username;

    public FileSharingRecord() {
    }

    public FileSharingRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 91) {
            throw new RecordFormatException("NOT A FILESHARING RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_readonly = in.readShort();
        this.field_2_password = in.readShort();
        this.field_3_username_length = in.readByte();
        this.field_4_unknown = in.readShort();
        this.field_5_username = in.readCompressedUnicode(this.field_3_username_length);
    }

    public static short hashPassword(String password) {
        byte[] passwordCharacters = password.getBytes();
        int hash = 0;
        if (passwordCharacters.length > 0) {
            int charIndex = passwordCharacters.length;
            while (charIndex-- > 0) {
                hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
                hash ^= passwordCharacters[charIndex];
            }
            hash = hash >> 14 & 1 | hash << 1 & Short.MAX_VALUE;
            hash ^= passwordCharacters.length;
            hash ^= 0xCE4B;
        }
        return (short)hash;
    }

    public void setReadOnly(short readonly) {
        this.field_1_readonly = readonly;
    }

    public short getReadOnly() {
        return this.field_1_readonly;
    }

    public void setPassword(short password) {
        this.field_2_password = password;
    }

    public short getPassword() {
        return this.field_2_password;
    }

    public byte getUsernameLength() {
        return this.field_3_username_length;
    }

    public void setUsernameLength(byte length) {
        this.field_3_username_length = length;
    }

    public String getUsername() {
        return this.field_5_username;
    }

    public void setUsername(String username) {
        this.field_5_username = username;
        this.field_3_username_length = (byte)username.length();
    }

    public short getUnknown() {
        return this.field_4_unknown;
    }

    public void setUnknown(short unk) {
        this.field_4_unknown = unk;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[FILESHARING]\n");
        buffer.append("    .readonly       = ").append(this.getReadOnly() == 1 ? "true" : "false").append("\n");
        buffer.append("    .password       = ").append(Integer.toHexString(this.getPassword())).append("\n");
        buffer.append("    .userlen        = ").append(Integer.toHexString(this.getUsernameLength())).append("\n");
        buffer.append("    .unknown        = ").append(Integer.toHexString(this.getUnknown())).append("\n");
        buffer.append("    .username       = ").append(this.getUsername()).append("\n");
        buffer.append("[/FILESHARING]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)91);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset, this.getReadOnly());
        LittleEndian.putShort(data, 6 + offset, this.getPassword());
        data[8 + offset] = this.getUsernameLength();
        LittleEndian.putShort(data, 9 + offset, this.getUnknown());
        StringUtil.putCompressedUnicode(this.getUsername(), data, 11 + offset);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 11 + this.getUsernameLength();
    }

    @Override
    public short getSid() {
        return 91;
    }

    @Override
    public Object clone() {
        FileSharingRecord clone = new FileSharingRecord();
        clone.setReadOnly(this.field_1_readonly);
        clone.setPassword(this.field_2_password);
        clone.setUsernameLength(this.field_3_username_length);
        clone.setUnknown(this.field_4_unknown);
        clone.setUsername(this.field_5_username);
        return clone;
    }
}

