/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class HCenterRecord
extends Record {
    public static final short sid = 131;
    private short field_1_hcenter;

    public HCenterRecord() {
    }

    public HCenterRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 131) {
            throw new RecordFormatException("NOT A HCenter RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_hcenter = in.readShort();
    }

    public void setHCenter(boolean hc) {
        this.field_1_hcenter = hc ? (short)1 : 0;
    }

    public boolean getHCenter() {
        return this.field_1_hcenter == 1;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[HCENTER]\n");
        buffer.append("    .hcenter        = ").append(this.getHCenter()).append("\n");
        buffer.append("[/HCENTER]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)131);
        LittleEndian.putShort(data, 2 + offset, (short)2);
        LittleEndian.putShort(data, 4 + offset, this.field_1_hcenter);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 6;
    }

    @Override
    public short getSid() {
        return 131;
    }

    @Override
    public Object clone() {
        HCenterRecord rec = new HCenterRecord();
        rec.field_1_hcenter = this.field_1_hcenter;
        return rec;
    }
}

