/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;

public class MulBlankRecord
extends Record {
    public static final short sid = 190;
    private int field_1_row;
    private short field_2_first_col;
    private short[] field_3_xfs;
    private short field_4_last_col;

    public MulBlankRecord() {
    }

    public MulBlankRecord(RecordInputStream in) {
        super(in);
    }

    public int getRow() {
        return this.field_1_row;
    }

    public short getFirstColumn() {
        return this.field_2_first_col;
    }

    public short getLastColumn() {
        return this.field_4_last_col;
    }

    public int getNumColumns() {
        return this.field_4_last_col - this.field_2_first_col + 1;
    }

    public short getXFAt(int coffset) {
        return this.field_3_xfs[coffset];
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_first_col = in.readShort();
        this.field_3_xfs = this.parseXFs(in);
        this.field_4_last_col = in.readShort();
    }

    private short[] parseXFs(RecordInputStream in) {
        short[] retval = new short[(in.remaining() - 2) / 2];
        for (int idx = 0; idx < retval.length; ++idx) {
            retval[idx] = in.readShort();
        }
        return retval;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[MULBLANK]\n");
        buffer.append("row  = ").append(Integer.toHexString(this.getRow())).append("\n");
        buffer.append("firstcol  = ").append(Integer.toHexString(this.getFirstColumn())).append("\n");
        buffer.append(" lastcol  = ").append(Integer.toHexString(this.getLastColumn())).append("\n");
        for (int k = 0; k < this.getNumColumns(); ++k) {
            buffer.append("xf").append(k).append("        = ").append(Integer.toHexString(this.getXFAt(k))).append("\n");
        }
        buffer.append("[/MULBLANK]\n");
        return buffer.toString();
    }

    @Override
    protected void validateSid(short id) {
        if (id != 190) {
            throw new RecordFormatException("Not a MulBlankRecord!");
        }
    }

    @Override
    public short getSid() {
        return 190;
    }

    @Override
    public int serialize(int offset, byte[] data) {
        throw new RecordFormatException("Sorry, you can't serialize a MulBlank in this release");
    }
}

