/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.HexDump;
import loci.poi.util.LittleEndian;

public class SeriesIndexRecord
extends Record {
    public static final short sid = 4197;
    private short field_1_index;

    public SeriesIndexRecord() {
    }

    public SeriesIndexRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 4197) {
            throw new RecordFormatException("Not a SeriesIndex record");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
        this.field_1_index = in.readShort();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SINDEX]\n");
        buffer.append("    .index                = ").append("0x").append(HexDump.toHex(this.getIndex())).append(" (").append(this.getIndex()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/SINDEX]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        int pos = 0;
        LittleEndian.putShort(data, 0 + offset, (short)4197);
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        LittleEndian.putShort(data, 4 + offset + pos, this.field_1_index);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 6;
    }

    @Override
    public short getSid() {
        return 4197;
    }

    @Override
    public Object clone() {
        SeriesIndexRecord rec = new SeriesIndexRecord();
        rec.field_1_index = this.field_1_index;
        return rec;
    }

    public short getIndex() {
        return this.field_1_index;
    }

    public void setIndex(short field_1_index) {
        this.field_1_index = field_1_index;
    }
}

