/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.util.LittleEndian;

public class WriteProtectRecord
extends Record {
    public static final short sid = 134;

    public WriteProtectRecord() {
    }

    public WriteProtectRecord(RecordInputStream in) {
        super(in);
    }

    @Override
    protected void validateSid(short id) {
        if (id != 134) {
            throw new RecordFormatException("NOT A WRITEPROTECT RECORD");
        }
    }

    @Override
    protected void fillFields(RecordInputStream in) {
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[WRITEPROTECT]\n");
        buffer.append("[/WRITEPROTECT]\n");
        return buffer.toString();
    }

    @Override
    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, (short)134);
        LittleEndian.putShort(data, 2 + offset, (short)0);
        return this.getRecordSize();
    }

    @Override
    public int getRecordSize() {
        return 4;
    }

    @Override
    public short getSid() {
        return 134;
    }
}

