/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.util;

import loci.poi.hssf.util.CellReference;

public class AreaReference {
    private CellReference[] cells;
    private int dim;

    public AreaReference(String reference) {
        String[] refs = this.seperateAreaRefs(reference);
        this.dim = refs.length;
        this.cells = new CellReference[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.cells[i] = new CellReference(refs[i]);
        }
    }

    public int getDim() {
        return this.dim;
    }

    public CellReference[] getCells() {
        return this.cells;
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < this.dim; ++i) {
            retval.append(':');
            retval.append(this.cells[i].toString());
        }
        retval.deleteCharAt(0);
        return retval.toString();
    }

    private String[] seperateAreaRefs(String reference) {
        String[] retval = null;
        int length = reference.length();
        int loc = reference.indexOf(58, 0);
        if (loc == -1) {
            retval = new String[]{reference};
        } else {
            retval = new String[2];
            int sheetStart = reference.indexOf("!");
            retval[0] = reference.substring(0, sheetStart + 1) + reference.substring(sheetStart + 1, loc);
            retval[1] = reference.substring(0, sheetStart + 1) + reference.substring(loc + 1);
        }
        return retval;
    }
}

