/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Length;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsLengthEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsLength implements Enumeration
{
    YOTTAMETER("Ym"),
    ZETTAMETER("Zm"),
    EXAMETER("Em"),
    PETAMETER("Pm"),
    TERAMETER("Tm"),
    GIGAMETER("Gm"),
    MEGAMETER("Mm"),
    KILOMETER("km"),
    HECTOMETER("hm"),
    DECAMETER("dam"),
    METER("m"),
    DECIMETER("dm"),
    CENTIMETER("cm"),
    MILLIMETER("mm"),
    MICROMETER("\u00b5m"),
    NANOMETER("nm"),
    PICOMETER("pm"),
    FEMTOMETER("fm"),
    ATTOMETER("am"),
    ZEPTOMETER("zm"),
    YOCTOMETER("ym"),
    ANGSTROM("\u00c5"),
    THOU("thou"),
    LINE("li"),
    INCH("in"),
    FOOT("ft"),
    YARD("yd"),
    MILE("mi"),
    ASTRONOMICALUNIT("ua"),
    LIGHTYEAR("ly"),
    PARSEC("pc"),
    POINT("pt"),
    PIXEL("pixel"),
    REFERENCEFRAME("reference frame");

    private final String value;

    private UnitsLength(String value) {
        this.value = value;
    }

    public static UnitsLength fromString(String value) throws EnumerationException {
        if ("Ym".equals(value)) {
            return YOTTAMETER;
        }
        if ("Zm".equals(value)) {
            return ZETTAMETER;
        }
        if ("Em".equals(value)) {
            return EXAMETER;
        }
        if ("Pm".equals(value)) {
            return PETAMETER;
        }
        if ("Tm".equals(value)) {
            return TERAMETER;
        }
        if ("Gm".equals(value)) {
            return GIGAMETER;
        }
        if ("Mm".equals(value)) {
            return MEGAMETER;
        }
        if ("km".equals(value)) {
            return KILOMETER;
        }
        if ("hm".equals(value)) {
            return HECTOMETER;
        }
        if ("dam".equals(value)) {
            return DECAMETER;
        }
        if ("m".equals(value)) {
            return METER;
        }
        if ("dm".equals(value)) {
            return DECIMETER;
        }
        if ("cm".equals(value)) {
            return CENTIMETER;
        }
        if ("mm".equals(value)) {
            return MILLIMETER;
        }
        if ("\u00b5m".equals(value)) {
            return MICROMETER;
        }
        if ("nm".equals(value)) {
            return NANOMETER;
        }
        if ("pm".equals(value)) {
            return PICOMETER;
        }
        if ("fm".equals(value)) {
            return FEMTOMETER;
        }
        if ("am".equals(value)) {
            return ATTOMETER;
        }
        if ("zm".equals(value)) {
            return ZEPTOMETER;
        }
        if ("ym".equals(value)) {
            return YOCTOMETER;
        }
        if ("\u00c5".equals(value)) {
            return ANGSTROM;
        }
        if ("thou".equals(value)) {
            return THOU;
        }
        if ("li".equals(value)) {
            return LINE;
        }
        if ("in".equals(value)) {
            return INCH;
        }
        if ("ft".equals(value)) {
            return FOOT;
        }
        if ("yd".equals(value)) {
            return YARD;
        }
        if ("mi".equals(value)) {
            return MILE;
        }
        if ("ua".equals(value)) {
            return ASTRONOMICALUNIT;
        }
        if ("ly".equals(value)) {
            return LIGHTYEAR;
        }
        if ("pc".equals(value)) {
            return PARSEC;
        }
        if ("pt".equals(value)) {
            return POINT;
        }
        if ("pixel".equals(value)) {
            return PIXEL;
        }
        if ("reference frame".equals(value)) {
            return REFERENCEFRAME;
        }
        String s2 = String.format("'%s' not a supported value of '%s'", value, UnitsLength.class);
        throw new EnumerationException(s2);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static <T extends PrimitiveNumber> Length create(T newValue, UnitsLength newUnit) {
        Length theQuantity = null;
        try {
            theQuantity = UnitsLengthEnumHandler.getQuantity(newValue, newUnit);
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return theQuantity;
    }

    public static <T extends Number> Length create(T newValue, UnitsLength newUnit) {
        Length theQuantity = null;
        try {
            theQuantity = UnitsLengthEnumHandler.getQuantity(newValue, newUnit);
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return theQuantity;
    }
}

