/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinningEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinningEnumHandler.class);
    private static final Hashtable<String, String> patterns = BinningEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*1x1\\s*", "1x1");
        p.put("^\\s*2x2\\s*", "2x2");
        p.put("^\\s*4x4\\s*", "4x4");
        p.put("^\\s*8x8\\s*", "8x8");
        p.put("^\\s*Other\\s*", "Other");
        p.put("^\\s*1.*x.*1\\s*", "1x1");
        p.put("^\\s*2.*x.*2\\s*", "2x2");
        p.put("^\\s*4.*x.*4\\s*", "4x4");
        p.put("^\\s*8.*x.*8\\s*", "8x8");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.toLowerCase().matches(pattern.toLowerCase())) continue;
                String v = patterns.get(pattern);
                return Binning.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"Binning", (Object)value);
        return Binning.OTHER;
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return Binning.class;
    }
}

