/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.Property;
import thredds.client.catalog.ServiceType;
import ucar.nc2.util.Indent;

@Immutable
public class Service {
    private final String name;
    private final String base;
    private final String typeS;
    private final String desc;
    private final String accessType;
    private final String suffix;
    private final List<Service> nestedServices;
    private final List<Property> properties;

    public Service(String name, String base, String typeS, String desc, String suffix, List<Service> nestedServices, List<Property> properties, String accessType) {
        this.name = name;
        this.base = base;
        this.typeS = typeS;
        this.desc = desc;
        this.accessType = accessType;
        this.suffix = suffix;
        this.nestedServices = nestedServices;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public String getBase() {
        return this.base;
    }

    public String getServiceTypeName() {
        return this.typeS;
    }

    public ServiceType getType() {
        return ServiceType.getServiceTypeIgnoreCase(this.typeS);
    }

    public String getDesc() {
        return this.desc;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public String getSuffix() {
        return this.suffix == null ? "" : this.suffix;
    }

    public List<Service> getNestedServices() {
        return this.nestedServices == null ? new ArrayList(0) : this.nestedServices;
    }

    public List<Property> getProperties() {
        return this.properties == null ? new ArrayList(0) : this.properties;
    }

    public boolean isRelativeBase() {
        if (this.getType() == ServiceType.Compound) {
            return true;
        }
        try {
            URI uri = new URI(this.base);
            return !uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    protected String toString(Indent indent) {
        Formatter f = new Formatter();
        f.format("%sService{ name=%s, base=%s, typeS=%s", indent, this.name, this.base, this.typeS);
        if (this.desc != null) {
            f.format(",desc=%s", this.desc);
        }
        if (this.suffix != null) {
            f.format(",suffix=%s", this.suffix);
        }
        if (this.properties != null) {
            f.format("%n", new Object[0]);
            indent.incr();
            for (Property p : this.properties) {
                f.format("%s%s%n", indent, p.toString());
            }
            indent.decr();
            f.format("%n", new Object[0]);
        }
        if (this.nestedServices != null) {
            f.format("%n", new Object[0]);
            indent.incr();
            for (Service nested : this.nestedServices) {
                f.format("%s%n", nested.toString(indent));
            }
            indent.decr();
            f.format("}%n", new Object[0]);
        } else {
            f.format("}", new Object[0]);
        }
        return f.toString();
    }

    public String toString() {
        return this.toString(new Indent(2));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        if (!Objects.equals(this.base, service.base)) {
            return false;
        }
        if (!Objects.equals(this.desc, service.desc)) {
            return false;
        }
        if (!Objects.equals(this.name, service.name)) {
            return false;
        }
        if (!Objects.equals(this.nestedServices, service.nestedServices)) {
            return false;
        }
        if (!Objects.equals(this.properties, service.properties)) {
            return false;
        }
        if (!Objects.equals(this.suffix, service.suffix)) {
            return false;
        }
        return Objects.equals(this.typeS, service.typeS);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.base != null ? this.base.hashCode() : 0);
        result = 31 * result + (this.typeS != null ? this.typeS.hashCode() : 0);
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + (this.nestedServices != null ? this.nestedServices.hashCode() : 0);
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

