/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.nio.file.Paths;
import loci.tests.testng.ConfigurationTree;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ConfigurationTreeTest {
    ConfigurationTree configTree = new ConfigurationTree(this.path("/data"), this.path("/config"));

    @DataProvider(name="configList")
    public Object[][] createConfigList() {
        return new Object[][]{{this.path("/config"), this.path("/data")}, {this.path("/config/"), this.path("/data")}, {this.path("/config/test"), this.path("/data/test")}, {this.path("/config/test/test2/test3/"), this.path("/data/test/test2/test3")}, {this.path("/data"), this.path("/data")}, {this.path("/data/test"), this.path("/data/test")}, {this.path("/data2"), this.path("/data2")}, {this.path("/data2/test"), this.path("/data2/test")}};
    }

    @DataProvider(name="rootList")
    public Object[][] createRootList() {
        return new Object[][]{{this.path("/data"), this.path("/config")}, {this.path("/data/"), this.path("/config")}, {this.path("/data/test"), this.path("/config/test")}, {this.path("/data/test/test2/test3/"), this.path("/config/test/test2/test3")}, {this.path("/config"), this.path("/config")}, {this.path("/config/test"), this.path("/config/test")}, {this.path("/config2"), this.path("/config2")}, {this.path("/config2/test"), this.path("/config2/test")}};
    }

    @Test(dataProvider="configList")
    public void testRelocateToRoot(String path, String expected) {
        Assert.assertEquals((String)this.configTree.relocateToRoot(path), (String)expected);
    }

    @Test(dataProvider="rootList")
    public void testRelocateToConfig(String path, String expected) {
        Assert.assertEquals((String)this.configTree.relocateToConfig(path), (String)expected);
    }

    private String path(String path) {
        return Paths.get(path, new String[0]).toAbsolutePath().toString();
    }
}

