/*
 * Decompiled with CFR 0.152.
 */
package loci.tests;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingularityTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingularityTest.class);
    private static ImageReader reader = new ImageReader();

    public static void main(String[] args) throws FormatException, IOException {
        if (args.length < 1) {
            LOGGER.info("Usage: java.loci.tests.SingularityTest /path/to/input-file");
            System.exit(1);
        }
        LOGGER.info("Testing {}", (Object)args[0]);
        ImageReader reader = new ImageReader();
        boolean isSingleFile = reader.isSingleFile(args[0]);
        reader.setId(args[0]);
        String[] usedFiles = reader.getUsedFiles();
        if (isSingleFile && usedFiles.length > 1) {
            LOGGER.info("  Used files list contains more than one file, but isSingleFile(String) returned true.");
            LOGGER.info("FAILURE");
        } else if (!isSingleFile && usedFiles.length == 1) {
            LOGGER.info("  Used files list only contains one file, but isSingleFile(String) returned false.");
            LOGGER.info("FAILURE");
        } else {
            LOGGER.info("SUCCESS");
        }
    }
}

