/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MinimalTiffReader;
import loci.formats.internal.WellContainer;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JDCEReader
extends FormatReader {
    private List<JDCEWell> wells = new ArrayList<JDCEWell>();
    private String imageFileCSV = null;
    private transient MinimalTiffReader helper = new MinimalTiffReader();

    public JDCEReader() {
        super("Molecular Devices JDCE", new String[]{"jdce"});
        this.suffixSufficient = true;
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .jdce (JSON) file with at least one .tif/.tiff file";
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        Arrays.fill(buf, this.getFillColor());
        String file = this.getFile(no);
        if (file != null) {
            try {
                if (this.helper == null) {
                    this.helper = new MinimalTiffReader();
                }
                this.helper.setId(file);
                return this.helper.openBytes(0, buf, x, y, w, h);
            }
            catch (IOException | FormatException e) {
                LOGGER.error("Invalid file " + file, e);
            }
        }
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> imageFiles = new ArrayList<String>();
        imageFiles.add(this.currentId);
        imageFiles.add(this.imageFileCSV);
        if (!noPixels) {
            int index = 0;
            for (JDCEWell well : this.wells) {
                if (well.getFieldCount() + index > this.getSeries()) {
                    String[] f;
                    for (String file : f = well.getFiles(this.getSeries() - index)) {
                        if (file == null || imageFiles.contains(file)) continue;
                        imageFiles.add(file);
                    }
                    break;
                }
                index += well.getFieldCount();
            }
        }
        return imageFiles.toArray(new String[imageFiles.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helper != null) {
            this.helper.close(fileOnly);
        }
        if (!fileOnly) {
            this.imageFileCSV = null;
            if (this.wells != null) {
                this.wells.clear();
            }
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            String file = this.getFile(0);
            if (file != null) {
                if (this.helper == null) {
                    this.helper = new MinimalTiffReader();
                }
                this.helper.setId(file);
                return this.helper.getOptimalTileWidth();
            }
        }
        catch (IOException | FormatException e) {
            LOGGER.debug("Could not get optimal tile width", e);
        }
        return super.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            String file = this.getFile(0);
            if (file != null) {
                if (this.helper == null) {
                    this.helper = new MinimalTiffReader();
                }
                this.helper.setId(file);
                return this.helper.getOptimalTileHeight();
            }
        }
        catch (IOException | FormatException e) {
            LOGGER.debug("Could not get optimal tile height", e);
        }
        return super.getOptimalTileHeight();
    }

    protected void initFile(String id) throws FormatException, IOException {
        PlaneMetadata p;
        super.initFile(id);
        Location parentDir = new Location(this.getCurrentFile()).getAbsoluteFile().getParentFile();
        String plateName = null;
        Length physicalSizeX = null;
        Length physicalSizeY = null;
        String[] channelNames = null;
        Length[] emissionWavelengths = null;
        Length[] excitationWavelengths = null;
        int plateRows = 0;
        int plateColumns = 0;
        String creationTimestamp = null;
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        try {
            JSONArray metadataFiles;
            JSONObject root;
            JSONObject imageStack;
            String jsonText = DataTools.readFile((String)id);
            if (!jsonText.startsWith("{")) {
                jsonText = jsonText.substring(jsonText.indexOf("{"));
            }
            if ((imageStack = (root = new JSONObject(jsonText)).getJSONObject("ImageStack")) == null) {
                throw new FormatException("Could not find image stack definition");
            }
            String imageFormat = imageStack.getString("ImageFormat");
            if (!"TIFF".equalsIgnoreCase(imageFormat)) {
                throw new FormatException("Unsupported image format " + imageFormat);
            }
            JSONObject creation = imageStack.getJSONObject("Creation");
            if (creation != null) {
                String date = creation.getString("Date");
                String time = creation.getString("Time");
                String timezone = creation.getString("TimeZoneOffset");
                if (timezone == null || timezone.isEmpty()) {
                    LOGGER.warn("Timezone not defined; plate acquisition time may be wrong");
                    creationTimestamp = DateTools.formatDate((String)(date + " " + time), (String)"yyyy-MM-dd HH:mm:ss");
                } else {
                    creationTimestamp = DateTools.formatDate((String)(date + " " + time + " " + timezone), (String)"yyyy-MM-dd HH:mm:ss Z");
                }
            } else {
                LOGGER.debug("Could not find plate creation time");
            }
            JSONObject acquisition = imageStack.getJSONObject("AutoLeadAcquisitionProtocol");
            if (acquisition == null) {
                throw new FormatException("Could not find acquisition definition");
            }
            JSONObject objective = acquisition.getJSONObject("ObjectiveCalibration");
            String unit = objective.getString("Unit");
            double pixelWidth = objective.getDouble("PixelWidth");
            double pixelHeight = objective.getDouble("PixelHeight");
            physicalSizeX = FormatTools.getPhysicalSize((Double)pixelWidth, (String)unit);
            physicalSizeY = FormatTools.getPhysicalSize((Double)pixelHeight, (String)unit);
            JSONObject plate = acquisition.getJSONObject("Plate");
            plateName = plate.getString("Name");
            plateRows = plate.getInt("Rows");
            plateColumns = plate.getInt("Columns");
            JSONObject plateMap = acquisition.getJSONObject("PlateMap");
            if (plateMap == null) {
                throw new FormatException("Could not find plate map, cannot determine dimensions");
            }
            JSONObject timeSchedule = plateMap.getJSONObject("TimeSchedule");
            if (timeSchedule == null) {
                throw new FormatException("Could not find time schedule, cannot determine SizeT");
            }
            JSONArray timepoints = timeSchedule.getJSONArray("Times");
            int timepointCount = timeSchedule.getInt("NumberOfTimepoints");
            if (timepoints.length() != timepointCount) {
                LOGGER.warn("Mismatched timepoint count; using {}, also found {}", (Object)timepoints.length(), (Object)timepointCount);
            }
            ms0.sizeT = timepoints.length();
            JSONObject zDimension = plateMap.getJSONObject("ZDimensionParameters");
            if (zDimension == null) {
                throw new FormatException("Could not find Z dimension parameters, cannot determine SizeZ");
            }
            ms0.sizeZ = zDimension.getInt("NumberOfSlices");
            JSONArray wavelengths = acquisition.getJSONArray("Wavelengths");
            if (wavelengths == null) {
                throw new FormatException("Could not find wavelength array, cannot determine SizeC");
            }
            ms0.sizeC = wavelengths.length();
            channelNames = new String[ms0.sizeC];
            emissionWavelengths = new Length[ms0.sizeC];
            excitationWavelengths = new Length[ms0.sizeC];
            String[] imagingMode = new String[ms0.sizeC];
            boolean singleZ = true;
            for (int c = 0; c < ms0.sizeC; ++c) {
                JSONObject wavelength = wavelengths.getJSONObject(c);
                int channelIndex = wavelength.getInt("Index");
                JSONObject emission = wavelength.getJSONObject("EmissionFilter");
                JSONObject excitation = wavelength.getJSONObject("ExcitationFilter");
                channelNames[channelIndex] = emission.getString("Name");
                String emUnit = emission.getString("Unit");
                double emWave = emission.getDouble("Wavelength");
                emissionWavelengths[channelIndex] = FormatTools.getWavelength((Double)emWave, (String)emUnit);
                String exUnit = excitation.getString("Unit");
                double exWave = excitation.getDouble("Wavelength");
                excitationWavelengths[channelIndex] = FormatTools.getWavelength((Double)exWave, (String)exUnit);
                imagingMode[c] = wavelength.getString("ImagingMode");
                if (imagingMode[c] != null && imagingMode[c].equals("Max Intensity Projection") && imagingMode[c].equals(imagingMode[0])) continue;
                singleZ = false;
            }
            if (singleZ) {
                LOGGER.debug("Ignoring Z stack size {} based on wavelength definition", (Object)ms0.sizeZ);
                ms0.sizeZ = 1;
            }
            if ((metadataFiles = imageStack.getJSONArray("ImageMetadataFiles")) == null || metadataFiles.length() == 0) {
                throw new FormatException("Could not find image metadata CSV, cannot get list of TIFF files");
            }
            this.imageFileCSV = new Location(parentDir, metadataFiles.getString(0)).getAbsolutePath();
        }
        catch (JSONException e) {
            throw new FormatException("Could not parse .jdce file", (Throwable)e);
        }
        ms0.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
        ms0.dimensionOrder = "XYCZT";
        if (this.imageFileCSV == null) {
            throw new FormatException("Image metadata CSV not found, cannot get list of TIFF files");
        }
        String[] csvLines = DataTools.readFile((String)this.imageFileCSV).split("\r\n");
        List<String> columns = Arrays.asList(csvLines[0].split(","));
        int wellRowIndex = columns.indexOf("Row");
        int wellColIndex = columns.indexOf("Column");
        int fieldIndex = columns.indexOf("Field");
        int wavelengthIndex = columns.indexOf("Wavelength");
        int timepointIndex = columns.indexOf("Timepoint");
        int zIndex = columns.indexOf("ZIndex");
        int subfolderIndex = columns.indexOf("ImageSubFolderPath");
        int fileNameIndex = columns.indexOf("ImageFileName");
        int timestampIndex = columns.indexOf("TimeStampSec");
        int exposureTimeIndex = columns.indexOf("ExposureTimeMs");
        int positionXIndex = columns.indexOf("PositionXUm");
        int positionYIndex = columns.indexOf("PositionYUm");
        int positionZIndex = columns.indexOf("PositionZUm");
        int imageWidthIndex = columns.indexOf("ImageSizeXPx");
        int imageHeightIndex = columns.indexOf("ImageSizeYPx");
        Double smallestTimestamp = null;
        JDCEWell currentWell = null;
        boolean firstFile = true;
        for (int i = 1; i < csvLines.length; ++i) {
            String[] line = csvLines[i].split(",");
            int[] position = new int[]{Integer.parseInt(line[fieldIndex]), Integer.parseInt(line[zIndex]), Integer.parseInt(line[wavelengthIndex]), Integer.parseInt(line[timepointIndex])};
            String subfolder = line[subfolderIndex];
            String filename = line[fileNameIndex];
            Location subfolderFile = new Location(parentDir, subfolder);
            String imagePath = new Location(subfolderFile, filename).getAbsolutePath();
            int wellRow = Integer.parseInt(line[wellRowIndex]) - 1;
            int wellCol = Integer.parseInt(line[wellColIndex]) - 1;
            if (currentWell == null || currentWell.getRowIndex() != wellRow || currentWell.getColumnIndex() != wellCol) {
                currentWell = this.lookupWell(wellRow, wellCol, ms0.imageCount);
            }
            currentWell.addFile(imagePath, position[0], this.getIndex(position[1], position[2], position[3]));
            currentWell.setFieldCount(Math.max(currentWell.getFieldCount(), position[0] + 1));
            p = new PlaneMetadata();
            p.timestamp = DataTools.parseDouble((String)line[timestampIndex]);
            if (p.timestamp != null && (smallestTimestamp == null || p.timestamp < smallestTimestamp)) {
                smallestTimestamp = p.timestamp;
            }
            p.exposureTime = FormatTools.createTime((Double)DataTools.parseDouble((String)line[exposureTimeIndex]), (Unit)UNITS.MILLISECOND);
            p.positionX = FormatTools.getStagePosition((Double)DataTools.parseDouble((String)line[positionXIndex]), (Unit)UNITS.MICROMETER);
            p.positionY = FormatTools.getStagePosition((Double)DataTools.parseDouble((String)line[positionYIndex]), (Unit)UNITS.MICROMETER);
            p.positionZ = FormatTools.getStagePosition((Double)DataTools.parseDouble((String)line[positionZIndex]), (Unit)UNITS.MICROMETER);
            p.sizeX = Integer.parseInt(line[imageWidthIndex]);
            p.sizeY = Integer.parseInt(line[imageHeightIndex]);
            currentWell.addPlaneMetadata(p, position);
            if (!firstFile) continue;
            try {
                if (this.helper == null) {
                    this.helper = new MinimalTiffReader();
                }
                this.helper.setId(imagePath);
                CoreMetadata m = (CoreMetadata)this.helper.getCoreMetadataList().get(0);
                if (p.sizeX == 0) {
                    ms0.sizeX = m.sizeX;
                    LOGGER.warn("Found image width 0 in CSV; using {} from TIFF", (Object)ms0.sizeX);
                }
                if (p.sizeY == 0) {
                    ms0.sizeY = m.sizeY;
                    LOGGER.warn("Found image height 0 in CSV; using {} from TIFF", (Object)ms0.sizeY);
                }
                ms0.pixelType = m.pixelType;
                ms0.littleEndian = m.littleEndian;
                ms0.sizeC *= m.sizeC;
                ms0.rgb = m.rgb;
                firstFile = false;
                continue;
            }
            catch (IOException | FormatException e) {
                LOGGER.debug("Could not read " + imagePath, e);
            }
        }
        for (JDCEWell well : this.wells) {
            for (int f = 0; f < well.getFieldCount(); ++f) {
                CoreMetadata m = new CoreMetadata(ms0);
                for (int plane = 0; plane < m.imageCount; ++plane) {
                    PlaneMetadata p2 = well.getPlaneMetadata(f, this.getZCTCoords(plane));
                    if (p2 == null) continue;
                    m.sizeX = Math.max(m.sizeX, p2.sizeX);
                    m.sizeY = Math.max(m.sizeY, p2.sizeY);
                }
                this.core.add(m);
            }
        }
        this.core.remove(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        store.setPlateID(MetadataTools.createLSID((String)"Plate", (int[])new int[]{0}), 0);
        store.setPlateName(plateName, 0);
        store.setPlateRows(new PositiveInteger(Integer.valueOf(plateRows)), 0);
        store.setPlateColumns(new PositiveInteger(Integer.valueOf(plateColumns)), 0);
        store.setPlateRowNamingConvention(NamingConvention.LETTER, 0);
        store.setPlateColumnNamingConvention(NamingConvention.NUMBER, 0);
        store.setPlateAcquisitionID(MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, 0}), 0, 0);
        if (creationTimestamp != null) {
            store.setPlateAcquisitionStartTime(new Timestamp(creationTimestamp), 0, 0);
        }
        this.wells.sort(null);
        int imageIndex = 0;
        for (int w = 0; w < this.wells.size(); ++w) {
            JDCEWell well = this.wells.get(w);
            well.fillMetadataStore(store, 0, 0, w, 0, imageIndex);
            int fieldCount = well.getFieldCount();
            String wellName = FormatTools.getWellName((int)well.getRowIndex(), (int)well.getColumnIndex());
            int f = 0;
            while (f < fieldCount) {
                store.setImageName(wellName + ", Field #" + (f + 1), imageIndex);
                store.setPixelsPhysicalSizeX(physicalSizeX, imageIndex);
                store.setPixelsPhysicalSizeY(physicalSizeY, imageIndex);
                for (int c = 0; c < channelNames.length; ++c) {
                    store.setChannelName(channelNames[c], imageIndex, c);
                    store.setChannelEmissionWavelength(emissionWavelengths[c], imageIndex, c);
                    store.setChannelExcitationWavelength(excitationWavelengths[c], imageIndex, c);
                }
                boolean firstPlane = true;
                for (int plane = 0; plane < this.getImageCount(); ++plane) {
                    p = well.getPlaneMetadata(f, this.getZCTCoords(plane));
                    if (p == null) continue;
                    store.setPlanePositionX(p.positionX, imageIndex, plane);
                    store.setPlanePositionY(p.positionY, imageIndex, plane);
                    store.setPlanePositionZ(p.positionZ, imageIndex, plane);
                    if (firstPlane) {
                        firstPlane = false;
                        store.setWellSamplePositionX(p.positionX, 0, w, f);
                        store.setWellSamplePositionY(p.positionY, 0, w, f);
                    }
                    if (p.timestamp != null && smallestTimestamp != null) {
                        Time stamp = FormatTools.createTime((Double)(p.timestamp - smallestTimestamp), (Unit)UNITS.SECOND);
                        store.setPlaneDeltaT(stamp, imageIndex, plane);
                    }
                    store.setPlaneExposureTime(p.exposureTime, imageIndex, plane);
                }
                ++f;
                ++imageIndex;
            }
        }
    }

    private JDCEWell lookupWell(int row, int col, int planeCount) {
        for (JDCEWell well : this.wells) {
            if (well.getRowIndex() != row || well.getColumnIndex() != col) continue;
            return well;
        }
        JDCEWell well = new JDCEWell(row, col, planeCount);
        this.wells.add(well);
        return well;
    }

    private String getFile(int no) {
        int index = 0;
        for (JDCEWell well : this.wells) {
            if (well.getFieldCount() + index > this.getSeries()) {
                return well.getFile(this.getSeries() - index, no);
            }
            index += well.getFieldCount();
        }
        return null;
    }

    class JDCEWell
    extends WellContainer {
        HashMap<String, Integer> posMap;
        HashMap<String, PlaneMetadata> metadataMap;
        int planeCount;

        public JDCEWell(int row, int col, int planeCount) {
            super(0, row, col, 1);
            this.posMap = new HashMap();
            this.metadataMap = new HashMap();
            this.planeCount = 0;
            this.planeCount = planeCount;
        }

        public void addFile(String file, int fieldIndex, int planeIndex) {
            super.addFile(file);
            this.posMap.put(fieldIndex + "-" + planeIndex, this.getAllFiles().size() - 1);
        }

        private int[] getIndex(String key) {
            String[] k = key.split("-");
            int[] v = new int[k.length];
            for (int i = 0; i < v.length; ++i) {
                v[i] = Integer.parseInt(k[i]);
            }
            return v;
        }

        public String[] getFiles(int fieldIndex) {
            List allFiles = this.getAllFiles();
            String[] fieldFiles = new String[this.planeCount];
            for (String key : this.posMap.keySet()) {
                int[] keyIndex = this.getIndex(key);
                if (keyIndex[0] != fieldIndex) continue;
                fieldFiles[keyIndex[1]] = (String)allFiles.get(this.posMap.get(key));
            }
            return fieldFiles;
        }

        public void addPlaneMetadata(PlaneMetadata p, int[] position) {
            StringJoiner joiner = new StringJoiner("-");
            for (int pos : position) {
                joiner.add(String.valueOf(pos));
            }
            this.metadataMap.put(joiner.toString(), p);
        }

        public PlaneMetadata getPlaneMetadata(int field, int[] position) {
            StringJoiner joiner = new StringJoiner("-");
            joiner.add(String.valueOf(field));
            for (int pos : position) {
                joiner.add(String.valueOf(pos));
            }
            return this.metadataMap.get(joiner.toString());
        }
    }

    class PlaneMetadata {
        public Double timestamp;
        public Time exposureTime;
        public Length positionX;
        public Length positionY;
        public Length positionZ;
        public int sizeX;
        public int sizeY;

        PlaneMetadata() {
        }
    }
}

