/*
 * Decompiled with CFR 0.152.
 */
package spec.schema;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import loci.common.services.ServiceFactory;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;
import ome.specification.OmeValidator;
import ome.specification.XMLMockObjects;
import ome.specification.XMLWriter;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import spec.AbstractTest;

public class Schema_Transform_Test
extends AbstractTest {
    public static final String OME_XML = "ome.xml";
    private static final String CATALOG = "ome-transforms.xml";
    private static final String UNITS_CONVERSION = "units-conversion.xsl";
    private static final String CURRENT = "current";
    private static final String SCHEMA = "schema";
    private static final String TARGET = "target";
    private static final String TRANSFORM = "transform";
    private static final String SOURCE = "source";
    private static final String FILE = "file";
    private static final int IMAGE = 0;
    private static final int SIMPLE_IMAGE = 1;
    private static final int IMAGE_ROI = 2;
    private static final int IMAGE_ANNOTATED_DATA = 2;
    private Map<String, List<String>> downgrades;
    private Map<String, List<String>> upgrades;
    private String currentSchema;
    private boolean windowsOS;
    private MetadataStore metadata;
    private ServiceFactory factory;
    private OMEXMLService service;
    private IFormatReader reader;

    private void validate(File input) throws Exception {
        OmeValidator validator = new OmeValidator();
        validator.parseFile(input);
    }

    private File applyTransforms(File inputXML, List<InputStream> transforms) throws Exception {
        Iterator<InputStream> i = transforms.iterator();
        InputStream in = null;
        OutputStream out = null;
        Resolver resolver = null;
        while (i.hasNext()) {
            InputStream stream = i.next();
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                resolver = new Resolver();
                factory.setURIResolver(resolver);
                File output = File.createTempFile("tempFileName", ".ome.xml");
                output.deleteOnExit();
                StreamSource src = new StreamSource(stream);
                Templates template = factory.newTemplates(src);
                Transformer transformer = template.newTransformer();
                transformer.setParameter("encoding", "UTF-8");
                out = new FileOutputStream(output);
                in = new FileInputStream(inputXML);
                transformer.transform(new StreamSource(in), new StreamResult(out));
                inputXML = output;
            }
            catch (Exception e) {
                throw new Exception("Cannot apply transform", e);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (resolver == null) continue;
                resolver.close();
            }
        }
        return inputXML;
    }

    @Override
    @BeforeClass
    protected void setUp() throws Exception {
        super.setUp();
        this.upgrades = new HashMap<String, List<String>>();
        this.downgrades = this.currentSchema();
        this.windowsOS = System.getProperty("os.name").toLowerCase().indexOf("windows") > -1;
        this.factory = new ServiceFactory();
        this.service = (OMEXMLService)this.factory.getInstance(OMEXMLService.class);
        this.metadata = this.service.createOMEXMLMetadata();
        this.reader = new ImageReader();
        this.reader.setMetadataStore(this.metadata);
    }

    @Override
    @AfterClass
    public void tearDown() throws Exception {
        this.downgrades.clear();
        this.upgrades.clear();
        this.reader.close();
    }

    private File createImageFile(int index) throws Exception {
        File f = File.createTempFile("tempFileName", ".ome.xml");
        XMLMockObjects xml = new XMLMockObjects();
        XMLWriter writer = new XMLWriter();
        if (index == 2) {
            writer.writeFile(f, xml.createImageWithROI(), true);
        } else if (index == 2) {
            writer.writeFile(f, xml.createImageWithAnnotatedAcquisitionData(), true);
        } else {
            writer.writeFile(f, xml.createImageWithAcquisitionData(), true);
        }
        return f;
    }

    private void parseTarget(Element node, Map<String, List<String>> sheets) {
        NamedNodeMap map = node.getAttributes();
        String schema = null;
        ArrayList<String> list = null;
        for (int j = 0; j < map.getLength(); ++j) {
            Node attribute = map.item(j);
            schema = attribute.getNodeValue();
            NodeList transforms = node.getElementsByTagName(TRANSFORM);
            list = new ArrayList<String>();
            for (int i = 0; i < transforms.getLength(); ++i) {
                NamedNodeMap m = transforms.item(i).getAttributes();
                for (int k = 0; k < m.getLength(); ++k) {
                    attribute = m.item(k);
                    if (!FILE.equals(attribute.getNodeName())) continue;
                    list.add(attribute.getNodeValue());
                }
            }
        }
        if (!schema.trim().isEmpty() && !list.isEmpty()) {
            sheets.put(schema, (List<String>)list);
        }
    }

    private Map<String, List<String>> extractCurrentSchema(String schema, Document document) throws Exception {
        NodeList list = document.getElementsByTagName(SOURCE);
        HashMap<String, List<String>> transforms = new HashMap<String, List<String>>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element n = (Element)list.item(i);
            NamedNodeMap map = n.getAttributes();
            for (int j = 0; j < map.getLength(); ++j) {
                Node attribute = map.item(j);
                if (!SCHEMA.equals(attribute.getNodeName())) continue;
                if (schema.equals(attribute.getNodeValue())) {
                    NodeList t = n.getElementsByTagName(TARGET);
                    for (int k = 0; k < t.getLength(); ++k) {
                        this.parseTarget((Element)t.item(k), transforms);
                    }
                    continue;
                }
                NodeList nl = n.getElementsByTagName("upgrades");
                HashMap<String, List<String>> umap = new HashMap<String, List<String>>();
                String src = attribute.getNodeValue();
                for (int k = 0; k < nl.getLength(); ++k) {
                    Element node = (Element)nl.item(k);
                    NodeList tt = node.getElementsByTagName(TARGET);
                    for (int l = 0; l < tt.getLength(); ++l) {
                        this.parseTarget((Element)tt.item(l), umap);
                    }
                    for (Map.Entry e : umap.entrySet()) {
                        if (!((String)e.getKey()).equals(schema)) continue;
                        this.upgrades.put(src, (List)e.getValue());
                    }
                }
            }
        }
        return transforms;
    }

    private Map<String, List<String>> currentSchema() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try (InputStream stream = this.getStream(CATALOG);){
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.parse(stream);
            this.currentSchema = doc.getDocumentElement().getAttribute(CURRENT);
            if (this.currentSchema.trim().isEmpty()) {
                throw new Exception("No schema specified.");
            }
            Map<String, List<String>> map = this.extractCurrentSchema(this.currentSchema, doc);
            return map;
        }
    }

    private Object[][] createList(Map<String, List<String>> values) throws Exception {
        ArrayList<Target> targets = new ArrayList<Target>();
        Object[][] data = null;
        for (Map.Entry<String, List<String>> e : values.entrySet()) {
            List<String> l = e.getValue();
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            Iterator<String> j = l.iterator();
            while (j.hasNext()) {
                streams.add(this.getStream(j.next()));
            }
            targets.add(new Target(streams, e.getKey()));
        }
        int index = 0;
        Iterator k = targets.iterator();
        data = new Object[targets.size()][1];
        while (k.hasNext()) {
            data[index][0] = k.next();
            ++index;
        }
        return data;
    }

    @DataProvider(name="createTransform")
    public Object[][] createTransform() throws Exception {
        return this.createList(this.downgrades);
    }

    @DataProvider(name="createUpgrade")
    public Object[][] createUpgrade() throws Exception {
        return this.createList(this.upgrades);
    }

    private InputStream getStream(String name) {
        if (this.windowsOS) {
            return this.getClass().getClassLoader().getResourceAsStream("transforms/" + name);
        }
        return this.getClass().getResourceAsStream("/transforms/" + name);
    }

    private List<InputStream> retrieveDowngrade(String target) {
        List<String> list = this.downgrades.get(target);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        Iterator<String> j = list.iterator();
        while (j.hasNext()) {
            streams.add(this.getStream(j.next()));
        }
        return streams;
    }

    @Test(dataProvider="createTransform")
    public void testDowngradeImageWithAcquisition(Target target) throws Exception {
        File f = null;
        File transformed = null;
        try {
            f = this.createImageFile(0);
            transformed = this.applyTransforms(f, target.getTransforms());
            this.validate(transformed);
            this.reader.setId(transformed.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot downgrade image: " + target.getSource(), e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
        }
    }

    @Test(dataProvider="createTransform")
    public void testDowngradeImageWithROI(Target target) throws Exception {
        File f = null;
        File transformed = null;
        try {
            f = this.createImageFile(2);
            transformed = this.applyTransforms(f, target.getTransforms());
            this.validate(transformed);
            this.reader.setId(transformed.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot downgrade image: " + target.getSource(), e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
        }
    }

    @Test(dataProvider="createTransform")
    public void testDowngradeImageWithAnnotatedAcquisitionData(Target target) throws Exception {
        File f = null;
        File transformed = null;
        try {
            f = this.createImageFile(2);
            transformed = this.applyTransforms(f, target.getTransforms());
            this.validate(transformed);
            this.reader.setId(transformed.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot downgrade image: " + target.getSource(), e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
        }
    }

    public void testValidateImageWithAcquisition() throws Exception {
        File f = null;
        try {
            f = this.createImageFile(0);
            this.validate(f);
            this.reader.setId(f.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot validate the image: ", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public void testValidateImageWithROI() throws Exception {
        File f = null;
        try {
            f = this.createImageFile(2);
            this.validate(f);
            this.reader.setId(f.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot validate the image: ", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    public void testValidateImageWithAnnotatedAcquisition() throws Exception {
        File f = null;
        try {
            f = this.createImageFile(2);
            this.validate(f);
            this.reader.setId(f.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot validate the image: ", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
        }
    }

    @Test(dataProvider="createUpgrade")
    public void testUpgradeImageWithAcquisition(Target target) throws Exception {
        File f = null;
        File transformed = null;
        File upgraded = null;
        try {
            f = this.createImageFile(0);
            List<InputStream> transforms = this.retrieveDowngrade(target.getSource());
            transformed = this.applyTransforms(f, transforms);
            upgraded = this.applyTransforms(transformed, target.getTransforms());
            this.validate(upgraded);
            this.reader.setId(upgraded.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot upgrade image: " + target.getSource(), e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
            if (upgraded != null) {
                upgraded.delete();
            }
        }
    }

    @Test(dataProvider="createUpgrade")
    public void testUpgradeImageWithROI(Target target) throws Exception {
        File f = null;
        File transformed = null;
        File upgraded = null;
        try {
            f = this.createImageFile(2);
            List<InputStream> transforms = this.retrieveDowngrade(target.getSource());
            transformed = this.applyTransforms(f, transforms);
            upgraded = this.applyTransforms(transformed, target.getTransforms());
            this.validate(upgraded);
            this.reader.setId(upgraded.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot upgrade image: " + target.getSource(), e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
            if (upgraded != null) {
                upgraded.delete();
            }
        }
    }

    @Test(dataProvider="createUpgrade")
    public void testUpgradeImageWithAnnotatedAcquisition(Target target) throws Exception {
        File f = null;
        File transformed = null;
        File upgraded = null;
        try {
            f = this.createImageFile(2);
            List<InputStream> transforms = this.retrieveDowngrade(target.getSource());
            transformed = this.applyTransforms(f, transforms);
            upgraded = this.applyTransforms(transformed, target.getTransforms());
            this.validate(upgraded);
            this.reader.setId(upgraded.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot upgrade image: " + target.getSource(), e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
            if (upgraded != null) {
                upgraded.delete();
            }
        }
    }

    public void testUpgradeImage2003FCto200809() throws Exception {
        File f = null;
        File transformed = null;
        File upgraded = null;
        try {
            f = this.createImageFile(0);
            List<InputStream> transforms = this.retrieveDowngrade("2003-FC");
            transformed = this.applyTransforms(f, transforms);
            ArrayList<InputStream> upgrades = new ArrayList<InputStream>();
            upgrades.add(this.getStream("2003-FC-to-2008-09.xsl"));
            upgraded = this.applyTransforms(transformed, upgrades);
            this.validate(upgraded);
            this.reader.setId(upgraded.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot transform image to 2008-09", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
            if (upgraded != null) {
                upgraded.delete();
            }
        }
    }

    public void testUpgradeImage200706to200802() throws Exception {
        File f = null;
        File transformed = null;
        File upgraded = null;
        try {
            f = this.createImageFile(0);
            List<InputStream> transforms = this.retrieveDowngrade("2007-06");
            transformed = this.applyTransforms(f, transforms);
            ArrayList<InputStream> upgrades = new ArrayList<InputStream>();
            upgrades.add(this.getStream("2007-06-to-2008-02.xsl"));
            upgraded = this.applyTransforms(transformed, upgrades);
            this.validate(upgraded);
            this.reader.setId(upgraded.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot transform image to 2008-02", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
            if (upgraded != null) {
                upgraded.delete();
            }
        }
    }

    public void testUpgradeImage200706to200809() throws Exception {
        File f = null;
        File transformed = null;
        File upgraded = null;
        try {
            f = this.createImageFile(0);
            List<InputStream> transforms = this.retrieveDowngrade("2007-06");
            transformed = this.applyTransforms(f, transforms);
            ArrayList<InputStream> upgrades = new ArrayList<InputStream>();
            upgrades.add(this.getStream("2007-06-to-2008-09.xsl"));
            upgraded = this.applyTransforms(transformed, upgrades);
            this.validate(upgraded);
            this.reader.setId(upgraded.getPath());
        }
        catch (Throwable e) {
            throw new Exception("Cannot transform image to 2008-09", e);
        }
        finally {
            if (f != null) {
                f.delete();
            }
            if (transformed != null) {
                transformed.delete();
            }
            if (upgraded != null) {
                upgraded.delete();
            }
        }
    }

    class Resolver
    implements URIResolver {
        private InputStream stream;

        Resolver() {
        }

        public void close() throws Exception {
            if (this.stream != null) {
                this.stream.close();
            }
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            this.stream = Schema_Transform_Test.this.getStream(Schema_Transform_Test.UNITS_CONVERSION);
            return new StreamSource(this.stream);
        }
    }

    class Target {
        private List<InputStream> transforms;
        private String source;

        Target(List<InputStream> transforms, String source) {
            this.transforms = transforms;
            this.source = source;
        }

        List<InputStream> getTransforms() {
            return this.transforms;
        }

        String getSource() {
            return this.source;
        }
    }
}

