/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.in;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.xml.XMLTools;
import loci.formats.in.PrairieMetadata;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PrairieMetadataTest {
    private static final String OLD_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><PVScan version=\"4.0.0.53\" date=\"3/23/2012 9:47:15 AM\" notes=\"\">  <Sequence type=\"TSeries ZSeries Element\" cycle=\"1\" >    <Frame relativeTime=\"0\" absoluteTime=\"2.06929400000001\" index=\"1\" label=\"CurrentSettings\">      <File channel=\"1\" channelName=\"Ch1\" preAmpID=\"0\" filename=\"TSeries-03232012-0934-006_Cycle001_CurrentSettings_Ch1_000001.tif\" />      <File channel=\"2\" channelName=\"Ch2\" preAmpID=\"1\" filename=\"TSeries-03232012-0934-006_Cycle001_CurrentSettings_Ch2_000001.tif\" />      <ExtraParameters validData=\"True\" />      <PVStateShard>        <Key key=\"linesPerFrame\" permissions=\"Read, Write, Save\" value=\"186\" />        <Key key=\"pmtGain_0\" permissions=\"Write, Save\" value=\"605\" />        <Key key=\"pmtGain_1\" permissions=\"Write, Save\" value=\"604\" />        <Key key=\"pmtGain_2\" permissions=\"Write, Save\" value=\"0\" />        <Key key=\"positionCurrent_XAxis\" permissions=\"Write, Save\" value=\"0.95\" />        <Key key=\"positionCurrent_YAxis\" permissions=\"Write, Save\" value=\"-4.45\" />        <Key key=\"positionCurrent_ZAxis\" permissions=\"Write, Save\" value=\"-9,62.45\" />      </PVStateShard>    </Frame>  </Sequence></PVScan>";
    private static final String NEW_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><PVScan version=\"5.2.64.400\" date=\"9/23/2014 3:03:37 PM\" notes=\"\">  <PVStateShard>    <PVStateValue key=\"linesPerFrame\" value=\"186\" />    <PVStateValue key=\"pmtGain\">        <IndexedValue index=\"0\" value=\"605\" description=\"Ch1 High Voltage\" />        <IndexedValue index=\"1\" value=\"604\" description=\"Ch2 High Voltage\" />        <IndexedValue index=\"2\" value=\"0\" description=\"Ch3 High Voltage\" />    </PVStateValue>    <PVStateValue key=\"positionCurrent\">        <SubindexedValues index=\"XAxis\">            <SubindexedValue subindex=\"0\" value=\"0.95\" />        </SubindexedValues>        <SubindexedValues index=\"YAxis\">            <SubindexedValue subindex=\"0\" value=\"-4.45\" />        </SubindexedValues>        <SubindexedValues index=\"ZAxis\">            <SubindexedValue subindex=\"0\" value=\"-9\" description=\"Focus\" />            <SubindexedValue subindex=\"1\" value=\"62.45\" description=\"Piezo\" />        </SubindexedValues>    </PVStateValue>  </PVStateShard>  <Sequence type=\"TSeries Timed Element\" cycle=\"1\" time=\"15:03:38.0036337\">    <PVStateShard>      <PVStateValue key=\"positionCurrent\">        <SubindexedValues index=\"XAxis\">          <SubindexedValue subindex=\"0\" value=\"-621.412879412341\" />        </SubindexedValues>        <SubindexedValues index=\"YAxis\">          <SubindexedValue subindex=\"0\" value=\"255.652372573538\" />        </SubindexedValues>        <SubindexedValues index=\"ZAxis\">          <SubindexedValue subindex=\"0\" value=\"28.15\" description=\"Z\" />          <SubindexedValue subindex=\"1\" value=\"111.23\" description=\"ZPiezo\" />        </SubindexedValues>      </PVStateValue>    </PVStateShard>    <Frame relativeTime=\"0\" absoluteTime=\"1.2349999999999\" index=\"1\" parameterSet=\"CurrentSettings\">      <File channel=\"1\" channelName=\"Ch1 Red\" filename=\"TSeries-09232014-1445-011_Cycle00001_Ch1_000001.ome.tif\" />      <ExtraParameters lastGoodFrame=\"0\" />      <PVStateShard />    </Frame>  </Sequence></PVScan>";

    @Test
    public void testParseOldXML() throws ParserConfigurationException, SAXException, IOException {
        Document xml = XMLTools.parseDOM((String)OLD_XML);
        PrairieMetadata meta = new PrairieMetadata(xml, null, null);
        PrairieMetadata.Value positionCurrent = meta.getSequence(1).getFrame(1).getValue("positionCurrent");
        PrairieMetadata.Value xAxis = positionCurrent.get((Object)"XAxis");
        AssertJUnit.assertEquals((String)"0.95", (String)xAxis.value());
        PrairieMetadata.Value yAxis = positionCurrent.get((Object)"YAxis");
        AssertJUnit.assertEquals((String)"-4.45", (String)yAxis.value());
        PrairieMetadata.ValueTable zAxis = (PrairieMetadata.ValueTable)positionCurrent.get((Object)"ZAxis");
        AssertJUnit.assertEquals((String)"-9", (String)zAxis.get(0).value());
        AssertJUnit.assertEquals((String)"62.45", (String)zAxis.get(1).value());
    }

    @Test
    public void testParseNewXML() throws ParserConfigurationException, SAXException, IOException {
        Document xml = XMLTools.parseDOM((String)NEW_XML);
        PrairieMetadata meta = new PrairieMetadata(xml, null, null);
        PrairieMetadata.ValueTable positionCurrent = (PrairieMetadata.ValueTable)meta.getSequence(1).getFrame(1).getValue("positionCurrent");
        PrairieMetadata.ValueTable xAxis = (PrairieMetadata.ValueTable)positionCurrent.get((Object)"XAxis");
        AssertJUnit.assertEquals((String)"-621.412879412341", (String)xAxis.value());
        PrairieMetadata.ValueTable yAxis = (PrairieMetadata.ValueTable)positionCurrent.get((Object)"YAxis");
        AssertJUnit.assertEquals((String)"255.652372573538", (String)yAxis.value());
        PrairieMetadata.ValueTable zAxis = (PrairieMetadata.ValueTable)positionCurrent.get((Object)"ZAxis");
        AssertJUnit.assertEquals((String)"28.15", (String)zAxis.get(0).value());
        AssertJUnit.assertEquals((String)"111.23", (String)zAxis.get(1).value());
    }
}

