/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.Arrays;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;

public class StructureDataFactory {
    public static StructureData make(String name, Object value) {
        StructureMembers.Builder builder = StructureMembers.builder();
        DataType dtype = DataType.getType(value.getClass(), false);
        builder.addMember(name, null, null, dtype, new int[]{1});
        StructureMembers sm = builder.build();
        StructureDataW sw = new StructureDataW(sm);
        Array dataArray = Array.factory(dtype, new int[]{1});
        dataArray.setObject(dataArray.getIndex(), value);
        sw.setMemberData(sm.findMember(name), dataArray);
        return sw;
    }

    public static StructureData make(StructureData ... sdatas) {
        if (sdatas.length == 1) {
            return sdatas[0];
        }
        int count = 0;
        StructureData result = null;
        for (StructureData sdata : sdatas) {
            if (sdata == null) continue;
            ++count;
            result = sdata;
        }
        if (count == 1) {
            return result;
        }
        return StructureDataComposite.create(Arrays.asList(sdatas));
    }

    public static StructureData make(Iterable<StructureData> sdatas) {
        int count = 0;
        StructureData result = null;
        for (StructureData sdata : sdatas) {
            if (sdata == null) continue;
            ++count;
            result = sdata;
        }
        if (count == 1) {
            return result;
        }
        return StructureDataComposite.create(sdatas);
    }
}

