/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr;

import com.bc.zarr.Compressor;
import com.bc.zarr.CompressorFactory;
import com.bc.zarr.DataType;
import com.bc.zarr.DimensionSeparator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;

public class ZarrHeader {
    private final int[] chunks;
    private final Compressor compressor;
    private final String dimension_separator;
    private final String dtype;
    private final Number fill_value;
    private final String filters;
    private final String order = "C";
    private final int[] shape;
    private final int zarr_format = 2;

    public ZarrHeader(int[] shape, int[] chunks, String dtype, ByteOrder byteOrder, Number fill_value, Compressor compressor, String dimension_separator) {
        this.filters = null;
        this.chunks = chunks;
        this.compressor = compressor == null || CompressorFactory.nullCompressor.equals(compressor) ? null : compressor;
        int numBytes = Integer.parseInt(dtype.replaceAll("\\D", ""));
        this.dtype = numBytes > 1 ? this.translateByteOrder(byteOrder) + dtype : "|" + dtype;
        this.fill_value = fill_value;
        this.shape = shape;
        this.dimension_separator = dimension_separator != null ? dimension_separator : ".";
    }

    public int[] getChunks() {
        return this.chunks;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public String getDtype() {
        return this.dtype;
    }

    public DataType getRawDataType() {
        return ZarrHeader.getRawDataType(this.dtype);
    }

    private static DataType getRawDataType(String dtype) {
        dtype = dtype.replace(">", "");
        dtype = dtype.replace("<", "");
        dtype = dtype.replace("|", "");
        return DataType.valueOf(dtype);
    }

    public ByteOrder getByteOrder() {
        return ZarrHeader.getByteOrder(this.dtype);
    }

    private static ByteOrder getByteOrder(String dtype) {
        if (dtype.startsWith(">")) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (dtype.startsWith("<")) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        if (dtype.startsWith("|")) {
            return ByteOrder.nativeOrder();
        }
        return ByteOrder.BIG_ENDIAN;
    }

    private String translateByteOrder(ByteOrder order) {
        if (order == null) {
            order = ByteOrder.nativeOrder();
        }
        if (ByteOrder.BIG_ENDIAN.equals(order)) {
            return ">";
        }
        return "<";
    }

    public Number getFill_value() {
        return this.fill_value;
    }

    public int[] getShape() {
        return this.shape;
    }

    public String getDimension_separator() {
        return this.dimension_separator;
    }

    public DimensionSeparator getDimensionSeparator() {
        String separator = this.dimension_separator;
        for (DimensionSeparator sep : DimensionSeparator.values()) {
            if (!sep.getSeparatorChar().equals(separator)) continue;
            return sep;
        }
        return null;
    }

    static void register(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(ZarrHeader.class, new ZarrHeaderSerializer());
        simpleModule.addDeserializer(ZarrHeader.class, new ZarrHeaderDeSerializer());
        objectMapper.registerModules(simpleModule);
    }

    static class ZarrHeaderDeSerializer
    extends StdDeserializer<ZarrHeader> {
        protected ZarrHeaderDeSerializer() {
            super(ZarrHeader.class);
        }

        @Override
        public ZarrHeader deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            ObjectCodec codec = p.getCodec();
            Object root = codec.readTree(p);
            int[] shape = StreamSupport.stream(((ArrayNode)root.path("shape")).spliterator(), false).mapToInt(JsonNode::asInt).toArray();
            int[] chunks = StreamSupport.stream(((ArrayNode)root.path("chunks")).spliterator(), false).mapToInt(JsonNode::asInt).toArray();
            String dtype = ((JsonNode)root.path("dtype")).asText();
            JsonNode fillValueNode = (JsonNode)root.path("fill_value");
            Number fill = fillValueNode.isLong() ? (Number)fillValueNode.longValue() : (Number)(fillValueNode.isFloat() ? (Number)Float.valueOf(fillValueNode.floatValue()) : (Number)fillValueNode.asDouble());
            Map compBean = codec.readValue(root.path("compressor").traverse(codec), HashMap.class);
            Compressor compressor = compBean == null ? CompressorFactory.nullCompressor : CompressorFactory.create(compBean);
            JsonNode separatorNode = (JsonNode)root.path("dimension_separator");
            String dimension_separator = null;
            if (separatorNode != null) {
                dimension_separator = separatorNode.asText();
            }
            return new ZarrHeader(shape, chunks, ZarrHeader.getRawDataType(dtype).toString(), ZarrHeader.getByteOrder(dtype), fill, compressor, dimension_separator);
        }
    }

    static class ZarrHeaderSerializer
    extends StdSerializer<ZarrHeader> {
        protected ZarrHeaderSerializer() {
            super(ZarrHeader.class);
        }

        @Override
        public void serialize(ZarrHeader value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            gen.writeObjectField("chunks", value.getChunks());
            gen.writeFieldName("compressor");
            gen.writeObject(value.getCompressor());
            gen.writeStringField("dtype", value.getDtype());
            gen.writeObjectField("fill_value", value.getFill_value());
            gen.writeObjectField("filters", value.filters);
            gen.writeObjectField("order", "C");
            gen.writeObjectField("shape", value.getShape());
            gen.writeStringField("dimension_separator", value.getDimension_separator());
            gen.writeNumberField("zarr_format", 2);
            gen.writeEndObject();
        }
    }
}

