/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.Parameter;

public class HybridHeight
extends VerticalTransformImpl {
    public static final String OROG = "Orography_variableName";
    public static final String A = "A_variableName";
    public static final String B = "B_variableName";
    private Variable aVar;
    private Variable bVar;
    private Variable orogVar;
    private Array aArray;
    private Array bArray;

    public HybridHeight(NetcdfFile ds, Dimension timeDim, List<Parameter> params) {
        super(timeDim);
        String aName = this.getParameterStringValue(params, A);
        String bName = this.getParameterStringValue(params, B);
        String orogName = this.getParameterStringValue(params, OROG);
        this.aVar = ds.findVariable(aName);
        this.bVar = ds.findVariable(bName);
        this.orogVar = ds.findVariable(orogName);
        this.units = this.orogVar.findAttValueIgnoreCase("units", "none");
    }

    @Override
    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array orogArray = this.readArray(this.orogVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        int[] shape2D = orogArray.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index orogIndex = orogArray.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double az = this.aArray.getDouble(aIndex.set(z));
            double bz = this.bArray.getDouble(bIndex.set(z));
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double orog = orogArray.getDouble(orogIndex.set(y, x));
                    height.set(z, y, x, az + bz * orog);
                }
            }
        }
        return height;
    }

    @Override
    public ArrayDouble.D1 getCoordinateArray1D(int timeIndex, int xIndex, int yIndex) throws IOException, InvalidRangeException {
        Array orogArray = this.readArray(this.orogVar, timeIndex);
        if (null == this.aArray) {
            this.aArray = this.aVar.read();
            this.bArray = this.bVar.read();
        }
        int nz = (int)this.aArray.getSize();
        Index aIndex = this.aArray.getIndex();
        Index bIndex = this.bArray.getIndex();
        Index orogIndex = orogArray.getIndex();
        ArrayDouble.D1 height = new ArrayDouble.D1(nz);
        for (int z = 0; z < nz; ++z) {
            double az = this.aArray.getDouble(aIndex.set(z));
            double bz = this.bArray.getDouble(bIndex.set(z));
            double orog = orogArray.getDouble(orogIndex.set(yIndex, xIndex));
            height.set(z, az + bz * orog);
        }
        return height;
    }
}

