/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.utests;

import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataStore;
import ome.xml.meta.OMEXMLMetadataImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReferenceIndexingTest {
    private OMEXMLMetadataImpl meta;

    @BeforeMethod
    public void setUp() {
        this.meta = new OMEXMLMetadataImpl();
    }

    @Test
    public void testAppendImageROIReferences() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setROIID("ROI:0", 0);
        this.meta.setROIID("ROI:1", 1);
        this.meta.setROIID("ROI:2", 2);
        this.meta.setImageROIRef("ROI:0", 0, 0);
        this.meta.setImageROIRef("ROI:1", 0, 1);
        this.meta.setImageROIRef("ROI:2", 0, 2);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageROIRefCount(0));
        AssertJUnit.assertEquals((String)"ROI:0", (String)this.meta.getImageROIRef(0, 0));
        AssertJUnit.assertEquals((String)"ROI:1", (String)this.meta.getImageROIRef(0, 1));
        AssertJUnit.assertEquals((String)"ROI:2", (String)this.meta.getImageROIRef(0, 2));
    }

    @Test
    public void testReplaceImageROIReferences() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setROIID("ROI:0", 0);
        this.meta.setROIID("ROI:1", 1);
        this.meta.setROIID("ROI:2", 2);
        this.meta.setROIID("ROI:3", 3);
        this.meta.setImageROIRef("ROI:0", 0, 0);
        this.meta.setImageROIRef("ROI:1", 0, 1);
        this.meta.setImageROIRef("ROI:2", 0, 2);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageROIRefCount(0));
        this.meta.setImageROIRef("ROI:3", 0, 1);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageROIRefCount(0));
        AssertJUnit.assertEquals((String)"ROI:0", (String)this.meta.getImageROIRef(0, 0));
        AssertJUnit.assertEquals((String)"ROI:3", (String)this.meta.getImageROIRef(0, 1));
        AssertJUnit.assertEquals((String)"ROI:2", (String)this.meta.getImageROIRef(0, 2));
    }

    @Test
    public void testROIReferencesAfterConversion() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setROIID("ROI:0", 0);
        this.meta.setROIID("ROI:1", 1);
        this.meta.setImageROIRef("ROI:0", 0, 0);
        this.meta.setImageROIRef("ROI:1", 0, 1);
        AssertJUnit.assertEquals((int)2, (int)this.meta.getImageROIRefCount(0));
        OMEXMLMetadataImpl out = new OMEXMLMetadataImpl();
        MetadataConverter.convertMetadata((MetadataRetrieve)this.meta, (MetadataStore)out);
        AssertJUnit.assertEquals((int)2, (int)out.getImageROIRefCount(0));
        AssertJUnit.assertEquals((String)"ROI:0", (String)out.getImageROIRef(0, 0));
        AssertJUnit.assertEquals((String)"ROI:1", (String)out.getImageROIRef(0, 1));
    }

    @Test
    public void testAppendImageAnnotationReferences() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setCommentAnnotationID("Annotation:0", 0);
        this.meta.setCommentAnnotationID("Annotation:1", 1);
        this.meta.setCommentAnnotationID("Annotation:2", 2);
        this.meta.setImageAnnotationRef("Annotation:0", 0, 0);
        this.meta.setImageAnnotationRef("Annotation:1", 0, 1);
        this.meta.setImageAnnotationRef("Annotation:2", 0, 2);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageAnnotationRefCount(0));
        AssertJUnit.assertEquals((String)"Annotation:0", (String)this.meta.getImageAnnotationRef(0, 0));
        AssertJUnit.assertEquals((String)"Annotation:1", (String)this.meta.getImageAnnotationRef(0, 1));
        AssertJUnit.assertEquals((String)"Annotation:2", (String)this.meta.getImageAnnotationRef(0, 2));
    }

    @Test
    public void testReplaceImageAnnotationReferences() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setCommentAnnotationID("Annotation:0", 0);
        this.meta.setCommentAnnotationID("Annotation:1", 1);
        this.meta.setCommentAnnotationID("Annotation:2", 2);
        this.meta.setCommentAnnotationID("Annotation:3", 3);
        this.meta.setImageAnnotationRef("Annotation:0", 0, 0);
        this.meta.setImageAnnotationRef("Annotation:1", 0, 1);
        this.meta.setImageAnnotationRef("Annotation:2", 0, 2);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageAnnotationRefCount(0));
        this.meta.setImageAnnotationRef("Annotation:3", 0, 0);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageAnnotationRefCount(0));
        AssertJUnit.assertEquals((String)"Annotation:3", (String)this.meta.getImageAnnotationRef(0, 0));
        AssertJUnit.assertEquals((String)"Annotation:1", (String)this.meta.getImageAnnotationRef(0, 1));
        AssertJUnit.assertEquals((String)"Annotation:2", (String)this.meta.getImageAnnotationRef(0, 2));
    }

    @Test
    public void testMultipleImagesWithROIReferences() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setImageID("Image:1", 1);
        this.meta.setROIID("ROI:0", 0);
        this.meta.setROIID("ROI:1", 1);
        this.meta.setROIID("ROI:2", 2);
        this.meta.setImageROIRef("ROI:0", 0, 0);
        this.meta.setImageROIRef("ROI:1", 0, 1);
        this.meta.setImageROIRef("ROI:1", 1, 0);
        this.meta.setImageROIRef("ROI:2", 1, 1);
        AssertJUnit.assertEquals((int)2, (int)this.meta.getImageROIRefCount(0));
        AssertJUnit.assertEquals((int)2, (int)this.meta.getImageROIRefCount(1));
        AssertJUnit.assertEquals((String)"ROI:0", (String)this.meta.getImageROIRef(0, 0));
        AssertJUnit.assertEquals((String)"ROI:1", (String)this.meta.getImageROIRef(0, 1));
        AssertJUnit.assertEquals((String)"ROI:1", (String)this.meta.getImageROIRef(1, 0));
        AssertJUnit.assertEquals((String)"ROI:2", (String)this.meta.getImageROIRef(1, 1));
    }

    @Test
    public void testMixedAppendAndReplace() {
        this.meta.setImageID("Image:0", 0);
        this.meta.setROIID("ROI:0", 0);
        this.meta.setROIID("ROI:1", 1);
        this.meta.setROIID("ROI:2", 2);
        this.meta.setROIID("ROI:3", 3);
        this.meta.setImageROIRef("ROI:0", 0, 0);
        this.meta.setImageROIRef("ROI:1", 0, 1);
        AssertJUnit.assertEquals((int)2, (int)this.meta.getImageROIRefCount(0));
        this.meta.setImageROIRef("ROI:2", 0, 0);
        AssertJUnit.assertEquals((int)2, (int)this.meta.getImageROIRefCount(0));
        this.meta.setImageROIRef("ROI:3", 0, 2);
        AssertJUnit.assertEquals((int)3, (int)this.meta.getImageROIRefCount(0));
        AssertJUnit.assertEquals((String)"ROI:2", (String)this.meta.getImageROIRef(0, 0));
        AssertJUnit.assertEquals((String)"ROI:1", (String)this.meta.getImageROIRef(0, 1));
        AssertJUnit.assertEquals((String)"ROI:3", (String)this.meta.getImageROIRef(0, 2));
    }
}

