/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import loci.poi.hssf.record.AbstractEscherHolderRecord;
import loci.poi.hssf.record.BOFRecord;
import loci.poi.hssf.record.BackupRecord;
import loci.poi.hssf.record.BlankRecord;
import loci.poi.hssf.record.BookBoolRecord;
import loci.poi.hssf.record.BoolErrRecord;
import loci.poi.hssf.record.BottomMarginRecord;
import loci.poi.hssf.record.BoundSheetRecord;
import loci.poi.hssf.record.CalcCountRecord;
import loci.poi.hssf.record.CalcModeRecord;
import loci.poi.hssf.record.CodepageRecord;
import loci.poi.hssf.record.ColumnInfoRecord;
import loci.poi.hssf.record.ContinueRecord;
import loci.poi.hssf.record.CountryRecord;
import loci.poi.hssf.record.DBCellRecord;
import loci.poi.hssf.record.DSFRecord;
import loci.poi.hssf.record.DateWindow1904Record;
import loci.poi.hssf.record.DefaultColWidthRecord;
import loci.poi.hssf.record.DefaultRowHeightRecord;
import loci.poi.hssf.record.DeltaRecord;
import loci.poi.hssf.record.DimensionsRecord;
import loci.poi.hssf.record.DrawingGroupRecord;
import loci.poi.hssf.record.DrawingRecord;
import loci.poi.hssf.record.DrawingSelectionRecord;
import loci.poi.hssf.record.EOFRecord;
import loci.poi.hssf.record.ExtSSTRecord;
import loci.poi.hssf.record.ExtendedFormatRecord;
import loci.poi.hssf.record.ExternSheetRecord;
import loci.poi.hssf.record.FilePassRecord;
import loci.poi.hssf.record.FileSharingRecord;
import loci.poi.hssf.record.FnGroupCountRecord;
import loci.poi.hssf.record.FontRecord;
import loci.poi.hssf.record.FooterRecord;
import loci.poi.hssf.record.FormatRecord;
import loci.poi.hssf.record.FormulaRecord;
import loci.poi.hssf.record.GridsetRecord;
import loci.poi.hssf.record.GutsRecord;
import loci.poi.hssf.record.HCenterRecord;
import loci.poi.hssf.record.HeaderRecord;
import loci.poi.hssf.record.HideObjRecord;
import loci.poi.hssf.record.HorizontalPageBreakRecord;
import loci.poi.hssf.record.IndexRecord;
import loci.poi.hssf.record.InterfaceEndRecord;
import loci.poi.hssf.record.InterfaceHdrRecord;
import loci.poi.hssf.record.IterationRecord;
import loci.poi.hssf.record.LabelRecord;
import loci.poi.hssf.record.LabelSSTRecord;
import loci.poi.hssf.record.LeftMarginRecord;
import loci.poi.hssf.record.MMSRecord;
import loci.poi.hssf.record.MergeCellsRecord;
import loci.poi.hssf.record.MulBlankRecord;
import loci.poi.hssf.record.MulRKRecord;
import loci.poi.hssf.record.NameRecord;
import loci.poi.hssf.record.NoteRecord;
import loci.poi.hssf.record.NumberRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.hssf.record.ObjectProtectRecord;
import loci.poi.hssf.record.PaletteRecord;
import loci.poi.hssf.record.PaneRecord;
import loci.poi.hssf.record.PasswordRecord;
import loci.poi.hssf.record.PasswordRev4Record;
import loci.poi.hssf.record.PrecisionRecord;
import loci.poi.hssf.record.PrintGridlinesRecord;
import loci.poi.hssf.record.PrintHeadersRecord;
import loci.poi.hssf.record.PrintSetupRecord;
import loci.poi.hssf.record.ProtectRecord;
import loci.poi.hssf.record.ProtectionRev4Record;
import loci.poi.hssf.record.RKRecord;
import loci.poi.hssf.record.RecalcIdRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RecordFormatException;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.RefModeRecord;
import loci.poi.hssf.record.RefreshAllRecord;
import loci.poi.hssf.record.RightMarginRecord;
import loci.poi.hssf.record.RowRecord;
import loci.poi.hssf.record.SSTRecord;
import loci.poi.hssf.record.SaveRecalcRecord;
import loci.poi.hssf.record.ScenarioProtectRecord;
import loci.poi.hssf.record.SelectionRecord;
import loci.poi.hssf.record.SharedFormulaRecord;
import loci.poi.hssf.record.StringRecord;
import loci.poi.hssf.record.StyleRecord;
import loci.poi.hssf.record.TabIdRecord;
import loci.poi.hssf.record.TextObjectRecord;
import loci.poi.hssf.record.TopMarginRecord;
import loci.poi.hssf.record.UnknownRecord;
import loci.poi.hssf.record.UseSelFSRecord;
import loci.poi.hssf.record.VCenterRecord;
import loci.poi.hssf.record.VerticalPageBreakRecord;
import loci.poi.hssf.record.WSBoolRecord;
import loci.poi.hssf.record.WindowOneRecord;
import loci.poi.hssf.record.WindowProtectRecord;
import loci.poi.hssf.record.WindowTwoRecord;
import loci.poi.hssf.record.WriteAccessRecord;
import loci.poi.hssf.record.WriteProtectRecord;

public class RecordFactory {
    private static int NUM_RECORDS = 10000;
    private static final Class[] records = new Class[]{BOFRecord.class, InterfaceHdrRecord.class, MMSRecord.class, InterfaceEndRecord.class, WriteAccessRecord.class, CodepageRecord.class, DSFRecord.class, TabIdRecord.class, FnGroupCountRecord.class, WindowProtectRecord.class, ProtectRecord.class, PasswordRecord.class, ProtectionRev4Record.class, PasswordRev4Record.class, WindowOneRecord.class, BackupRecord.class, HideObjRecord.class, DateWindow1904Record.class, PrecisionRecord.class, RefreshAllRecord.class, BookBoolRecord.class, FontRecord.class, FormatRecord.class, ExtendedFormatRecord.class, StyleRecord.class, UseSelFSRecord.class, BoundSheetRecord.class, CountryRecord.class, SSTRecord.class, ExtSSTRecord.class, EOFRecord.class, IndexRecord.class, CalcModeRecord.class, CalcCountRecord.class, RefModeRecord.class, IterationRecord.class, DeltaRecord.class, SaveRecalcRecord.class, PrintHeadersRecord.class, PrintGridlinesRecord.class, GridsetRecord.class, GutsRecord.class, DefaultRowHeightRecord.class, WSBoolRecord.class, HeaderRecord.class, FooterRecord.class, HCenterRecord.class, VCenterRecord.class, PrintSetupRecord.class, DefaultColWidthRecord.class, DimensionsRecord.class, RowRecord.class, LabelSSTRecord.class, RKRecord.class, NumberRecord.class, DBCellRecord.class, WindowTwoRecord.class, SelectionRecord.class, ContinueRecord.class, LabelRecord.class, BlankRecord.class, ColumnInfoRecord.class, MulRKRecord.class, MulBlankRecord.class, MergeCellsRecord.class, FormulaRecord.class, BoolErrRecord.class, ExternSheetRecord.class, NameRecord.class, LeftMarginRecord.class, RightMarginRecord.class, TopMarginRecord.class, BottomMarginRecord.class, DrawingRecord.class, DrawingGroupRecord.class, DrawingSelectionRecord.class, ObjRecord.class, TextObjectRecord.class, PaletteRecord.class, StringRecord.class, RecalcIdRecord.class, SharedFormulaRecord.class, HorizontalPageBreakRecord.class, VerticalPageBreakRecord.class, WriteProtectRecord.class, FilePassRecord.class, PaneRecord.class, NoteRecord.class, ObjectProtectRecord.class, ScenarioProtectRecord.class, FileSharingRecord.class};
    private static Map recordsMap = RecordFactory.recordsToMap(records);

    public static void setCapacity(int capacity) {
        NUM_RECORDS = capacity;
    }

    public static List createRecords(InputStream in) throws RecordFormatException {
        ArrayList<Record> records = new ArrayList<Record>(NUM_RECORDS);
        RecordInputStream recStream = new RecordInputStream(in);
        DrawingRecord lastDrawingRecord = new DrawingRecord();
        Record lastRecord = null;
        while (recStream.hasNextRecord()) {
            recStream.nextRecord();
            if (recStream.getSid() == 0) continue;
            Record[] recs = RecordFactory.createRecord(recStream);
            if (recs.length > 1) {
                for (int k = 0; k < recs.length; ++k) {
                    records.add(recs[k]);
                }
                continue;
            }
            Record record = recs[0];
            if (record == null) continue;
            if (record.getSid() == 235 && lastRecord instanceof DrawingGroupRecord) {
                DrawingGroupRecord lastDGRecord = (DrawingGroupRecord)lastRecord;
                lastDGRecord.join((AbstractEscherHolderRecord)record);
                continue;
            }
            if (record.getSid() == 60 && (lastRecord instanceof ObjRecord || lastRecord instanceof TextObjectRecord)) {
                lastDrawingRecord.processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60 && lastRecord instanceof DrawingGroupRecord) {
                ((DrawingGroupRecord)lastRecord).processContinueRecord(((ContinueRecord)record).getData());
                continue;
            }
            if (record.getSid() == 60) {
                if (lastRecord instanceof UnknownRecord) {
                    records.add(record);
                    continue;
                }
                throw new RecordFormatException("Unhandled Continue Record");
            }
            lastRecord = record;
            if (record instanceof DrawingRecord) {
                lastDrawingRecord = (DrawingRecord)record;
            }
            records.add(record);
        }
        return records;
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record retval;
        Record[] realretval = null;
        try {
            Constructor constructor = (Constructor)recordsMap.get(new Short(in.getSid()));
            retval = constructor != null ? (Record)constructor.newInstance(in) : new UnknownRecord(in);
        }
        catch (Exception introspectionException) {
            throw new RecordFormatException("Unable to construct record instance", introspectionException);
        }
        if (retval instanceof RKRecord) {
            RKRecord rk = (RKRecord)retval;
            NumberRecord num = new NumberRecord();
            num.setColumn(rk.getColumn());
            num.setRow(rk.getRow());
            num.setXFIndex(rk.getXFIndex());
            num.setValue(rk.getRKNumber());
            retval = num;
        } else if (retval instanceof DBCellRecord) {
            retval = null;
        } else if (retval instanceof MulRKRecord) {
            MulRKRecord mrk = (MulRKRecord)retval;
            realretval = new Record[mrk.getNumColumns()];
            for (int k = 0; k < mrk.getNumColumns(); ++k) {
                NumberRecord nr = new NumberRecord();
                nr.setColumn((short)(k + mrk.getFirstColumn()));
                nr.setRow(mrk.getRow());
                nr.setXFIndex(mrk.getXFAt(k));
                nr.setValue(mrk.getRKNumberAt(k));
                realretval[k] = nr;
            }
        } else if (retval instanceof MulBlankRecord) {
            MulBlankRecord mb = (MulBlankRecord)retval;
            realretval = new Record[mb.getNumColumns()];
            for (int k = 0; k < mb.getNumColumns(); ++k) {
                BlankRecord br = new BlankRecord();
                br.setColumn((short)(k + mb.getFirstColumn()));
                br.setRow(mb.getRow());
                br.setXFIndex(mb.getXFAt(k));
                realretval[k] = br;
            }
        }
        if (realretval == null) {
            realretval = new Record[]{retval};
        }
        return realretval;
    }

    public static short[] getAllKnownRecordSIDs() {
        short[] results = new short[recordsMap.size()];
        int i = 0;
        for (Short sid : recordsMap.keySet()) {
            results[i++] = sid;
        }
        return results;
    }

    private static Map recordsToMap(Class[] records) {
        HashMap result = new HashMap();
        for (int i = 0; i < records.length; ++i) {
            Constructor constructor;
            short sid;
            Class record = records[i];
            try {
                sid = record.getField("sid").getShort(null);
                constructor = record.getConstructor(RecordInputStream.class);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types", illegalArgumentException);
            }
            result.put(new Short(sid), constructor);
        }
        return result;
    }
}

