/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadIntTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 1, 15, -1, -1, 2, 0, 0, 0, 3, 15, -1, -1, 4, 0, 0, 0, 5, -1, -1, -1, -1, 0, 0, 0, 7, -1, -1, -1, -2};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadInt() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)0xFFFFF02, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)0xFFFFF04, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)-1, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)-2, (int)this.fileHandle.readInt());
    }

    @Test
    public void testSeekForwardReadInt() throws IOException {
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)0xFFFFF04, (int)this.fileHandle.readInt());
    }

    @Test
    public void testResetReadInt() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)0xFFFFF02, (int)this.fileHandle.readInt());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)0xFFFFF02, (int)this.fileHandle.readInt());
    }

    @Test
    public void testSeekBackReadInt() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readInt());
        AssertJUnit.assertEquals((int)0xFFFFF04, (int)this.fileHandle.readInt());
    }

    @Test
    public void testRandomAccessReadInt() throws IOException {
        this.testSeekForwardReadInt();
        this.testSeekBackReadInt();
        this.fileHandle.seek(0L);
        this.testResetReadInt();
    }
}

