/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.util.Misc;

public class NcStreamDataCol {
    private static Logger logger = LoggerFactory.getLogger(NcStreamDataCol.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NcStreamProto.DataCol encodeData2(String name, boolean isVlen, Section section, Array data) {
        NcStreamProto.DataCol.Builder builder = NcStreamProto.DataCol.newBuilder();
        DataType dataType = data.getDataType();
        builder.setName(name);
        builder.setDataType(NcStream.convertDataType(data.getDataType()));
        builder.setBigend(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN);
        builder.setVersion(3);
        if (!isVlen) {
            builder.setNelems((int)data.getSize());
            builder.setSection(NcStream.encodeSection(section));
        }
        if (isVlen) {
            builder.setIsVlen(true);
            this.encodeVlenData(builder, section, data);
            return builder.build();
        } else if (dataType == DataType.STRING) {
            if (data instanceof ArrayChar) {
                ArrayChar cdata = (ArrayChar)data;
                for (String s2 : cdata) {
                    builder.addStringdata(s2);
                }
                Section ssection = section.removeLast();
                builder.setSection(NcStream.encodeSection(ssection));
                return builder.build();
            } else {
                if (!(data instanceof ArrayObject)) throw new IllegalStateException("Unknown class for STRING =" + data.getClass().getName());
                IndexIterator iter = data.getIndexIterator();
                while (iter.hasNext()) {
                    builder.addStringdata((String)iter.next());
                }
            }
            return builder.build();
        } else if (dataType == DataType.OPAQUE) {
            if (!(data instanceof ArrayObject)) throw new IllegalStateException("Unknown class for OPAQUE =" + data.getClass().getName());
            IndexIterator iter = data.getIndexIterator();
            while (iter.hasNext()) {
                ByteBuffer bb = (ByteBuffer)iter.next();
                builder.addOpaquedata(ByteString.copyFrom(bb.duplicate()));
            }
            return builder.build();
        } else if (dataType == DataType.STRUCTURE) {
            builder.setStructdata(this.encodeStructureData(data));
            return builder.build();
        } else {
            if (dataType == DataType.SEQUENCE) {
                throw new UnsupportedOperationException("Not implemented yet SEQUENCE =" + data.getClass().getName());
            }
            builder.setPrimdata(NcStreamDataCol.copyArrayToByteString(data));
        }
        return builder.build();
    }

    void encodeVlenData(NcStreamProto.DataCol.Builder builder, Section section, Array data) {
        if (data instanceof ArrayObject) {
            IndexIterator iter = data.getIndexIterator();
            int count = 0;
            int nelems = 0;
            while (iter.hasNext()) {
                Array varray = (Array)iter.next();
                int vlensize = (int)varray.getSize();
                builder.addVlens(vlensize);
                nelems += vlensize;
                ++count;
            }
            builder.setNelems(nelems);
            Section ssection = section.removeVlen();
            builder.setSection(NcStream.encodeSection(ssection));
            assert (ssection.computeSize() == (long)count);
            int nbytes = nelems * data.getDataType().getSize();
            ByteBuffer bb = ByteBuffer.allocate(nbytes);
            bb.order(ByteOrder.nativeOrder());
            iter = data.getIndexIterator();
            while (iter.hasNext()) {
                Array varray = (Array)iter.next();
                NcStreamDataCol.copyArrayToBB(varray, true, bb);
            }
            bb.flip();
            builder.setPrimdata(ByteString.copyFrom(bb));
        } else {
            builder.setPrimdata(NcStreamDataCol.copyArrayToByteString(data));
            builder.setIsVlen(false);
            builder.setNelems((int)data.getSize());
            builder.setSection(NcStream.encodeSection(new Section(data.getShape())));
        }
    }

    public static ByteString copyArrayToByteString(Array data) {
        int nbytes = (int)data.getSizeBytes();
        if (nbytes < 0) {
            logger.error("copyArrayToByteString neg byte size {} dataType = {} data size {} shape = {}", nbytes, data.getDataType().getSize(), data.getSize(), Misc.showInts(data.getShape()));
        }
        ByteBuffer bb = ByteBuffer.allocate(nbytes);
        bb.order(ByteOrder.nativeOrder());
        NcStreamDataCol.copyArrayToBB(data, false, bb);
        bb.flip();
        return ByteString.copyFrom(bb);
    }

    public static void copyArrayToBB(Array data, boolean isVlen, ByteBuffer out) {
        IndexIterator iterA = data.getIndexIterator();
        if (isVlen && data instanceof ArrayObject) {
            while (iterA.hasNext()) {
                Object inner = iterA.next();
                assert (inner instanceof Array);
                NcStreamDataCol.copyArrayToBB((Array)inner, isVlen, out);
            }
            return;
        }
        Class classType = data.getElementType();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                out.putDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                out.putFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                out.putLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                out.putInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                out.putShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            byte[] pa = IospHelper.convertCharToByte((char[])data.get1DJavaArray(DataType.CHAR));
            out.put(pa, 0, pa.length);
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                out.put(iterA.getByteNext());
            }
        } else {
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
    }

    NcStreamProto.ArrayStructureCol.Builder encodeStructureData(Array data) {
        assert (data instanceof ArrayStructure);
        ArrayStructure as = (ArrayStructure)data;
        int nelems = (int)as.getSize();
        ArrayList<MemberData> memberDataList = new ArrayList<MemberData>();
        StructureMembers sm = as.getStructureMembers();
        for (StructureMembers.Member m4 : sm.getMembers()) {
            memberDataList.add(new MemberData(m4, as.getShape()));
        }
        for (int recno = 0; recno < nelems; ++recno) {
            for (MemberData md : memberDataList) {
                if (md.member.isVariableLength()) {
                    md.vlenList.add(as.getArray(recno, md.member));
                    continue;
                }
                this.extractData(as, recno, md);
            }
        }
        return this.buildNestedStructureData(memberDataList);
    }

    NcStreamProto.ArrayStructureCol.Builder buildNestedStructureData(List<MemberData> mdataList) {
        NcStreamProto.ArrayStructureCol.Builder result = NcStreamProto.ArrayStructureCol.newBuilder();
        for (MemberData nestedMemberData : mdataList) {
            NcStreamProto.DataCol.Builder nestedBuilder = NcStreamProto.DataCol.newBuilder();
            nestedBuilder.setName(nestedMemberData.member.getName());
            nestedBuilder.setDataType(NcStream.convertDataType(nestedMemberData.member.getDataType()));
            nestedBuilder.setNelems(nestedMemberData.nelems);
            nestedBuilder.setSection(NcStream.encodeSection(nestedMemberData.section));
            if (nestedMemberData.member.isVariableLength()) {
                nestedMemberData.finishVlens();
                nestedBuilder.addAllVlens(nestedMemberData.vlens);
                nestedMemberData.bb.flip();
                nestedBuilder.setPrimdata(ByteString.copyFrom(nestedMemberData.bb));
                nestedBuilder.setNelems(nestedMemberData.nelems);
                nestedBuilder.setIsVlen(true);
            } else if (nestedMemberData.member.getDataType() == DataType.STRING) {
                nestedBuilder.addAllStringdata(nestedMemberData.stringList);
            } else if (nestedMemberData.member.getDataType() == DataType.OPAQUE) {
                nestedBuilder.addAllOpaquedata(nestedMemberData.opaqueList);
            } else if (nestedMemberData.member.getDataType() == DataType.STRUCTURE) {
                nestedBuilder.setStructdata(this.buildNestedStructureData(nestedMemberData.members));
            } else {
                nestedMemberData.bb.flip();
                nestedBuilder.setPrimdata(ByteString.copyFrom(nestedMemberData.bb));
            }
            result.addMemberData(nestedBuilder);
        }
        return result;
    }

    void extractData(ArrayStructure as, int recno, MemberData md) {
        block30: {
            Class classType;
            ByteBuffer bb;
            StructureMembers.Member m4;
            block28: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    block33: {
                                        block32: {
                                            block31: {
                                                block29: {
                                                    m4 = md.member;
                                                    bb = md.bb;
                                                    classType = md.dtype.getPrimitiveClassType();
                                                    if (!m4.isScalar()) break block28;
                                                    if (classType != Double.TYPE) break block29;
                                                    bb.putDouble(as.getScalarDouble(recno, m4));
                                                    break block30;
                                                }
                                                if (classType != Float.TYPE) break block31;
                                                bb.putFloat(as.getScalarFloat(recno, m4));
                                                break block30;
                                            }
                                            if (classType != Byte.TYPE) break block32;
                                            bb.put(as.getScalarByte(recno, m4));
                                            break block30;
                                        }
                                        if (classType != Short.TYPE) break block33;
                                        bb.putShort(as.getScalarShort(recno, m4));
                                        break block30;
                                    }
                                    if (classType != Integer.TYPE) break block34;
                                    bb.putInt(as.getScalarInt(recno, m4));
                                    break block30;
                                }
                                if (classType != Long.TYPE) break block35;
                                bb.putLong(as.getScalarLong(recno, m4));
                                break block30;
                            }
                            if (md.dtype != DataType.CHAR) break block36;
                            bb.put((byte)as.getScalarChar(recno, m4));
                            break block30;
                        }
                        if (md.dtype != DataType.STRING) break block37;
                        md.stringList.add(as.getScalarString(recno, m4));
                        break block30;
                    }
                    if (md.dtype != DataType.OPAQUE) break block38;
                    md.opaqueList.add(ByteString.copyFrom((ByteBuffer)as.getScalarObject(recno, m4)));
                    break block30;
                }
                if (md.dtype != DataType.STRUCTURE) break block30;
                this.extractStructureData(md, as.getScalarStructure(recno, m4));
                break block30;
            }
            if (classType == Double.TYPE) {
                double[] data;
                for (double aData : data = as.getJavaArrayDouble(recno, m4)) {
                    bb.putDouble(aData);
                }
            } else if (classType == Float.TYPE) {
                float[] data;
                for (float aData : data = as.getJavaArrayFloat(recno, m4)) {
                    bb.putFloat(aData);
                }
            } else if (classType == Byte.TYPE) {
                byte[] data;
                for (byte aData : data = as.getJavaArrayByte(recno, m4)) {
                    bb.put(aData);
                }
            } else if (classType == Short.TYPE) {
                short[] data;
                for (short aData : data = as.getJavaArrayShort(recno, m4)) {
                    bb.putShort(aData);
                }
            } else if (classType == Integer.TYPE) {
                int[] data;
                for (int aData : data = as.getJavaArrayInt(recno, m4)) {
                    bb.putInt(aData);
                }
            } else if (classType == Long.TYPE) {
                long[] data;
                for (long aData : data = as.getJavaArrayLong(recno, m4)) {
                    bb.putLong(aData);
                }
            } else if (md.dtype == DataType.CHAR) {
                char[] data;
                for (char aData : data = as.getJavaArrayChar(recno, m4)) {
                    bb.put((byte)aData);
                }
            } else if (md.dtype == DataType.STRING) {
                String[] data = as.getJavaArrayString(recno, m4);
                Collections.addAll(md.stringList, data);
            } else if (md.dtype == DataType.OPAQUE) {
                ArrayObject ao = as.getArrayObject(recno, m4);
                while (ao.hasNext()) {
                    md.opaqueList.add(ByteString.copyFrom((ByteBuffer)ao.next()));
                }
            } else if (md.dtype == DataType.STRUCTURE) {
                ArrayStructure nested = as.getArrayStructure(recno, m4);
                int i = 0;
                while ((long)i < nested.getSize()) {
                    this.extractStructureData(md, nested.getStructureData(i));
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void extractStructureData(MemberData md, StructureData sdata) {
        for (MemberData nested : md.members) {
            void var9_17;
            Object[] data;
            StructureMembers.Member m4 = nested.member;
            ByteBuffer bb = nested.bb;
            Class classType = nested.dtype.getPrimitiveClassType();
            if (m4.isScalar()) {
                if (classType == Double.TYPE) {
                    bb.putDouble(sdata.getScalarDouble(m4));
                    continue;
                }
                if (classType == Float.TYPE) {
                    bb.putFloat(sdata.getScalarFloat(m4));
                    continue;
                }
                if (classType == Byte.TYPE) {
                    bb.put(sdata.getScalarByte(m4));
                    continue;
                }
                if (classType == Short.TYPE) {
                    bb.putShort(sdata.getScalarShort(m4));
                    continue;
                }
                if (classType == Integer.TYPE) {
                    bb.putInt(sdata.getScalarInt(m4));
                    continue;
                }
                if (classType == Long.TYPE) {
                    bb.putLong(sdata.getScalarLong(m4));
                    continue;
                }
                if (md.dtype == DataType.CHAR) {
                    bb.put((byte)sdata.getScalarChar(m4));
                    continue;
                }
                if (md.dtype == DataType.STRING) {
                    md.stringList.add(sdata.getScalarString(m4));
                    continue;
                }
                if (md.dtype == DataType.OPAQUE) {
                    md.opaqueList.add(ByteString.copyFrom((ByteBuffer)sdata.getScalarObject(m4)));
                    continue;
                }
                if (md.dtype != DataType.STRUCTURE) continue;
                this.extractStructureData(md, sdata.getScalarStructure(m4));
                continue;
            }
            if (classType == Double.TYPE) {
                for (double aData : data = sdata.getJavaArrayDouble(m4)) {
                    bb.putDouble(aData);
                }
                continue;
            }
            if (classType == Float.TYPE) {
                for (double aData : data = (Object[])sdata.getJavaArrayFloat(m4)) {
                    bb.putFloat((float)aData);
                }
                continue;
            }
            if (classType == Byte.TYPE) {
                for (double aData : data = (Object[])sdata.getJavaArrayByte(m4)) {
                    bb.put((byte)aData);
                }
                continue;
            }
            if (classType == Short.TYPE) {
                for (double aData : data = (Object[])sdata.getJavaArrayShort(m4)) {
                    bb.putShort((short)aData);
                }
                continue;
            }
            if (classType == Integer.TYPE) {
                for (double aData : data = (Object[])sdata.getJavaArrayInt(m4)) {
                    bb.putInt((int)aData);
                }
                continue;
            }
            if (classType == Long.TYPE) {
                for (double aData : data = (Object[])sdata.getJavaArrayLong(m4)) {
                    bb.putLong((long)aData);
                }
                continue;
            }
            if (md.dtype == DataType.CHAR) {
                for (double aData : data = (Object[])sdata.getJavaArrayChar(m4)) {
                    bb.put((byte)aData);
                }
                continue;
            }
            if (md.dtype == DataType.STRING) {
                data = sdata.getJavaArrayString(m4);
                Collections.addAll(md.stringList, data);
                continue;
            }
            if (md.dtype == DataType.OPAQUE) {
                Array ao = sdata.getArray(m4);
                while (ao.hasNext()) {
                    md.opaqueList.add(ByteString.copyFrom((ByteBuffer)ao.next()));
                }
                continue;
            }
            if (md.dtype != DataType.STRUCTURE) continue;
            ArrayStructure nestedAS = sdata.getArrayStructure(m4);
            boolean bl = false;
            while ((long)var9_17 < nestedAS.getSize()) {
                this.extractStructureData(md, nestedAS.getStructureData((int)var9_17));
                ++var9_17;
            }
        }
    }

    public Array decode(NcStreamProto.DataCol dproto, Section parentSection) throws IOException {
        Section section;
        ByteOrder bo = dproto.getBigend() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        DataType dataType = NcStream.convertDataType(dproto.getDataType());
        Section section2 = section = dataType == DataType.SEQUENCE ? new Section() : NcStream.decodeSection(dproto.getSection());
        assert (dproto.getIsVlen() || (long)dproto.getNelems() == section.computeSize());
        if (dproto.getIsVlen()) {
            if (parentSection == null) {
                return this.decodeVlenData(dproto);
            }
            return this.decodeVlenData(dproto, parentSection);
        }
        if (dataType == DataType.STRING) {
            Array data = Array.factory(dataType, section.getShape());
            IndexIterator ii = data.getIndexIterator();
            for (String s2 : dproto.getStringdataList()) {
                ii.setObjectNext(s2);
            }
            return data;
        }
        if (dataType == DataType.STRUCTURE) {
            return this.decodeStructureData(dproto, parentSection);
        }
        if (dataType == DataType.OPAQUE) {
            Array data = Array.factory(dataType, section.getShape());
            IndexIterator ii = data.getIndexIterator();
            for (ByteString s3 : dproto.getOpaquedataList()) {
                ii.setObjectNext(s3.asReadOnlyByteBuffer());
            }
            return data;
        }
        ByteBuffer bb = dproto.getPrimdata().asReadOnlyByteBuffer();
        bb.order(bo);
        return Array.factory(dataType, section.getShape(), bb);
    }

    public Array decodeVlenData(NcStreamProto.DataCol dproto) {
        DataType dataType = NcStream.convertDataType(dproto.getDataType());
        ByteBuffer bb = dproto.getPrimdata().asReadOnlyByteBuffer();
        ByteOrder bo = dproto.getBigend() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        bb.order(bo);
        Array alldata = Array.factory(dataType, new int[]{dproto.getNelems()}, bb);
        IndexIterator all = alldata.getIndexIterator();
        Section section = NcStream.decodeSection(dproto.getSection());
        Array[] data = new Array[(int)section.computeSize()];
        int count = 0;
        for (int len : dproto.getVlensList()) {
            Array primdata = Array.factory(dataType, new int[]{len});
            IndexIterator prim = primdata.getIndexIterator();
            for (int i = 0; i < len; ++i) {
                prim.setObjectNext(all.getObjectNext());
            }
            data[count++] = primdata;
        }
        return Array.makeVlenArray(section.getShape(), data);
    }

    private Array decodeVlenData(NcStreamProto.DataCol dproto, Section parentSection) {
        DataType dataType = NcStream.convertDataType(dproto.getDataType());
        ByteBuffer bb = dproto.getPrimdata().asReadOnlyByteBuffer();
        ByteOrder bo = dproto.getBigend() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        bb.order(bo);
        Array alldata = Array.factory(dataType, new int[]{dproto.getNelems()}, bb);
        IndexIterator all = alldata.getIndexIterator();
        int psize = (int)parentSection.computeSize();
        Section section = NcStream.decodeSection(dproto.getSection());
        Section vsection = section.removeFirst(parentSection);
        int vsectionSize = (int)vsection.computeSize();
        int countInner = 0;
        Array[] pdata = new Array[psize];
        for (int pCount = 0; pCount < psize; ++pCount) {
            Array[] vdata = new Array[vsectionSize];
            for (int vCount = 0; vCount < vsectionSize; ++vCount) {
                int vlen = dproto.getVlens(countInner++);
                Array primdata = Array.factory(dataType, new int[]{vlen});
                IndexIterator prim = primdata.getIndexIterator();
                for (int i = 0; i < vlen; ++i) {
                    prim.setObjectNext(all.getObjectNext());
                }
                vdata[vCount] = primdata;
            }
            pdata[pCount] = Array.makeVlenArray(vsection.getShape(), vdata);
        }
        return Array.makeVlenArray(parentSection.getShape(), pdata);
    }

    private Array decodeStructureData(NcStreamProto.DataCol dproto, Section parentSection) throws IOException {
        NcStreamProto.ArrayStructureCol structData = dproto.getStructdata();
        Section section = NcStream.decodeSection(dproto.getSection());
        int nelems = dproto.getNelems();
        assert ((long)nelems == section.computeSize());
        parentSection = section.prepend(parentSection);
        StructureMembers members = new StructureMembers(dproto.getName());
        for (NcStreamProto.DataCol memberData : structData.getMemberDataList()) {
            this.decodeMemberData(members, memberData, parentSection);
        }
        return new ArrayStructureMA(members, section.getShape());
    }

    private void decodeMemberData(StructureMembers members, NcStreamProto.DataCol memberData, Section parentSection) throws IOException {
        String name = memberData.getName();
        DataType dataType = NcStream.convertDataType(memberData.getDataType());
        Section section = NcStream.decodeSection(memberData.getSection());
        assert (memberData.getIsVlen() || (long)memberData.getNelems() == section.computeSize());
        Section msection = section.removeFirst(parentSection);
        if (memberData.getIsVlen()) {
            msection = msection.appendRange(Range.VLEN);
        }
        StructureMembers.Member result = members.addMember(name, null, null, dataType, msection.getShape());
        Array data = this.decode(memberData, parentSection);
        result.setDataArray(data);
    }

    private static class MemberData {
        StructureMembers.Member member;
        Section section;
        DataType dtype;
        boolean isVlen;
        int nelems;
        ByteBuffer bb;
        List<String> stringList;
        List<ByteString> opaqueList;
        List<Array> vlenList;
        List<Integer> vlens;
        List<MemberData> members;

        MemberData(StructureMembers.Member member, int[] parent) {
            this.member = member;
            this.section = new Section(parent);
            int[] mshape = member.getShape();
            for (int s2 : mshape) {
                if (s2 < 0) continue;
                this.section.appendRange(s2);
            }
            this.dtype = member.getDataType();
            this.isVlen = member.isVariableLength();
            this.nelems = (int)this.section.computeSize();
            if (this.isVlen) {
                this.vlenList = new ArrayList<Array>(this.nelems);
            } else if (this.dtype == DataType.STRING) {
                this.stringList = new ArrayList<String>(this.nelems * member.getSize());
            } else if (this.dtype == DataType.OPAQUE) {
                this.opaqueList = new ArrayList<ByteString>(this.nelems * member.getSize());
            } else if (this.dtype == DataType.STRUCTURE) {
                this.members = new ArrayList<MemberData>();
                Object object = member.getStructureMembers().getMembers().iterator();
                while (object.hasNext()) {
                    StructureMembers.Member m4 = (StructureMembers.Member)object.next();
                    this.members.add(new MemberData(m4, this.section.getShape()));
                }
            } else {
                this.bb = ByteBuffer.allocate(this.nelems * member.getSizeBytes());
                this.bb.order(ByteOrder.nativeOrder());
            }
        }

        int addVlens(Array va) {
            int total = 0;
            if (va instanceof ArrayObject) {
                while (va.hasNext()) {
                    Object inner = va.next();
                    assert (inner instanceof Array);
                    total += this.addVlens((Array)inner);
                }
            } else {
                this.vlens.add((int)va.getSize());
                total = (int)((long)total + va.getSize());
            }
            return total;
        }

        int finishVlens() {
            this.vlens = new ArrayList<Integer>(this.nelems * this.member.getSize());
            int total = 0;
            for (Array va : this.vlenList) {
                total += this.addVlens(va);
            }
            this.nelems = total;
            this.bb = ByteBuffer.allocate(total * this.member.getSizeBytes());
            this.bb.order(ByteOrder.nativeOrder());
            for (Array va : this.vlenList) {
                NcStreamDataCol.copyArrayToBB(va, true, this.bb);
            }
            return total;
        }
    }
}

