/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.ImageReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;

public class TiledReaderWriter {
    private ImageReader reader;
    private OMETiffWriter writer;
    private String inputFile;
    private String outputFile;
    private int tileSizeX;
    private int tileSizeY;

    public TiledReaderWriter(String inputFile, String outputFile, int tileSizeX, int tileSizeY) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.tileSizeX = tileSizeX;
        this.tileSizeY = tileSizeY;
    }

    private void initialize() throws DependencyException, FormatException, IOException, ServiceException {
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata omexml = service.createOMEXMLMetadata();
        this.reader = new ImageReader();
        this.reader.setMetadataStore((MetadataStore)omexml);
        this.reader.setId(this.inputFile);
        this.writer = new OMETiffWriter();
        this.writer.setMetadataRetrieve((MetadataRetrieve)omexml);
        this.writer.setInterleaved(this.reader.isInterleaved());
        this.tileSizeX = this.writer.setTileSizeX(this.tileSizeX);
        this.tileSizeY = this.writer.setTileSizeY(this.tileSizeY);
        this.writer.setId(this.outputFile);
    }

    public void readWriteTiles() throws FormatException, IOException {
        int bpp = FormatTools.getBytesPerPixel((int)this.reader.getPixelType());
        int tilePlaneSize = this.tileSizeX * this.tileSizeY * this.reader.getRGBChannelCount() * bpp;
        byte[] buf = new byte[tilePlaneSize];
        for (int series = 0; series < this.reader.getSeriesCount(); ++series) {
            this.reader.setSeries(series);
            this.writer.setSeries(series);
            for (int image = 0; image < this.reader.getImageCount(); ++image) {
                int width = this.reader.getSizeX();
                int height = this.reader.getSizeY();
                int nXTiles = width / this.tileSizeX;
                int nYTiles = height / this.tileSizeY;
                if (nXTiles * this.tileSizeX != width) {
                    ++nXTiles;
                }
                if (nYTiles * this.tileSizeY != height) {
                    ++nYTiles;
                }
                for (int y = 0; y < nYTiles; ++y) {
                    for (int x = 0; x < nXTiles; ++x) {
                        int tileX = x * this.tileSizeX;
                        int tileY = y * this.tileSizeY;
                        buf = this.reader.openBytes(image, tileX, tileY, this.tileSizeX, this.tileSizeY);
                        this.writer.saveBytes(image, buf, tileX, tileY, this.tileSizeX, this.tileSizeY);
                    }
                }
            }
        }
    }

    private void cleanup() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close reader.");
            e.printStackTrace();
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            System.err.println("Failed to close writer.");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws FormatException, IOException, DependencyException, ServiceException {
        int tileSizeX = Integer.parseInt(args[2]);
        int tileSizeY = Integer.parseInt(args[3]);
        TiledReaderWriter tiledReadWriter = new TiledReaderWriter(args[0], args[1], tileSizeX, tileSizeY);
        tiledReadWriter.initialize();
        try {
            tiledReadWriter.readWriteTiles();
        }
        catch (Exception e) {
            System.err.println("Failed to read and write tiles.");
            e.printStackTrace();
            throw e;
        }
        finally {
            tiledReadWriter.cleanup();
        }
    }
}

