/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import loci.common.RandomAccessInputStream;
import loci.poi.hpsf.ClassID;
import loci.poi.poifs.dev.POIFSViewable;
import loci.poi.poifs.filesystem.DirectoryEntry;
import loci.poi.poifs.filesystem.DocumentEntry;
import loci.poi.poifs.filesystem.DocumentNode;
import loci.poi.poifs.filesystem.Entry;
import loci.poi.poifs.filesystem.EntryNode;
import loci.poi.poifs.filesystem.POIFSDocument;
import loci.poi.poifs.filesystem.POIFSDocumentPath;
import loci.poi.poifs.filesystem.POIFSFileSystem;
import loci.poi.poifs.filesystem.POIFSWriterListener;
import loci.poi.poifs.property.DirectoryProperty;
import loci.poi.poifs.property.DocumentProperty;
import loci.poi.poifs.property.Property;

public class DirectoryNode
extends EntryNode
implements DirectoryEntry,
POIFSViewable {
    private Map _entries;
    private POIFSFileSystem _filesystem;
    private POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty property, POIFSFileSystem filesystem, DirectoryNode parent) {
        super(property, parent);
        this._path = parent == null ? new POIFSDocumentPath() : new POIFSDocumentPath(parent._path, new String[]{property.getName()});
        this._filesystem = filesystem;
        this._entries = new HashMap();
        Iterator iter = property.getChildren();
        while (iter.hasNext()) {
            Property child = (Property)iter.next();
            EntryNode childNode = null;
            childNode = child.isDirectory() ? new DirectoryNode((DirectoryProperty)child, this._filesystem, this) : new DocumentNode((DocumentProperty)child, this);
            this._entries.put(childNode.getName(), childNode);
        }
    }

    public POIFSDocumentPath getPath() {
        return this._path;
    }

    DocumentEntry createDocument(POIFSDocument document) throws IOException {
        DocumentProperty property = document.getDocumentProperty();
        DocumentNode rval = new DocumentNode(property, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._filesystem.addDocument(document);
        this._entries.put(property.getName(), rval);
        return rval;
    }

    boolean changeName(String oldName, String newName) {
        boolean rval = false;
        EntryNode child = (EntryNode)this._entries.get(oldName);
        if (child != null && (rval = ((DirectoryProperty)this.getProperty()).changeName(child.getProperty(), newName))) {
            this._entries.remove(oldName);
            this._entries.put(child.getProperty().getName(), child);
        }
        return rval;
    }

    boolean deleteEntry(EntryNode entry) {
        boolean rval = ((DirectoryProperty)this.getProperty()).deleteChild(entry.getProperty());
        if (rval) {
            this._entries.remove(entry.getName());
            this._filesystem.remove(entry);
        }
        return rval;
    }

    @Override
    public Iterator getEntries() {
        return this._entries.values().iterator();
    }

    @Override
    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    @Override
    public int getEntryCount() {
        return this._entries.size();
    }

    @Override
    public Entry getEntry(String name) throws FileNotFoundException {
        Entry rval = null;
        if (name != null) {
            rval = (Entry)this._entries.get(name);
        }
        if (rval == null) {
            throw new FileNotFoundException("no such entry: \"" + name + "\"");
        }
        return rval;
    }

    @Override
    public DocumentEntry createDocument(String name, RandomAccessInputStream stream) throws IOException {
        return this.createDocument(new POIFSDocument(name, stream, 512));
    }

    @Override
    public DocumentEntry createDocument(String name, int size, POIFSWriterListener writer) throws IOException {
        return this.createDocument(new POIFSDocument(name, size, this._path, writer, 512));
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws IOException {
        DirectoryProperty property = new DirectoryProperty(name);
        DirectoryNode rval = new DirectoryNode(property, this._filesystem, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._filesystem.addDirectory(property);
        this._entries.put(name, rval);
        return rval;
    }

    @Override
    public ClassID getStorageClsid() {
        return this.getProperty().getStorageClsid();
    }

    @Override
    public void setStorageClsid(ClassID clsidStorage) {
        this.getProperty().setStorageClsid(clsidStorage);
    }

    @Override
    public boolean isDirectoryEntry() {
        return true;
    }

    @Override
    protected boolean isDeleteOK() {
        return this.isEmpty();
    }

    @Override
    public Object[] getViewableArray() {
        return new Object[0];
    }

    @Override
    public Iterator getViewableIterator() {
        ArrayList<Property> components = new ArrayList<Property>();
        components.add(this.getProperty());
        TreeMap sortedEntries = new TreeMap(this._entries);
        Iterator iter = sortedEntries.values().iterator();
        while (iter.hasNext()) {
            components.add((Property)iter.next());
        }
        return components.iterator();
    }

    @Override
    public boolean preferArray() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return this.getName();
    }
}

