/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Formatter;
import javax.annotation.concurrent.ThreadSafe;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public abstract class CollectionSpecParserAbstract {
    protected final String spec;
    protected final String rootDir;
    protected final boolean subdirs;
    protected final boolean filterOnName;
    protected final Pattern filter;
    protected final String dateFormatMark;
    protected final String delimiter;
    protected final String fragment;

    protected CollectionSpecParserAbstract(String collectionSpec, String rootDir, String filterAndDateMark, String delimiter, String fragment, Formatter errlog) {
        this.spec = collectionSpec.trim();
        this.rootDir = rootDir;
        this.subdirs = collectionSpec.contains(delimiter + "**" + delimiter);
        this.filter = CollectionSpecParserAbstract.getRegEx(filterAndDateMark);
        this.dateFormatMark = CollectionSpecParserAbstract.getDateFormatMark(filterAndDateMark);
        this.delimiter = delimiter;
        this.fragment = fragment;
        this.filterOnName = true;
    }

    protected CollectionSpecParserAbstract(String rootDir, String regExp, String delimiter, String fragment, Formatter errlog) {
        this.rootDir = StringUtil2.removeFromEnd(rootDir, delimiter);
        this.subdirs = true;
        this.spec = this.rootDir + delimiter + regExp;
        this.filter = Pattern.compile(this.spec);
        this.dateFormatMark = null;
        this.delimiter = delimiter;
        this.fragment = fragment;
        this.filterOnName = false;
    }

    protected static String getRootDir(String collectionSpec, String defaultRootDir, String delimiter) {
        String rootDir = CollectionSpecParserAbstract.splitOnLastDelimiter(collectionSpec, delimiter)[0];
        return rootDir == null ? defaultRootDir : rootDir;
    }

    protected static String getFilterAndDateMark(String collectionSpec, String delimiter) {
        return CollectionSpecParserAbstract.splitOnLastDelimiter(collectionSpec, delimiter)[1];
    }

    protected static String[] splitOnLastDelimiter(String collectionSpec, String delimiter) {
        int endPositionOfLastDelimiter;
        if (delimiter == null || delimiter.isEmpty()) {
            return new String[]{null, collectionSpec};
        }
        String wantSubDirs = delimiter + "**" + delimiter;
        int startPositionOfLastDelimiter = collectionSpec.contains(wantSubDirs) ? collectionSpec.indexOf("/**/") : collectionSpec.lastIndexOf(47);
        int n = endPositionOfLastDelimiter = collectionSpec.contains(wantSubDirs) ? collectionSpec.indexOf("/**/") + 3 : collectionSpec.lastIndexOf(47);
        if (startPositionOfLastDelimiter == -1) {
            return new String[]{null, collectionSpec.isEmpty() ? null : collectionSpec};
        }
        if (endPositionOfLastDelimiter >= collectionSpec.length() - 1) {
            return new String[]{collectionSpec.substring(0, startPositionOfLastDelimiter), null};
        }
        return new String[]{collectionSpec.substring(0, startPositionOfLastDelimiter), collectionSpec.substring(endPositionOfLastDelimiter + 1)};
    }

    protected static Pattern getRegEx(String filterAndDateMark) {
        if (filterAndDateMark == null || filterAndDateMark.length() <= 1) {
            return null;
        }
        int numberOfHashes = filterAndDateMark.length() - filterAndDateMark.replace("#", "").length();
        if (numberOfHashes == 0) {
            return Pattern.compile(filterAndDateMark);
        }
        if (numberOfHashes == 1) {
            return Pattern.compile(filterAndDateMark.substring(0, filterAndDateMark.indexOf(35)) + "*");
        }
        if (numberOfHashes == 2) {
            String[] hashSegments = filterAndDateMark.split("#");
            String dateMarkMatcher = new String(new char[hashSegments[1].length()]).replace("\u0000", ".");
            return Pattern.compile(hashSegments[0] + dateMarkMatcher + hashSegments[2]);
        }
        throw new IllegalArgumentException("More than two '#' symbols not allowed in spec: " + filterAndDateMark);
    }

    protected static String getDateFormatMark(String filterAndDateMark) {
        if (filterAndDateMark == null || filterAndDateMark.length() <= 1) {
            return null;
        }
        int numberOfHashes = filterAndDateMark.length() - filterAndDateMark.replace("#", "").length();
        if (numberOfHashes == 0) {
            return null;
        }
        if (numberOfHashes == 1) {
            return filterAndDateMark;
        }
        return filterAndDateMark.substring(0, filterAndDateMark.lastIndexOf(35));
    }

    public PathMatcher getPathMatcher() {
        if (this.spec.startsWith("regex:") || this.spec.startsWith("glob:")) {
            return FileSystems.getDefault().getPathMatcher(this.spec);
        }
        return new BySpecp();
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public abstract String getFilePath(String var1);

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean wantSubdirs() {
        return this.subdirs;
    }

    public Pattern getFilter() {
        return this.filter;
    }

    public boolean getFilterOnName() {
        return this.filterOnName;
    }

    public String getDateFormatMark() {
        return this.dateFormatMark;
    }

    public String toString() {
        return "CollectionSpecParser{\n   topDir='" + this.rootDir + '\'' + "\n   subdirs=" + this.subdirs + "\n   regExp='" + this.filter + '\'' + "\n   dateFormatMark='" + this.dateFormatMark + '\'' + "\n}";
    }

    private class BySpecp
    implements PathMatcher {
        private BySpecp() {
        }

        @Override
        public boolean matches(Path path) {
            Matcher matcher = CollectionSpecParserAbstract.this.filter.matcher(path.getFileName().toString());
            return matcher.matches();
        }
    }
}

