/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.ode.DormandPrince54StepInterpolator;
import org.apache.commons.math.ode.EmbeddedRungeKuttaIntegrator;
import org.apache.commons.math.ode.RungeKuttaStepInterpolator;

public class DormandPrince54Integrator
extends EmbeddedRungeKuttaIntegrator {
    private static final String methodName = "Dormand-Prince 5(4)";
    private static final double[] staticC = new double[]{0.2, 0.3, 0.8, 0.8888888888888888, 1.0, 1.0};
    private static final double[][] staticA = new double[][]{{0.2}, {0.075, 0.225}, {0.9777777777777777, -3.7333333333333334, 3.5555555555555554}, {2.9525986892242035, -11.595793324188385, 9.822892851699436, -0.2908093278463649}, {2.8462752525252526, -10.757575757575758, 8.906422717743473, 0.2784090909090909, -0.2735313036020583}, {0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096}};
    private static final double[] staticB = new double[]{0.09114583333333333, 0.0, 0.44923629829290207, 0.6510416666666666, -0.322376179245283, 0.13095238095238096, 0.0};
    private static final double e1 = 0.0012326388888888888;
    private static final double e3 = -0.0042527702905061394;
    private static final double e4 = 0.03697916666666667;
    private static final double e5 = -0.05086379716981132;
    private static final double e6 = 0.0419047619047619;
    private static final double e7 = -0.025;

    public DormandPrince54Integrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(true, staticC, staticA, staticB, (RungeKuttaStepInterpolator)new DormandPrince54StepInterpolator(), minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public DormandPrince54Integrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(true, staticC, staticA, staticB, (RungeKuttaStepInterpolator)new DormandPrince54StepInterpolator(), minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    public String getName() {
        return methodName;
    }

    public int getOrder() {
        return 5;
    }

    protected double estimateError(double[][] yDotK, double[] y0, double[] y1, double h2) {
        double error = 0.0;
        for (int j = 0; j < y0.length; ++j) {
            double errSum = 0.0012326388888888888 * yDotK[0][j] + -0.0042527702905061394 * yDotK[2][j] + 0.03697916666666667 * yDotK[3][j] + -0.05086379716981132 * yDotK[4][j] + 0.0419047619047619 * yDotK[5][j] + -0.025 * yDotK[6][j];
            double yScale = Math.max(Math.abs(y0[j]), Math.abs(y1[j]));
            double tol = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * yScale : this.vecAbsoluteTolerance[j] + this.vecRelativeTolerance[j] * yScale;
            double ratio = h2 * errSum / tol;
            error += ratio * ratio;
        }
        return Math.sqrt(error / (double)y0.length);
    }
}

