/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import java.nio.ByteBuffer;
import loci.common.ByteArrayHandle;

public class ByteArrayHandleMock
extends ByteArrayHandle {
    private long mockCapacity;

    public ByteArrayHandleMock(int capacity) {
        this.buffer = ByteBuffer.allocate(1000000);
        this.buffer.limit(1000000);
        this.mockCapacity = capacity;
    }

    public void setLength(long length) throws IOException {
        this.mockCapacity = length;
    }

    public long length() {
        return this.mockCapacity;
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length()) {
            this.setLength(pos);
        }
        if (pos > 1000000L) {
            this.buffer.position(1000000);
        } else {
            this.buffer.position((int)pos);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.mockCapacity += (long)b.length;
    }
}

