/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class QuesantReader
extends FormatReader {
    public static final int MAX_HEADER_SIZE = 1024;
    private int pixelsOffset;
    private double xSize = 0.0;
    private String date = null;
    private String comment = null;

    public QuesantReader() {
        super("Quesant AFM", "afm");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek((long)this.pixelsOffset);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelsOffset = 0;
            this.xSize = 0.0;
            this.comment = null;
            this.date = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        while (this.in.getFilePointer() < 1024L) {
            this.readVariable();
        }
        this.in.seek((long)this.pixelsOffset);
        m.sizeX = this.in.readShort();
        this.pixelsOffset += 2;
        m.sizeY = this.getSizeX();
        m.pixelType = 3;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.date != null) {
            int separator = this.date.lastIndexOf(":");
            if (separator > 0 && this.date.length() > separator + 5) {
                this.date = this.date.substring(0, separator + 3) + "." + this.date.substring(separator + 3);
            }
            this.date = DateTools.formatDate((String)this.date, (String)"MMM dd yyyy HH:mm:ss", (String)".");
            if (this.date != null) {
                store.setImageAcquisitionDate(new Timestamp(this.date), 0);
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.comment, 0);
            Length sizeX = FormatTools.getPhysicalSizeX((Double)(this.xSize / (double)this.getSizeX()));
            Length sizeY = FormatTools.getPhysicalSizeY((Double)(this.xSize / (double)this.getSizeY()));
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }

    private void readVariable() throws IOException {
        String code = this.in.readString(4);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM && !code.equals("IMAG")) {
            this.in.skipBytes(4);
            return;
        }
        int offset = this.in.readInt();
        long fp = this.in.getFilePointer();
        if (offset <= 0 || (long)offset > this.in.length()) {
            return;
        }
        this.in.seek((long)offset);
        if (code.equals("SDES")) {
            String sdes = this.in.readCString().trim();
            this.comment = this.comment == null ? sdes : this.comment + " " + sdes;
        } else if (code.equals("DESC")) {
            short length = this.in.readShort();
            String desc = this.in.readString((int)length);
            this.comment = this.comment == null ? desc : this.comment + " " + desc;
        } else if (code.equals("DATE")) {
            this.date = this.in.readCString();
        } else if (code.equals("IMAG")) {
            this.pixelsOffset = offset;
        } else if (code.equals("HARD")) {
            this.xSize = this.in.readFloat();
            float scanRate = this.in.readFloat();
            float tunnelCurrent = this.in.readFloat() * 10.0f / 32768.0f;
            this.in.skipBytes(12);
            float integralGain = this.in.readFloat();
            float proportGain = this.in.readFloat();
            boolean isSTM = this.in.readShort() == 10;
            float dynamicRange = this.in.readFloat();
            this.addGlobalMeta("Scan rate (Hz)", scanRate);
            this.addGlobalMeta("Tunnel current", tunnelCurrent);
            this.addGlobalMeta("Is STM image", isSTM);
            this.addGlobalMeta("Integral gain", integralGain);
            this.addGlobalMeta("Proportional gain", proportGain);
            this.addGlobalMeta("Z dynamic range", dynamicRange);
        }
        this.in.seek(fp);
    }
}

