/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.Region;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.CellSensReader;
import loci.formats.in.OIRReader;
import loci.formats.meta.IMetadata;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.meta.MetadataConverter;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.MetadataStore;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OlympusTileReader
extends FormatReader {
    private IFormatReader helperReader;
    private List<Tile> tiles = new ArrayList<Tile>();
    private String[] allPixelsFiles;
    private List<String> extraFiles = new ArrayList<String>();

    public OlympusTileReader() {
        super("Olympus .omp2info", "omp2info");
        this.domains = new String[]{"Light Microscopy"};
        this.datasetDescription = "One .omp2info file and at least one .oir or .vsi file";
        this.suffixSufficient = true;
        this.suffixNecessary = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.helperReader.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.helperReader.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int pixel = this.getRGBChannelCount() * FormatTools.getBytesPerPixel((int)this.getPixelType());
        Region imageRegion = new Region(x, y, w, h);
        for (Tile t : this.tiles) {
            if (!t.region.intersects(imageRegion)) continue;
            this.helperReader.setId(t.file);
            Region intersection = t.region.intersection(imageRegion);
            byte[] src = this.helperReader.openBytes(no, intersection.x - t.region.x, intersection.y - t.region.y, intersection.width, intersection.height);
            for (int row = 0; row < intersection.height; ++row) {
                int srcIndex = row * intersection.width * pixel;
                int destIndex = pixel * ((intersection.y - y + row) * w + (intersection.x - x));
                System.arraycopy(src, srcIndex, buf, destIndex, intersection.width * pixel);
            }
        }
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            ArrayList<String> allFiles = new ArrayList<String>();
            allFiles.add(this.currentId);
            allFiles.addAll(this.extraFiles);
            return allFiles.toArray(new String[allFiles.size()]);
        }
        if (this.allPixelsFiles == null) {
            ArrayList<String> allFiles = new ArrayList<String>();
            allFiles.add(this.currentId);
            allFiles.addAll(this.extraFiles);
            for (Tile t : this.tiles) {
                for (String f : t.files) {
                    allFiles.add(f);
                }
            }
            this.allPixelsFiles = allFiles.toArray(new String[allFiles.size()]);
        }
        return this.allPixelsFiles;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helperReader != null) {
            this.helperReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.helperReader = null;
            this.tiles.clear();
            this.allPixelsFiles = null;
            this.extraFiles.clear();
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        String xml = DataTools.readFile((String)this.currentId);
        xml = XMLTools.sanitizeXML((String)xml);
        this.readMetadata(xml);
        this.tiles.sort(null);
        loci.formats.meta.MetadataStore store = this.makeFilterMetadata();
        this.helperReader.setMetadataStore((loci.formats.meta.MetadataStore)MetadataTools.createOMEXMLMetadata());
        this.helperReader.setId(this.tiles.get((int)0).file);
        this.core.clear();
        CoreMetadata ms = new CoreMetadata((CoreMetadata)this.helperReader.getCoreMetadataList().get(0));
        for (Tile t : this.tiles) {
            Region r = t.region;
            ms.sizeX = Math.max(ms.sizeX, r.width + r.x);
            ms.sizeY = Math.max(ms.sizeY, r.height + r.y);
        }
        this.core.add(ms);
        MetadataConverter.convertMetadata((MetadataRetrieve)((IMetadata)this.helperReader.getMetadataStore()), (MetadataStore)store);
        MetadataTools.populatePixels((loci.formats.meta.MetadataStore)store, (IFormatReader)this);
    }

    private Element getMetadataRoot(String xml) throws FormatException, IOException {
        try {
            return XMLTools.parseDOM((String)xml).getDocumentElement();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new FormatException((Throwable)e);
        }
    }

    private Element getChildNode(Element root, String name) {
        return (Element)root.getElementsByTagName(name).item(0);
    }

    private String getChildValue(Element root, String name) {
        Element node = this.getChildNode(root, name);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    private String getName(Node root) {
        String name = root.getNodeName();
        return name.substring(name.indexOf(":") + 1);
    }

    private void readMetadata(String xml) throws FormatException, IOException {
        String mapFile;
        Element map;
        Element cycle;
        Location parentDir = new Location(this.getCurrentFile()).getParentFile();
        Element root = this.getMetadataRoot(xml);
        Element tileGroup = this.getChildNode(root, "matl:group");
        Element regionInfo = this.getChildNode(tileGroup, "marker:regionInfo");
        Element coordinates = this.getChildNode(regionInfo, "marker:coordinates");
        Element areaInfo = this.getChildNode(tileGroup, "matl:areaInfo");
        int rows = Integer.parseInt(this.getChildValue(areaInfo, "matl:numOfYAreas"));
        int cols = Integer.parseInt(this.getChildValue(areaInfo, "matl:numOfXAreas"));
        Double stitchedWidth = null;
        Double stitchedHeight = null;
        if (coordinates != null) {
            stitchedWidth = DataTools.parseDouble((String)coordinates.getAttribute("width"));
            stitchedHeight = DataTools.parseDouble((String)coordinates.getAttribute("height"));
        }
        NodeList allTiles = tileGroup.getElementsByTagName("matl:area");
        int adjustWidth = 0;
        int adjustHeight = 0;
        Element stage = this.getChildNode(root, "matl:stage");
        int stageOverlap = 0;
        if (stage != null) {
            stageOverlap = Integer.parseInt(this.getChildValue(stage, "matl:overlap"));
        }
        for (int i = 0; i < allTiles.getLength(); ++i) {
            Tile currentTile = new Tile();
            Element tile = (Element)allTiles.item(i);
            String tileFile = this.getChildValue(tile, "matl:image");
            currentTile.file = tileFile = new Location(parentDir, tileFile).getAbsolutePath();
            if (this.helperReader == null) {
                if (OlympusTileReader.checkSuffix((String)tileFile, (String)"oir")) {
                    this.helperReader = new OIRReader();
                } else if (OlympusTileReader.checkSuffix((String)tileFile, (String)"vsi")) {
                    this.helperReader = new CellSensReader();
                } else {
                    throw new FormatException("Unsupported tile file " + tileFile);
                }
                IMetadata metadata = MetadataTools.createOMEXMLMetadata();
                this.helperReader.setMetadataStore((loci.formats.meta.MetadataStore)metadata);
                this.helperReader.setId(tileFile);
                int widthWithOverlaps = this.helperReader.getSizeX() * cols;
                int heightWithOverlaps = this.helperReader.getSizeY() * rows;
                Length physicalSizeX = metadata.getPixelsPhysicalSizeX(0);
                Length physicalSizeY = metadata.getPixelsPhysicalSizeY(0);
                int diffX = stageOverlap * cols * 4;
                int diffY = stageOverlap * rows * 4;
                if (stitchedWidth != null && stitchedHeight != null) {
                    int actualWidth = (int)(stitchedWidth / physicalSizeX.value(UNITS.NANOMETER).doubleValue());
                    int actualHeight = (int)(stitchedHeight / physicalSizeY.value(UNITS.NANOMETER).doubleValue());
                    diffX = widthWithOverlaps - actualWidth;
                    diffY = heightWithOverlaps - actualHeight;
                }
                adjustWidth = this.helperReader.getSizeX();
                if (cols > 1) {
                    adjustWidth -= diffX / (cols - 1);
                }
                adjustHeight = this.helperReader.getSizeY();
                if (rows > 1) {
                    adjustHeight -= diffY / (rows - 1);
                }
            } else {
                this.helperReader.setId(tileFile);
            }
            currentTile.files = this.helperReader.getUsedFiles();
            int xIndex = Integer.parseInt(this.getChildValue(tile, "matl:xIndex"));
            int yIndex = Integer.parseInt(this.getChildValue(tile, "matl:yIndex"));
            currentTile.region = new Region(xIndex * adjustWidth, yIndex * adjustHeight, this.helperReader.getSizeX(), this.helperReader.getSizeY());
            this.tiles.add(currentTile);
            this.addGlobalMetaList("tile X index", xIndex);
            this.addGlobalMetaList("tile Y index", yIndex);
            this.addGlobalMetaList("tile bounding box (pixels)", currentTile.region.toString());
        }
        this.helperReader.close();
        if (stage != null) {
            this.parseOriginalMetadata(stage);
        }
        if ((cycle = this.getChildNode(root, "matl:cycle")) != null) {
            this.parseOriginalMetadata(cycle);
        }
        if ((map = this.getChildNode(root, "matl:map")) != null && (mapFile = this.getChildValue(map, "matl:image")) != null) {
            mapFile = new Location(parentDir, mapFile).getAbsolutePath();
            this.extraFiles.add(mapFile);
        }
    }

    private void parseOriginalMetadata(Node root) {
        String value = root.getNodeValue();
        if (value != null && value.trim().length() > 0) {
            Node grandparent;
            value = value.trim();
            String key = "";
            Node parent = root.getParentNode();
            if (parent != null) {
                key = this.getName(parent);
            }
            if ((grandparent = parent.getParentNode()) != null) {
                String name = this.getName(grandparent);
                key = name + " " + key;
            }
            this.addGlobalMeta(key, value);
        } else {
            NamedNodeMap attrs = root.getAttributes();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)attrs.item(i);
                    this.addGlobalMeta(this.getName(root) + " " + attr.getName(), attr.getValue());
                }
            }
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.parseOriginalMetadata(children.item(i));
            }
        }
    }

    class Tile
    implements Comparable<Tile> {
        public String file;
        public String[] files;
        public Region region;

        Tile() {
        }

        @Override
        public int compareTo(Tile o) {
            if (this.region.equals((Object)o.region)) {
                return 0;
            }
            int yDiff = this.region.y - o.region.y;
            if (yDiff != 0) {
                return yDiff;
            }
            return this.region.x - o.region.x;
        }

        public String toString() {
            return this.file + ", region = " + this.region;
        }
    }
}

