/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.units.quantity.Time;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsTimeEnumHandler;
import ome.xml.model.primitives.PrimitiveNumber;

public enum UnitsTime implements Enumeration
{
    YOTTASECOND("Ys"),
    ZETTASECOND("Zs"),
    EXASECOND("Es"),
    PETASECOND("Ps"),
    TERASECOND("Ts"),
    GIGASECOND("Gs"),
    MEGASECOND("Ms"),
    KILOSECOND("ks"),
    HECTOSECOND("hs"),
    DECASECOND("das"),
    SECOND("s"),
    DECISECOND("ds"),
    CENTISECOND("cs"),
    MILLISECOND("ms"),
    MICROSECOND("\u00b5s"),
    NANOSECOND("ns"),
    PICOSECOND("ps"),
    FEMTOSECOND("fs"),
    ATTOSECOND("as"),
    ZEPTOSECOND("zs"),
    YOCTOSECOND("ys"),
    MINUTE("min"),
    HOUR("h"),
    DAY("d");

    private final String value;

    private UnitsTime(String value) {
        this.value = value;
    }

    public static UnitsTime fromString(String value) throws EnumerationException {
        if ("Ys".equals(value)) {
            return YOTTASECOND;
        }
        if ("Zs".equals(value)) {
            return ZETTASECOND;
        }
        if ("Es".equals(value)) {
            return EXASECOND;
        }
        if ("Ps".equals(value)) {
            return PETASECOND;
        }
        if ("Ts".equals(value)) {
            return TERASECOND;
        }
        if ("Gs".equals(value)) {
            return GIGASECOND;
        }
        if ("Ms".equals(value)) {
            return MEGASECOND;
        }
        if ("ks".equals(value)) {
            return KILOSECOND;
        }
        if ("hs".equals(value)) {
            return HECTOSECOND;
        }
        if ("das".equals(value)) {
            return DECASECOND;
        }
        if ("s".equals(value)) {
            return SECOND;
        }
        if ("ds".equals(value)) {
            return DECISECOND;
        }
        if ("cs".equals(value)) {
            return CENTISECOND;
        }
        if ("ms".equals(value)) {
            return MILLISECOND;
        }
        if ("\u00b5s".equals(value)) {
            return MICROSECOND;
        }
        if ("ns".equals(value)) {
            return NANOSECOND;
        }
        if ("ps".equals(value)) {
            return PICOSECOND;
        }
        if ("fs".equals(value)) {
            return FEMTOSECOND;
        }
        if ("as".equals(value)) {
            return ATTOSECOND;
        }
        if ("zs".equals(value)) {
            return ZEPTOSECOND;
        }
        if ("ys".equals(value)) {
            return YOCTOSECOND;
        }
        if ("min".equals(value)) {
            return MINUTE;
        }
        if ("h".equals(value)) {
            return HOUR;
        }
        if ("d".equals(value)) {
            return DAY;
        }
        String s = String.format("'%s' not a supported value of '%s'", value, UnitsTime.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static <T extends PrimitiveNumber> Time create(T newValue, UnitsTime newUnit) {
        Time theQuantity = null;
        try {
            theQuantity = UnitsTimeEnumHandler.getQuantity(newValue, newUnit);
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return theQuantity;
    }

    public static <T extends Number> Time create(T newValue, UnitsTime newUnit) {
        Time theQuantity = null;
        try {
            theQuantity = UnitsTimeEnumHandler.getQuantity(newValue, newUnit);
        }
        catch (EnumerationException enumerationException) {
            // empty catch block
        }
        return theQuantity;
    }
}

