/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

@Immutable
public class VerticalCT
extends CoordinateTransform {
    private final Type type;
    private final VertTransformBuilderIF transformBuilder;

    protected VerticalCT(String name, String authority, Type type, List<Parameter> params) {
        super(name, authority, TransformType.Vertical, params);
        this.type = type;
        this.transformBuilder = null;
    }

    public VerticalCT(String name, String authority, Type type, VertTransformBuilderIF builder) {
        super(name, authority, TransformType.Vertical);
        this.type = type;
        this.transformBuilder = builder;
    }

    @Deprecated
    public VerticalCT(VerticalCT from) {
        super(from.getName(), from.getAuthority(), from.getTransformType());
        this.type = from.getVerticalTransformType();
        this.transformBuilder = from.getTransformBuilder();
    }

    public Type getVerticalTransformType() {
        return this.type;
    }

    public VerticalTransform makeVerticalTransform(NetcdfDataset ds, Dimension timeDim) {
        return this.transformBuilder.makeMathTransform(ds, timeDim, this);
    }

    @Deprecated
    public VertTransformBuilderIF getTransformBuilder() {
        return this.transformBuilder;
    }

    @Override
    public String toString() {
        String builderName = this.transformBuilder == null ? " none" : this.transformBuilder.getTransformName();
        return "VerticalCT {type=" + (Object)((Object)this.type) + ", builder=" + builderName + '}';
    }

    protected VerticalCT(Builder<?> builder, NetcdfDataset ncd) {
        super(builder, ncd);
        this.type = builder.type;
        this.transformBuilder = null;
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(VerticalCT.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> b) {
        return (Builder)super.addLocalFieldsToBuilder(b);
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends CoordinateTransform.Builder<T> {
        public Type type;
        private boolean built;

        @Override
        protected abstract T self();

        public Builder<?> setType(Type type) {
            this.type = type;
            return this.self();
        }

        @Override
        public VerticalCT build(NetcdfDataset ncd) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new VerticalCT(this, ncd);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static enum Type {
        HybridSigmaPressure("atmosphere_hybrid_sigma_pressure_coordinate"),
        HybridHeight("atmosphere_hybrid_height_coordinate"),
        LnPressure("atmosphere_ln_pressure_coordinate"),
        OceanSigma("ocean_sigma_coordinate"),
        OceanS("ocean_s_coordinate"),
        Sleve("atmosphere_sleve_coordinate"),
        Sigma("atmosphere_sigma_coordinate"),
        OceanSG1("ocean_s_g1"),
        OceanSG2("ocean_s_g2"),
        Existing3DField("atmosphere_sigma"),
        WRFEta("WRFEta");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public static Type getType(String name) {
            for (Type t2 : Type.values()) {
                if (!t2.name.equalsIgnoreCase(name)) continue;
                return t2;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

