/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.CoardsConventions;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.util.StringUtil2;

public class Nimbus
extends CoardsConventions {
    private static final String CONVENTION_NAME = "NCAR-RAF/nimbus";

    private Nimbus(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        String coordinates;
        boolean hasTime;
        this.rootGroup.addAttribute(new Attribute("cdm_data_type", FeatureType.TRAJECTORY.name()));
        this.rootGroup.addAttribute(new Attribute("featureType", FeatureType.TRAJECTORY.name()));
        if (!this.setAxisType("LATC", AxisType.Lat) && !this.setAxisType("LAT", AxisType.Lat)) {
            this.setAxisType("GGLAT", AxisType.Lat);
        }
        if (!this.setAxisType("LONC", AxisType.Lon) && !this.setAxisType("LON", AxisType.Lon)) {
            this.setAxisType("GGLON", AxisType.Lon);
        }
        if (!this.setAxisType("PALT", AxisType.Height)) {
            this.setAxisType("GGALT", AxisType.Height);
        }
        if (!(hasTime = this.setAxisType("Time", AxisType.Time))) {
            hasTime = this.setAxisType("time", AxisType.Time);
        }
        if (!hasTime) {
            this.rootGroup.findVariable("time_offset").ifPresent(time -> {
                try {
                    VariableDS.Builder base = (VariableDS.Builder)this.rootGroup.findVariable("base_time").get();
                    int base_time = base.orgVar.readScalarInt();
                    DateUnit dunit = new DateUnit("seconds since 1970-01-01 00:00");
                    String time_units = "seconds since " + dunit.makeStandardDateString(base_time);
                    time.addAttribute(new Attribute("units", time_units));
                    time.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.name()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if ((coordinates = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("coordinates", null)) != null) {
            for (String vname : StringUtil2.split(coordinates)) {
                this.rootGroup.findVariable(vname).ifPresent(v -> {
                    AxisType atype = this.getAxisType((VariableDS.Builder)v);
                    if (atype != null) {
                        v.addAttribute(new Attribute("_CoordinateAxisType", atype.name()));
                    }
                });
            }
        }
    }

    private boolean setAxisType(String varName, AxisType atype) {
        if (!this.rootGroup.findVariable(varName).isPresent()) {
            return false;
        }
        this.rootGroup.findVariable(varName).ifPresent(v -> v.addAttribute(new Attribute("_CoordinateAxisType", atype.toString())));
        return true;
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return Nimbus.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new Nimbus(datasetBuilder);
        }
    }
}

