/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.Modulo;
import loci.formats.ReaderWrapper;
import loci.formats.SwappableMetadata;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.meta.MetadataStore;

public class DimensionSwapper
extends ReaderWrapper {
    private List<CoreMetadata> core;

    public static DimensionSwapper makeDimensionSwapper(IFormatReader r) {
        if (r instanceof DimensionSwapper) {
            return (DimensionSwapper)r;
        }
        return new DimensionSwapper(r);
    }

    public DimensionSwapper() {
    }

    public DimensionSwapper(IFormatReader r) {
        super(r);
    }

    public void swapDimensions(String order) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        if (order == null) {
            throw new IllegalArgumentException("order is null");
        }
        String oldOrder = this.getInputOrder();
        if (order.equals(oldOrder)) {
            return;
        }
        if (order.length() != 5) {
            throw new IllegalArgumentException("order is unexpected length (" + order.length() + ")");
        }
        int newX = order.indexOf(88);
        int newY = order.indexOf(89);
        int newZ = order.indexOf(90);
        int newC = order.indexOf(67);
        int newT = order.indexOf(84);
        if (newX < 0) {
            throw new IllegalArgumentException("X does not appear");
        }
        if (newY < 0) {
            throw new IllegalArgumentException("Y does not appear");
        }
        if (newZ < 0) {
            throw new IllegalArgumentException("Z does not appear");
        }
        if (newC < 0) {
            throw new IllegalArgumentException("C does not appear");
        }
        if (newT < 0) {
            throw new IllegalArgumentException("T does not appear");
        }
        if (newX > 1) {
            throw new IllegalArgumentException("X in unexpected position (" + newX + ")");
        }
        if (newY > 1) {
            throw new IllegalArgumentException("Y in unexpected position (" + newY + ")");
        }
        int[] dims = new int[5];
        int oldX = oldOrder.indexOf(88);
        int oldY = oldOrder.indexOf(89);
        int oldZ = oldOrder.indexOf(90);
        int oldC = oldOrder.indexOf(67);
        int oldT = oldOrder.indexOf(84);
        if (oldC != newC && this.reader.getRGBChannelCount() > 1) {
            throw new IllegalArgumentException("Cannot swap C dimension when RGB channel count > 1");
        }
        dims[oldX] = this.getSizeX();
        dims[oldY] = this.getSizeY();
        dims[oldZ] = this.getSizeZ();
        dims[oldC] = this.getSizeC();
        dims[oldT] = this.getSizeT();
        Modulo[] moduli = new Modulo[3];
        moduli[oldZ - 2] = this.getModuloZ();
        moduli[oldC - 2] = this.getModuloC();
        moduli[oldT - 2] = this.getModuloT();
        SwappableMetadata ms = (SwappableMetadata)this.core.get(this.getCoreIndex());
        ms.sizeX = dims[newX];
        ms.sizeY = dims[newY];
        ms.sizeZ = dims[newZ];
        ms.sizeC = dims[newC];
        ms.sizeT = dims[newT];
        ms.moduloZ = moduli[newZ - 2];
        ms.moduloC = moduli[newC - 2];
        ms.moduloT = moduli[newT - 2];
        ms.inputOrder = order;
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    public void setOutputOrder(String outputOrder) {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        this.core.get((int)this.getCoreIndex()).dimensionOrder = outputOrder;
    }

    public String getInputOrder() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return ((SwappableMetadata)this.core.get((int)this.getCoreIndex())).inputOrder;
    }

    public int getSizeX() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core.get((int)this.getCoreIndex()).sizeX;
    }

    public int getSizeY() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core.get((int)this.getCoreIndex()).sizeY;
    }

    public int getSizeZ() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core.get((int)this.getCoreIndex()).sizeZ;
    }

    public int getSizeC() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core.get((int)this.getCoreIndex()).sizeC;
    }

    public int getSizeT() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core.get((int)this.getCoreIndex()).sizeT;
    }

    public String getDimensionOrder() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core.get((int)this.getCoreIndex()).dimensionOrder;
    }

    public byte[] openBytes(int no) throws FormatException, IOException {
        return super.openBytes(this.reorder(no));
    }

    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), x, y, w, h);
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return super.openBytes(this.reorder(no), buf, x, y, w, h);
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return super.openThumbBytes(this.reorder(no));
    }

    public int[] getZCTCoords(int no) {
        return FormatTools.getZCTCoords((IFormatReader)this, (int)no);
    }

    public int[] getZCTModuloCoords(int index) {
        return FormatTools.getZCTModuloCoords((IFormatReader)this, (int)index);
    }

    public int getIndex(int z, int c, int t) {
        return FormatTools.getIndex((IFormatReader)this, (int)z, (int)c, (int)t);
    }

    public int getIndex(int z, int c, int t, int moduloZ, int moduloC, int moduloT) {
        return FormatTools.getIndex((IFormatReader)this, (int)z, (int)c, (int)t, (int)moduloZ, (int)moduloC, (int)moduloT);
    }

    public List<CoreMetadata> getCoreMetadataList() {
        FormatTools.assertId((String)this.getCurrentFile(), (boolean)true, (int)2);
        return this.core;
    }

    public void setId(String id) throws FormatException, IOException {
        String oldFile = this.getCurrentFile();
        super.setId(id);
        if (!id.equals(oldFile) || this.core == null || this.core.size() != this.reader.getCoreMetadataList().size()) {
            List oldcore = this.reader.getCoreMetadataList();
            this.core = new ArrayList<CoreMetadata>();
            for (int s = 0; s < oldcore.size(); ++s) {
                SwappableMetadata swappable = new SwappableMetadata(this.reader, s);
                swappable.resolutionCount = ((CoreMetadata)oldcore.get((int)s)).resolutionCount;
                this.core.add(swappable);
            }
        }
    }

    public byte[] openCompressedBytes(int no, int x, int y) throws FormatException, IOException {
        return super.openCompressedBytes(this.reorder(no), x, y);
    }

    public byte[] openCompressedBytes(int no, byte[] buf, int x, int y) throws FormatException, IOException {
        return super.openCompressedBytes(this.reorder(no), buf, x, y);
    }

    public Codec getTileCodec(int no) throws FormatException, IOException {
        return super.getTileCodec(this.reorder(no));
    }

    public CodecOptions getTileCodecOptions(int no, int x, int y) throws FormatException, IOException {
        return super.getTileCodecOptions(this.reorder(no), x, y);
    }

    protected int reorder(int no) {
        if (this.getInputOrder() == null) {
            return no;
        }
        return FormatTools.getReorderedIndex((String)this.getInputOrder(), (String)this.getDimensionOrder(), (int)this.getSizeZ(), (int)this.getEffectiveSizeC(), (int)this.getSizeT(), (int)this.getImageCount(), (int)no);
    }
}

