/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine.tasks;

import java.sql.SQLException;
import mdbtools.dbengine.Data;
import mdbtools.dbengine.MemoryData;
import mdbtools.dbengine.functions.Aggregate;
import mdbtools.dbengine.functions.Function;
import mdbtools.dbengine.sql.FQColumn;
import mdbtools.dbengine.sql.FunctionDef;
import mdbtools.dbengine.sql.Select;
import mdbtools.dbengine.tasks.Task;

public class AggregateQuery
implements Task {
    private MemoryData result;
    private Task task;
    private Select sql;
    private int[] tableMap;

    public AggregateQuery(Task task, Select sql, int[] tableMap) {
        this.task = task;
        this.sql = sql;
        this.tableMap = tableMap;
    }

    @Override
    public void run() throws SQLException {
        this.result = new MemoryData();
        int numColumns = this.sql.getColumnCount();
        Data data = (Data)this.task.getResult();
        int groupByCount = this.sql.getGroupByCount();
        if (groupByCount != 0) {
            Object column;
            int currentGroupBy;
            Object[] prevRowGroupBy = new Object[groupByCount];
            Object[] currentRowGroupBy = new Object[groupByCount];
            boolean first = true;
            while (data.next()) {
                int i;
                currentGroupBy = 0;
                for (i = 0; i < numColumns; ++i) {
                    Object ob;
                    FQColumn fq;
                    Object column2 = this.sql.getColumn(i);
                    if (!(column2 instanceof FQColumn) || !(fq = (FQColumn)column2).equals(ob = this.sql.getGroupBy(currentGroupBy))) continue;
                    currentRowGroupBy[currentGroupBy++] = data.get(i);
                }
                if (!first && !this.equals(prevRowGroupBy, currentRowGroupBy)) {
                    int i2;
                    currentGroupBy = 0;
                    Object[] row = new Object[numColumns];
                    for (i2 = 0; i2 < numColumns; ++i2) {
                        column = this.sql.getColumn(i2);
                        column = column instanceof FunctionDef ? ((Aggregate)((FunctionDef)column).getFunction()).getResult() : this.resolveColumn(data, prevRowGroupBy[currentGroupBy]);
                        row[i2] = column;
                    }
                    this.result.addRow(row);
                    for (i2 = 0; i2 < groupByCount; ++i2) {
                        prevRowGroupBy[i2] = null;
                    }
                }
                for (i = 0; i < numColumns; ++i) {
                    this.resolveAggregateFunction(data, this.sql.getColumn(i));
                }
                Object[] tmp = prevRowGroupBy;
                prevRowGroupBy = currentRowGroupBy;
                currentRowGroupBy = tmp;
                if (!first) continue;
                first = false;
            }
            currentGroupBy = 0;
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                column = this.sql.getColumn(i);
                column = column instanceof FunctionDef ? ((Aggregate)((FunctionDef)column).getFunction()).getResult() : this.resolveColumn(data, prevRowGroupBy[currentGroupBy]);
                row[i] = column;
            }
            this.result.addRow(row);
        } else {
            while (data.next()) {
                for (int i = 0; i < numColumns; ++i) {
                    this.resolveAggregateFunction(data, this.sql.getColumn(i));
                }
            }
            Object[] row = new Object[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                Object column = this.sql.getColumn(i);
                if (column instanceof FunctionDef) {
                    column = ((Aggregate)((FunctionDef)column).getFunction()).getResult();
                }
                row[i] = column;
            }
            this.result.addRow(row);
        }
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    private boolean equals(Object[] a, Object[] b) throws SQLException {
        if (a.length != b.length) {
            throw new SQLException("a.length != b.length");
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    private void resolveAggregateFunction(Data data, Object column) throws SQLException {
        if (column instanceof FunctionDef) {
            FunctionDef fdef = (FunctionDef)column;
            Aggregate f = (Aggregate)fdef.getFunction();
            Object argument = fdef.getArgument();
            f.execute(this.resolveColumn(data, argument));
        }
    }

    private Object resolveColumn(Data data, Object column) throws SQLException {
        if (column instanceof FQColumn) {
            FQColumn c = (FQColumn)column;
            return data.get(this.tableMap[c.getTable()] + c.getColumn());
        }
        if (column instanceof FunctionDef) {
            FunctionDef fdef = (FunctionDef)column;
            Function f = (Function)fdef.getFunction();
            Object argument = fdef.getArgument();
            return f.execute(this.resolveColumn(data, argument));
        }
        return column;
    }
}

