/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteByteTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testWriteSequential() throws IOException {
        int i;
        for (i = 0; i < 16; ++i) {
            this.fileHandle.write(i + 1);
            if (!this.checkGrowth) continue;
            AssertJUnit.assertEquals((long)(i + 1), (long)this.fileHandle.length());
        }
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        this.fileHandle.seek(0L);
        for (i = 0; i < 16; ++i) {
            AssertJUnit.assertEquals((int)(i + 1), (int)this.fileHandle.readByte());
        }
    }

    @Test
    public void testWrite() throws IOException {
        this.fileHandle.write(1);
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.getFilePointer());
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.write(1);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteTwiceOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.write(1);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.write(1);
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }
}

