/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;

public class LZWCodec
extends BaseCodec {
    private static final int HASH_SIZE = 7349;
    private static final int HASH_STEP = 257;
    private static final int CLEAR_CODE = 256;
    private static final int EOI_CODE = 257;
    private static final int FIRST_CODE = 258;
    private static final int[] DECOMPR_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127};

    @Override
    public byte[] compress(byte[] input, CodecOptions options) throws CodecException {
        if (input == null || input.length == 0) {
            return input;
        }
        ByteBuffer output = this.compress(null, input, options);
        byte[] result = new byte[output.position()];
        output.flip();
        output.get(result);
        return result;
    }

    @Override
    public ByteBuffer compress(ByteBuffer output, byte[] input, CodecOptions options) throws CodecException {
        if (input == null || input.length == 0) {
            return ByteBuffer.allocate(0);
        }
        long bufferSize = (long)input.length * 141L / 100L + 3L;
        if (bufferSize > Integer.MAX_VALUE) {
            throw new CodecException("Output buffer is greater than 2 GB");
        }
        byte[] outArray = null;
        int outSize = 0;
        if (output == null || (long)output.remaining() < bufferSize || !output.hasArray()) {
            outArray = new byte[(int)bufferSize];
            output = ByteBuffer.wrap(outArray);
        } else {
            outArray = output.array();
            outSize = output.position() + output.arrayOffset();
        }
        outArray[outSize++] = -128;
        int currOutByte = 256;
        int usedBits = 1;
        int[] htKeys = new int[7349];
        int[] htValues = new int[7349];
        Arrays.fill(htKeys, -1);
        int nextCode = 258;
        int currCodeLength = 9;
        int tiffOmega = input[0] & 0xFF;
        block11: for (int currInPos = 1; currInPos < input.length; ++currInPos) {
            int tiffK = input[currInPos] & 0xFF;
            int hashKey = tiffOmega << 8 | tiffK;
            int hashCode = hashKey * 257 % 7349;
            while (htKeys[hashCode] >= 0) {
                if (htKeys[hashCode] == hashKey) {
                    tiffOmega = htValues[hashCode];
                    continue block11;
                }
                if (++hashCode != 7349) continue;
                hashCode = 0;
            }
            htKeys[hashCode] = hashKey;
            htValues[hashCode] = nextCode++;
            currOutByte = currOutByte << currCodeLength | tiffOmega;
            outArray[outSize++] = (byte)(currOutByte >> (usedBits += currCodeLength - 8));
            if (usedBits >= 8) {
                outArray[outSize++] = (byte)(currOutByte >> (usedBits -= 8));
            }
            tiffOmega = tiffK;
            switch (nextCode) {
                case 512: {
                    currCodeLength = 10;
                    continue block11;
                }
                case 1024: {
                    currCodeLength = 11;
                    continue block11;
                }
                case 2048: {
                    currCodeLength = 12;
                    continue block11;
                }
                case 4096: {
                    currOutByte = currOutByte << currCodeLength | 0x100;
                    outArray[outSize++] = (byte)(currOutByte >> (usedBits += currCodeLength - 8));
                    if (usedBits >= 8) {
                        outArray[outSize++] = (byte)(currOutByte >> (usedBits -= 8));
                    }
                    Arrays.fill(htKeys, -1);
                    nextCode = 258;
                    currCodeLength = 9;
                }
            }
        }
        currOutByte = currOutByte << currCodeLength | tiffOmega;
        outArray[outSize++] = (byte)(currOutByte >> (usedBits += currCodeLength - 8));
        if (usedBits >= 8) {
            outArray[outSize++] = (byte)(currOutByte >> (usedBits -= 8));
        }
        switch (nextCode) {
            case 511: {
                currCodeLength = 10;
                break;
            }
            case 1023: {
                currCodeLength = 11;
                break;
            }
            case 2047: {
                currCodeLength = 12;
            }
        }
        currOutByte = (currOutByte << currCodeLength | 0x101) << 8;
        outArray[outSize++] = (byte)(currOutByte >> (usedBits += currCodeLength));
        if (usedBits >= 8) {
            outArray[outSize++] = (byte)(currOutByte >> (usedBits -= 8));
            if (usedBits >= 8) {
                outArray[outSize++] = (byte)(currOutByte >> (usedBits -= 8));
            }
        }
        output.position(outSize - output.arrayOffset());
        return output;
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        if (in == null || in.length() == 0L) {
            return null;
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        byte[] output = new byte[options.maxBytes];
        int currOutPos = 0;
        int[] anotherCodes = new int[4096];
        byte[] newBytes = new byte[4096];
        int[] lengths = new int[4096];
        for (int i = 0; i < 256; ++i) {
            newBytes[i] = (byte)i;
            lengths[i] = 1;
        }
        int currCodeLength = 9;
        int nextCode = 258;
        int currRead = 0;
        int bitsRead = 0;
        int oldCode = 0;
        try {
            do {
                int i;
                int tablePos;
                int outLength;
                int bitsLeft;
                if ((bitsLeft = currCodeLength - bitsRead) > 8) {
                    currRead = currRead << 8 | in.read() & 0xFF;
                    bitsLeft -= 8;
                }
                bitsRead = 8 - bitsLeft;
                int nextByte = in.read() & 0xFF;
                int currCode = currRead << bitsLeft | nextByte >> bitsRead;
                currRead = nextByte & DECOMPR_MASKS[bitsRead];
                if (currCode == 257) break;
                if (currCode == 256) {
                    nextCode = 258;
                    currCodeLength = 9;
                    bitsLeft = currCodeLength - bitsRead;
                    if (bitsLeft > 8) {
                        currRead = currRead << 8 | in.read() & 0xFF;
                        bitsLeft -= 8;
                    }
                    bitsRead = 8 - bitsLeft;
                    nextByte = in.read() & 0xFF;
                    currCode = currRead << bitsLeft | nextByte >> bitsRead;
                    currRead = nextByte & DECOMPR_MASKS[bitsRead];
                    if (currCode == 257 || currOutPos >= output.length) break;
                    output[currOutPos++] = newBytes[currCode];
                    oldCode = currCode;
                } else if (currCode < nextCode) {
                    outLength = lengths[currCode];
                    tablePos = currCode;
                    for (i = currOutPos + outLength; i > output.length; --i) {
                        tablePos = anotherCodes[tablePos];
                    }
                    while (i > currOutPos) {
                        output[--i] = newBytes[tablePos];
                        tablePos = anotherCodes[tablePos];
                    }
                    if (i >= output.length) break;
                    currOutPos += outLength;
                    if (nextCode >= anotherCodes.length) break;
                    anotherCodes[nextCode] = oldCode;
                    newBytes[nextCode] = output[i];
                    lengths[nextCode] = lengths[oldCode] + 1;
                    oldCode = currCode;
                    ++nextCode;
                } else {
                    outLength = lengths[oldCode];
                    i = currOutPos + outLength;
                    tablePos = oldCode;
                    if (i > output.length) break;
                    while (i > currOutPos) {
                        output[--i] = newBytes[tablePos];
                        tablePos = anotherCodes[tablePos];
                    }
                    if ((currOutPos += outLength) > output.length - 1) break;
                    output[currOutPos++] = output[i];
                    anotherCodes[nextCode] = oldCode;
                    newBytes[nextCode] = output[i];
                    lengths[nextCode] = outLength + 1;
                    oldCode = currCode;
                    ++nextCode;
                }
                switch (nextCode) {
                    case 511: {
                        currCodeLength = 10;
                        break;
                    }
                    case 1023: {
                        currCodeLength = 11;
                        break;
                    }
                    case 2047: {
                        currCodeLength = 12;
                    }
                }
            } while (currOutPos < output.length && in.getFilePointer() < in.length());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CodecException("Invalid LZW data", e);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return output;
    }
}

