/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import loci.formats.IFormatReader;
import loci.formats.Memoizer;
import loci.formats.in.FakeReader;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MemoizerTest {
    private static final String TEST_FILE = "test&pixelType=int8&sizeX=20&sizeY=20&sizeC=1&sizeZ=1&sizeT=1.fake";
    private static final String TMP_PREFIX = MemoizerTest.class.getName() + ".";
    private File idDir;
    private String id;
    private FakeReader reader;

    private static File createTempDir() throws Exception {
        return Files.createTempDirectory(TMP_PREFIX, new FileAttribute[0]).toFile();
    }

    private static void recursiveDeleteOnExit(File rootDir) {
        rootDir.deleteOnExit();
        File[] children = rootDir.listFiles();
        if (null != children) {
            for (File child : children) {
                if (child.isDirectory()) {
                    MemoizerTest.recursiveDeleteOnExit(child);
                    continue;
                }
                child.deleteOnExit();
            }
        }
    }

    private static void checkMemo(Memoizer memoizer, String id) throws Exception {
        memoizer.setId(id);
        Assert.assertFalse((boolean)memoizer.isLoadedFromMemo());
        Assert.assertTrue((boolean)memoizer.isSavedToMemo());
        memoizer.close();
        memoizer.setId(id);
        Assert.assertTrue((boolean)memoizer.isLoadedFromMemo());
        Assert.assertFalse((boolean)memoizer.isSavedToMemo());
        memoizer.close();
    }

    private static void checkNoMemo(Memoizer memoizer, String id) throws Exception {
        memoizer.setId(id);
        Assert.assertFalse((boolean)memoizer.isLoadedFromMemo());
        Assert.assertFalse((boolean)memoizer.isSavedToMemo());
        memoizer.close();
    }

    private void checkMemoFile(File memoFile) {
        this.checkMemoFile(memoFile, this.idDir);
    }

    private void checkMemoFile(File memoFile, File memoDir) {
        File expMemoFile = new File(memoDir, ".test&pixelType=int8&sizeX=20&sizeY=20&sizeC=1&sizeZ=1&sizeT=1.fake.bfmemo");
        Assert.assertEquals((String)memoFile.getAbsolutePath(), (String)expMemoFile.getAbsolutePath());
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.idDir = MemoizerTest.createTempDir();
        File tempFile = new File(this.idDir, TEST_FILE);
        tempFile.createNewFile();
        this.id = tempFile.getAbsolutePath();
        this.reader = new FakeReader();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.reader.close();
        MemoizerTest.recursiveDeleteOnExit(this.idDir);
    }

    @Test
    public void testDefaultConstructor() throws Exception {
        Memoizer memoizer = new Memoizer();
        this.checkMemoFile(memoizer.getMemoFile(this.id));
    }

    @Test
    public void testNullReader() throws Exception {
        Memoizer memoizer = new Memoizer(null);
        this.checkMemoFile(memoizer.getMemoFile(this.id));
    }

    @Test
    public void testConstructorTimeElapsed() throws Exception {
        Memoizer memoizer = new Memoizer(0L);
        this.checkMemoFile(memoizer.getMemoFile(this.id));
        MemoizerTest.checkMemo(memoizer, this.id);
    }

    @Test
    public void testConstructorReader() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader);
        this.checkMemoFile(memoizer.getMemoFile(this.id));
    }

    @Test
    public void testConstructorReaderTimeElapsed() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L);
        this.checkMemoFile(memoizer.getMemoFile(this.id));
        MemoizerTest.checkMemo(memoizer, this.id);
    }

    @Test
    public void testConstructorTimeElapsedDirectory() throws Exception {
        File directory = MemoizerTest.createTempDir();
        directory.delete();
        Memoizer memoizer = new Memoizer(0L, directory);
        Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        directory.mkdirs();
        String memoDir = this.idDir.getAbsolutePath();
        memoDir = memoDir.substring(memoDir.indexOf(File.separator) + 1);
        this.checkMemoFile(memoizer.getMemoFile(this.id), new File(directory, memoDir));
        MemoizerTest.checkMemo(memoizer, this.id);
        MemoizerTest.recursiveDeleteOnExit(directory);
    }

    @Test
    public void testConstructorTimeElapsedNull() throws Exception {
        Memoizer memoizer = new Memoizer(0L, null);
        Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        MemoizerTest.checkNoMemo(memoizer, this.id);
    }

    @Test
    public void testConstructorReaderTimeElapsedDirectory() throws Exception {
        File directory = MemoizerTest.createTempDir();
        directory.delete();
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L, directory);
        Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        directory.mkdirs();
        String memoDir = this.idDir.getAbsolutePath();
        memoDir = memoDir.substring(memoDir.indexOf(File.separator) + 1);
        this.checkMemoFile(memoizer.getMemoFile(this.id), new File(directory, memoDir));
        MemoizerTest.checkMemo(memoizer, this.id);
        MemoizerTest.recursiveDeleteOnExit(directory);
    }

    @Test
    public void testConstructorReaderTimeElapsedNull() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L, null);
        Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        MemoizerTest.checkNoMemo(memoizer, this.id);
    }

    @Test
    public void testGetMemoFilePermissionsDirectory() throws Exception {
        File directory = MemoizerTest.createTempDir();
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L, directory);
        if (directory.setWritable(false)) {
            Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        }
    }

    @Test
    public void testGetMemoFilePermissionsInPlaceDirectory() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L, this.idDir);
        if (this.idDir.setWritable(false)) {
            Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        }
    }

    @Test
    public void testGetMemoFilePermissionsInPlace() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader);
        if (this.idDir.setWritable(false)) {
            Assert.assertNull((Object)memoizer.getMemoFile(this.id));
        }
    }

    @Test
    public void testRelocate() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L);
        memoizer.setId(this.id);
        memoizer.close();
        Assert.assertFalse((boolean)memoizer.isLoadedFromMemo());
        Assert.assertTrue((boolean)memoizer.isSavedToMemo());
        File newidDir = new File(this.idDir.getAbsolutePath() + ".new");
        this.idDir.renameTo(newidDir);
        File newtempFile = new File(newidDir, TEST_FILE);
        String newid = newtempFile.getAbsolutePath();
        memoizer.setId(newid);
        memoizer.close();
        Assert.assertTrue((boolean)memoizer.isLoadedFromMemo());
        Assert.assertFalse((boolean)memoizer.isSavedToMemo());
        MemoizerTest.recursiveDeleteOnExit(newidDir);
    }

    @Test
    public void testDeleteMemo() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L);
        memoizer.setId(this.id);
        memoizer.close();
        Assert.assertFalse((boolean)memoizer.isLoadedFromMemo());
        Assert.assertTrue((boolean)memoizer.isSavedToMemo());
        File currentMemoFile = memoizer.getMemoFile();
        Assert.assertTrue((boolean)currentMemoFile.exists());
        boolean success = memoizer.deleteMemo();
        Assert.assertTrue((boolean)success);
        Assert.assertFalse((boolean)currentMemoFile.exists());
    }

    @Test
    public void testWrappedReader() throws Exception {
        Memoizer memoizer = new Memoizer((IFormatReader)this.reader, 0L);
        File memoFile = memoizer.getMemoFile(this.id);
        Assert.assertFalse((boolean)memoFile.exists());
        this.reader.setId(this.id);
        Assert.assertFalse((boolean)memoFile.exists());
        this.reader.close();
        MemoizerTest.checkMemo(memoizer, this.id);
    }
}

