/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;

public class EPSReader
extends FormatReader {
    private int start;
    private boolean binary;
    private boolean isTiff;
    private IFDList ifds;
    private int[] map;

    public EPSReader() {
        super("Encapsulated PostScript", new String[]{"eps", "epsi", "ps"});
        this.domains = new String[]{"Graphics"};
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            if (this.isTiff) {
                return (int)((IFD)this.ifds.get(0)).getTileWidth();
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", (Throwable)e);
        }
        return super.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        try {
            if (this.isTiff) {
                return (int)((IFD)this.ifds.get(0)).getTileLength();
            }
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", (Throwable)e);
        }
        return super.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.isTiff) {
            long[] offsets = ((IFD)this.ifds.get(0)).getStripOffsets();
            long[] byteCounts = ((IFD)this.ifds.get(0)).getStripByteCounts();
            this.in.seek(offsets[0]);
            if (this.map == null) {
                this.readPlane(this.in, x, y, w, h, buf);
                return buf;
            }
            byte[] b = new byte[w * h];
            long bpp = byteCounts[0] / (long)(this.getSizeX() * this.getSizeY());
            this.in.skipBytes(bpp * (long)y * (long)this.getSizeX());
            for (int row = 0; row < h; ++row) {
                this.in.skipBytes((long)x * bpp);
                for (int col = 0; col < w; ++col) {
                    if (bpp == 1L) {
                        b[row * w + col] = this.in.readByte();
                        continue;
                    }
                    if (bpp != 2L) continue;
                    b[row * w + col] = (byte)(this.in.readShort() & 0xFF);
                }
                this.in.skipBytes(bpp * (long)(this.getSizeX() - w - x));
            }
            for (int i = 0; i < b.length; ++i) {
                int ndx = b[i] & 0xFF;
                for (int j = 0; j < this.getSizeC(); ++j) {
                    if (j < 3) {
                        buf[i * this.getSizeC() + j] = (byte)(this.map[ndx + j * 256] >> 8 & 0xFF);
                        continue;
                    }
                    boolean zero = this.map[ndx] == 0 && this.map[ndx + 256] == 0 && this.map[ndx + 512] == 0;
                    buf[i * this.getSizeC() + j] = zero ? 0 : -1;
                }
            }
            return buf;
        }
        if (this.start == 0) {
            throw new FormatException("Vector data not supported.");
        }
        this.in.seek(0L);
        for (int line = 0; line <= this.start; ++line) {
            this.readLine();
        }
        int bytes = FormatTools.getBytesPerPixel((int)this.getPixelType());
        if (this.binary) {
            this.readPlane(this.in, x, y, w, h, buf);
        } else {
            String pix = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
            pix = pix.replaceAll("\n", "");
            pix = pix.replaceAll("\r", "");
            int ndx = this.getSizeC() * y * bytes * this.getSizeX();
            int destNdx = 0;
            for (int row = 0; row < h; ++row) {
                ndx += x * this.getSizeC() * bytes;
                for (int col = 0; col < w * this.getSizeC() * bytes; ++col) {
                    buf[destNdx++] = (byte)Integer.parseInt(pix.substring(2 * ndx, 2 * (ndx + 1)), 16);
                    ++ndx;
                }
                ndx += this.getSizeC() * bytes * (this.getSizeX() - w - x);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.start = 0;
            this.isTiff = false;
            this.binary = false;
            this.ifds = null;
            this.map = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Verifying EPS format");
        String line = this.readLine();
        if (!line.trim().startsWith("%!PS")) {
            this.isTiff = true;
            this.in.order(true);
            this.in.seek(20L);
            int offset = this.in.readInt();
            int len = this.in.readInt();
            byte[] b = new byte[len];
            this.in.seek((long)offset);
            this.in.read(b);
            this.in.close();
            this.in = new RandomAccessInputStream(b);
            TiffParser tp = new TiffParser(this.in);
            this.ifds = tp.getMainIFDs();
            IFD firstIFD = (IFD)this.ifds.get(0);
            this.map = tp.getColorMap(firstIFD);
            m.sizeX = (int)firstIFD.getImageWidth();
            m.sizeY = (int)firstIFD.getImageLength();
            m.sizeZ = 1;
            m.sizeT = 1;
            m.sizeC = firstIFD.getSamplesPerPixel();
            if (this.map != null && this.getSizeC() == 1) {
                m.sizeC = 3;
            }
            if (this.getSizeC() == 2) {
                m.sizeC = 4;
            }
            m.littleEndian = firstIFD.isLittleEndian();
            m.interleaved = true;
            m.rgb = this.getSizeC() > 1;
            m.pixelType = firstIFD.getPixelType();
            m.imageCount = 1;
            m.dimensionOrder = "XYCZT";
            m.metadataComplete = true;
            m.indexed = false;
            m.falseColor = false;
            MetadataStore store = this.makeFilterMetadata();
            MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
            return;
        }
        LOGGER.info("Finding image data");
        this.binary = false;
        String image = "image";
        int lineNum = 1;
        line = this.readLine().trim();
        while (line != null && !line.equals("%%EOF")) {
            block16: {
                block14: {
                    block15: {
                        if (line.endsWith(image)) {
                            if (line.startsWith(image)) break;
                            if (line.indexOf("colorimage") != -1) {
                                m.sizeC = 3;
                            }
                            String[] t = line.split(" ");
                            try {
                                int newX = Integer.parseInt(t[0]);
                                int newY = Integer.parseInt(t[1]);
                                if (t.length <= 2 || Integer.parseInt(t[2]) < 8) break;
                                m.sizeX = newX;
                                m.sizeY = newY;
                                this.start = lineNum;
                            }
                            catch (NumberFormatException exc) {
                                LOGGER.debug("Could not parse image dimensions", (Throwable)exc);
                                if (t.length <= 3) break;
                                m.sizeC = Integer.parseInt(t[3]);
                            }
                            break;
                        }
                        if (!line.startsWith("%%")) break block14;
                        if (line.startsWith("%%BoundingBox:")) {
                            line = line.substring(14).trim();
                            String[] t = line.split(" ");
                            try {
                                int originX = Integer.parseInt(t[0].trim());
                                int originY = Integer.parseInt(t[1].trim());
                                m.sizeX = Integer.parseInt(t[2].trim()) - originX;
                                m.sizeY = Integer.parseInt(t[3].trim()) - originY;
                                this.addGlobalMeta("X-coordinate of origin", originX);
                                this.addGlobalMeta("Y-coordinate of origin", originY);
                            }
                            catch (NumberFormatException e) {
                                throw new FormatException("Files without image data are not supported.");
                            }
                        }
                        if (!line.startsWith("%%BeginBinary")) break block15;
                        this.binary = true;
                        break block16;
                    }
                    int ndx = line.indexOf(58);
                    if (ndx == -1) break block16;
                    String key = line.substring(0, ndx);
                    String value = line.substring(ndx + 1);
                    this.addGlobalMeta(key, value);
                    break block16;
                }
                if (line.startsWith("%ImageData:")) {
                    line = line.substring(11);
                    String[] t = line.split(" ");
                    m.sizeX = Integer.parseInt(t[0]);
                    m.sizeY = Integer.parseInt(t[1]);
                    m.sizeC = Integer.parseInt(t[3]);
                    for (int i = 4; i < t.length; ++i) {
                        image = t[i].trim();
                        if (image.length() <= 1) continue;
                        image = image.substring(1, image.length() - 1);
                    }
                }
            }
            ++lineNum;
            line = this.readLine().trim();
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeC() == 0) {
            m.sizeC = 1;
        }
        m.sizeZ = 1;
        m.sizeT = 1;
        m.dimensionOrder = "XYCZT";
        m.pixelType = 1;
        m.rgb = this.getSizeC() == 3;
        m.interleaved = true;
        m.littleEndian = true;
        m.imageCount = 1;
        MetadataStore store = this.getMetadataStore();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }

    private String readLine() throws IOException {
        String s = this.in.findString(new String[]{"\r", "\n"});
        return s.length() == 0 ? null : s;
    }
}

