/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractIntegerDistribution;
import org.apache.commons.math.distribution.BinomialDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.util.MathUtils;

public class BinomialDistributionImpl
extends AbstractIntegerDistribution
implements BinomialDistribution,
Serializable {
    private static final long serialVersionUID = 6751309484392813623L;
    private int numberOfTrials;
    private double probabilityOfSuccess;

    public BinomialDistributionImpl(int trials, double p) {
        this.setNumberOfTrials(trials);
        this.setProbabilityOfSuccess(p);
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    public void setNumberOfTrials(int trials) {
        if (trials < 0) {
            throw new IllegalArgumentException("number of trials must be non-negative.");
        }
        this.numberOfTrials = trials;
    }

    public void setProbabilityOfSuccess(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability of success must be between 0.0 and 1.0, inclusive.");
        }
        this.probabilityOfSuccess = p;
    }

    protected int getDomainLowerBound(double p) {
        return -1;
    }

    protected int getDomainUpperBound(double p) {
        return this.getNumberOfTrials();
    }

    public double cumulativeProbability(int x) throws MathException {
        double ret = x < 0 ? 0.0 : (x >= this.getNumberOfTrials() ? 1.0 : 1.0 - Beta.regularizedBeta(this.getProbabilityOfSuccess(), (double)x + 1.0, this.getNumberOfTrials() - x));
        return ret;
    }

    public double probability(int x) {
        double ret = x < 0 || x > this.getNumberOfTrials() ? 0.0 : MathUtils.binomialCoefficientDouble(this.getNumberOfTrials(), x) * Math.pow(this.getProbabilityOfSuccess(), x) * Math.pow(1.0 - this.getProbabilityOfSuccess(), this.getNumberOfTrials() - x);
        return ret;
    }

    public int inverseCumulativeProbability(double p) throws MathException {
        if (p == 0.0) {
            return -1;
        }
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        return super.inverseCumulativeProbability(p);
    }
}

