/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.LZOCodec;
import loci.formats.meta.MetadataStore;
import loci.formats.services.MetakitService;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;

public class VolocityReader
extends FormatReader {
    private static final String DATA_DIR = "Data";
    private static final String EMBEDDED_STREAM = "embedded-stream.raw";
    private static final int SIGNATURE_SIZE = 13;
    private ArrayList<Stack> stacks;
    private ArrayList<String> extraFiles;
    private Object[][] sampleTable;
    private Object[][] stringTable;
    private String dir = null;
    private ArrayList<Double[]> timestamps = new ArrayList();

    public VolocityReader() {
        super("Volocity Library", new String[]{"mvd2", "aisf", "aiix", "dat", "atsf"});
        this.domains = new String[]{"Unknown"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .mvd2 file plus a 'Data' directory";
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        files.addAll(this.extraFiles);
        if (!noPixels) {
            Stack stack = this.stacks.get(this.getSeries());
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                files.add(stack.pixelsFiles[c]);
            }
            if (stack.timestampFile != null) {
                files.add(stack.timestampFile);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public boolean isThisType(String name, boolean open) {
        if (VolocityReader.checkSuffix((String)name, (String)"mvd2")) {
            return super.isThisType(name, open);
        }
        if (open && VolocityReader.checkSuffix((String)name, (String[])this.suffixes)) {
            Location file = new Location(name).getAbsoluteFile();
            Location parent = file.getParentFile();
            if ((parent = parent.getParentFile()) != null && (parent = parent.getParentFile()) != null) {
                Location mvd2 = new Location(parent, parent.getName() + ".mvd2");
                return mvd2.exists() && super.isThisType(mvd2.getAbsolutePath());
            }
        }
        return false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)2, (boolean)false)) {
            return false;
        }
        String check = stream.readString(2);
        return check.equals("JL") || check.equals("LJ");
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        block23: {
            FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
            int[] zct = this.getZCTCoords(no);
            Stack stack = this.stacks.get(this.getSeries());
            if (!new Location(stack.pixelsFiles[zct[1]]).exists()) {
                Arrays.fill(buf, this.getFillColor());
                return buf;
            }
            try (RandomAccessInputStream pix = new RandomAccessInputStream(stack.pixelsFiles[zct[1]]);){
                long offset;
                int padding = zct[2] * stack.planePadding;
                long planeSize = FormatTools.getPlaneSize((IFormatReader)this);
                int planesInFile = (int)(pix.length() / planeSize);
                int planeIndex = no / this.getEffectiveSizeC();
                if (planesInFile == this.getSizeT()) {
                    planeIndex = zct[2];
                    int block = stack.blockSize;
                    padding = block - (int)(planeSize % (long)block);
                    if (padding == block) {
                        padding = 0;
                    }
                    padding *= zct[2];
                }
                if ((offset = (long)stack.blockSize + (long)planeIndex * planeSize + (long)padding) >= pix.length()) {
                    byte[] byArray = buf;
                    return byArray;
                }
                pix.seek(offset);
                if (stack.clippingData) {
                    pix.seek(offset - 3L);
                    ByteArrayHandle v = new ByteArrayHandle();
                    while (v.length() < (long)FormatTools.getPlaneSize((IFormatReader)this) && pix.getFilePointer() < pix.length()) {
                        try {
                            byte[] b = new LZOCodec().decompress(pix, null);
                            pix.skipBytes(4);
                            v.write(b);
                        }
                        catch (IOException b) {}
                    }
                    try (RandomAccessInputStream s = new RandomAccessInputStream((IRandomAccess)v);){
                        s.seek(0L);
                        this.readPlane(s, x, y, w, h, buf);
                        break block23;
                    }
                }
                if (pix.getFilePointer() + planeSize > pix.length()) {
                    byte[] byArray = buf;
                    return byArray;
                }
                this.readPlane(pix, x, y, w, h, buf);
            }
        }
        if (this.getRGBChannelCount() == 4) {
            for (int i = 0; i < buf.length / 4; ++i) {
                byte a = buf[i * 4];
                buf[i * 4] = buf[i * 4 + 1];
                buf[i * 4 + 1] = buf[i * 4 + 2];
                buf[i * 4 + 2] = buf[i * 4 + 3];
                buf[i * 4 + 3] = a;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.stacks = null;
            this.sampleTable = null;
            this.stringTable = null;
            this.dir = null;
            this.timestamps.clear();
            Location.mapFile((String)EMBEDDED_STREAM, null);
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Stack stack;
        int channelIndex;
        int i2;
        Location file;
        if (!VolocityReader.checkSuffix((String)id, (String)"mvd2")) {
            String[] files;
            file = new Location(id).getAbsoluteFile();
            Location parent = file.getParentFile().getParentFile();
            for (String f : files = parent.list(true)) {
                if (!VolocityReader.checkSuffix((String)f, (String)"mvd2")) continue;
                id = new Location(parent, f).getAbsolutePath();
                break;
            }
        }
        super.initFile(id);
        this.stacks = new ArrayList();
        this.extraFiles = new ArrayList();
        file = new Location(id).getAbsoluteFile();
        this.extraFiles.add(file.getAbsolutePath());
        Location parentDir = file.getParentFile();
        Location dataDir = new Location(parentDir, DATA_DIR);
        this.dir = dataDir.getAbsolutePath();
        if (dataDir.exists()) {
            String[] files;
            for (String f : files = dataDir.list(true)) {
                if (VolocityReader.checkSuffix((String)f, (String)"aisf") || VolocityReader.checkSuffix((String)f, (String)"atsf")) continue;
                this.extraFiles.add(new Location(dataDir, f).getAbsolutePath());
            }
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            MetakitService reader = (MetakitService)factory.getInstance(MetakitService.class);
            reader.initialize(id);
            this.sampleTable = reader.getTableData(1);
            this.stringTable = reader.getTableData(2);
            reader.close();
        }
        catch (DependencyException e) {
            throw new MissingLibraryException("Could not find Metakit library", (Throwable)e);
        }
        ArrayList<String> stackNames = new ArrayList<String>();
        ArrayList<Integer> parentIDs = new ArrayList<Integer>();
        for (i2 = 0; i2 < this.sampleTable.length; ++i2) {
            Integer stringID = (Integer)this.sampleTable[i2][11];
            String name = this.getString(stringID);
            channelIndex = this.getChildIndex((Integer)this.sampleTable[i2][0], "Channels");
            if (i2 <= 0 || (Integer)this.sampleTable[i2][2] != 1 || channelIndex < 0 && (this.sampleTable[i2][14] == null || this.sampleTable[i2][14].equals(0)) && ((byte[])this.sampleTable[i2][13]).length <= 21) continue;
            String parentName = this.getParentName((Integer)this.sampleTable[i2][1]);
            if (channelIndex < 0) {
                try (RandomAccessInputStream s = this.getStream(i2);){
                    s.seek(0L);
                    if (s.read() != 73) {
                        s.order(false);
                    }
                    s.seek(22L);
                    int x = s.readInt();
                    int y = s.readInt();
                    int z = s.readInt();
                    if (x * y * z <= 0 || (long)(x * y * z) >= s.length() * 3L) continue;
                    stackNames.add(parentName + name);
                    parentIDs.add((Integer)this.sampleTable[i2][0]);
                    continue;
                }
            }
            stackNames.add(parentName + name);
            parentIDs.add((Integer)this.sampleTable[i2][0]);
        }
        for (i2 = 0; i2 < parentIDs.size(); ++i2) {
            int zLocationIndex;
            int yLocationIndex;
            int xLocationIndex;
            int descriptionIndex;
            int detectorIndex;
            int objectiveIndex;
            int zIndex;
            int yIndex;
            int xIndex;
            int timestampIndex;
            stack = new Stack();
            stack.core = new CoreMetadata();
            Integer parent = (Integer)parentIDs.get(i2);
            channelIndex = this.getChildIndex(parent, "Channels");
            if (channelIndex >= 0) {
                Integer[] channels = this.getAllChildren((Integer)this.sampleTable[channelIndex][0]);
                stack.core.sizeC = channels.length;
                stack.pixelsFiles = new String[stack.core.sizeC];
                stack.channelNames = new String[channels.length];
                for (int c = 0; c < channels.length; ++c) {
                    stack.channelNames[c] = this.getString((Integer)this.sampleTable[channels[c]][11]);
                    try (RandomAccessInputStream data = this.getStream(channels[c]);){
                        if (data.length() > 22L) {
                            data.seek(22L);
                            int stackID = data.readInt();
                            Location f = new Location(this.dir, stackID + ".aisf");
                            if (!f.exists()) {
                                f = new Location(this.dir, DataTools.swap((int)stackID) + ".aisf");
                            }
                            stack.pixelsFiles[c] = f.getAbsolutePath();
                            continue;
                        }
                        Integer child = this.getAllChildren((Integer)this.sampleTable[channels[c]][0])[0];
                        stack.pixelsFiles[c] = this.getFile((Integer)this.sampleTable[child][0], this.dir);
                        continue;
                    }
                }
            } else {
                stack.pixelsFiles = new String[1];
                stack.pixelsFiles[0] = this.getFile(parent, this.dir);
                if (stack.pixelsFiles[0] == null || !new Location(stack.pixelsFiles[0]).exists()) {
                    int row = -1;
                    for (int r = 0; r < this.sampleTable.length; ++r) {
                        if (!this.sampleTable[r][0].equals(parent)) continue;
                        row = r;
                        break;
                    }
                    stack.pixelsFiles[0] = EMBEDDED_STREAM;
                    ByteArrayHandle data = new ByteArrayHandle((byte[])this.sampleTable[row][13]);
                    Location.mapFile((String)stack.pixelsFiles[0], (IRandomAccess)data);
                }
            }
            if ((timestampIndex = this.getChildIndex(parent, "Timepoint times stream")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(timestampIndex);){
                    data.seek(22L);
                    int timestampID = data.readInt();
                    Location f = new Location(this.dir, timestampID + ".atsf");
                    if (!f.exists()) {
                        f = new Location(this.dir, DataTools.swap((int)timestampID) + ".atsf");
                    }
                    stack.timestampFile = f.getAbsolutePath();
                }
            }
            if ((xIndex = this.getChildIndex(parent, "um/pixel (X)")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(xIndex);){
                    data.seek(13L);
                    stack.physicalX = data.readDouble();
                }
            }
            if ((yIndex = this.getChildIndex(parent, "um/pixel (Y)")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(yIndex);){
                    data.seek(13L);
                    stack.physicalY = data.readDouble();
                }
            }
            if ((zIndex = this.getChildIndex(parent, "um/pixel (Z)")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(zIndex);){
                    data.seek(13L);
                    stack.physicalZ = data.readDouble();
                }
            }
            if ((timestampIndex = this.getChildIndex(parent, "TimepointTimes")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(timestampIndex);){
                    data.seek(13L);
                }
            }
            if ((objectiveIndex = this.getChildIndex(parent, "Microscope Objective")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(objectiveIndex);){
                    data.seek(13L);
                    stack.magnification = data.readDouble();
                }
            }
            if ((detectorIndex = this.getChildIndex(parent, "Camera/Detector")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(detectorIndex);){
                    data.seek(13L);
                    int len = data.readInt();
                    stack.detector = data.readString(len);
                }
            }
            if ((descriptionIndex = this.getChildIndex(parent, "Experiment Description")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(descriptionIndex);){
                    data.seek(13L);
                    int len = data.readInt();
                    stack.description = data.readString(len);
                }
            }
            if ((xLocationIndex = this.getChildIndex(parent, "X Location")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(xLocationIndex);){
                    data.seek(13L);
                    stack.xLocation = data.readDouble();
                }
            }
            if ((yLocationIndex = this.getChildIndex(parent, "Y Location")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(yLocationIndex);){
                    data.seek(13L);
                    stack.yLocation = data.readDouble();
                }
            }
            if ((zLocationIndex = this.getChildIndex(parent, "Z Location")) >= 0) {
                try (RandomAccessInputStream data = this.getStream(zLocationIndex);){
                    data.seek(13L);
                    stack.zLocation = data.readDouble();
                }
            }
            this.stacks.add(stack);
        }
        for (i2 = 0; i2 < this.stacks.size(); ++i2) {
            stack = this.stacks.get(i2);
            if (!new Location(stack.pixelsFiles[0]).exists()) {
                this.stacks.remove(i2);
                --i2;
                continue;
            }
            long baseLength = 0L;
            try (RandomAccessInputStream base = new RandomAccessInputStream(stack.pixelsFiles[0]);){
                baseLength = base.length();
            }
            for (int q = 1; q < stack.pixelsFiles.length; ++q) {
                if (!new Location(stack.pixelsFiles[q]).exists()) continue;
                long length = 0L;
                try (RandomAccessInputStream base = new RandomAccessInputStream(stack.pixelsFiles[q]);){
                    length = base.length();
                }
                if (length <= baseLength) continue;
                Stack newStack = new Stack();
                newStack.timestampFile = stack.timestampFile;
                newStack.core = new CoreMetadata();
                newStack.physicalX = stack.physicalX;
                newStack.physicalY = stack.physicalY;
                newStack.physicalZ = stack.physicalZ;
                newStack.magnification = stack.magnification;
                newStack.detector = stack.detector;
                newStack.description = stack.description;
                newStack.xLocation = stack.xLocation;
                newStack.yLocation = stack.yLocation;
                newStack.zLocation = stack.zLocation;
                String[] pixels = stack.pixelsFiles;
                newStack.pixelsFiles = new String[pixels.length - q];
                System.arraycopy(pixels, q, newStack.pixelsFiles, 0, newStack.pixelsFiles.length);
                stack.pixelsFiles = new String[q];
                System.arraycopy(pixels, 0, stack.pixelsFiles, 0, q);
                String[] channels = stack.channelNames;
                newStack.channelNames = new String[channels.length - q];
                System.arraycopy(channels, q, newStack.channelNames, 0, newStack.channelNames.length);
                stack.channelNames = new String[q];
                System.arraycopy(channels, 0, stack.channelNames, 0, q);
                newStack.core.sizeC = newStack.channelNames.length;
                stack.core.sizeC = stack.channelNames.length;
                this.stacks.add(i2 + 1, newStack);
                stackNames.add(i2 + 1, (String)stackNames.get(i2));
            }
        }
        int seriesCount = this.stacks.size();
        this.core.clear();
        for (i = 0; i < seriesCount; ++i) {
            Stack stack2 = this.stacks.get(i);
            CoreMetadata ms = stack2.core;
            this.core.add(ms);
            this.setSeries(i);
            ms.littleEndian = true;
            if (stack2.timestampFile != null) {
                try (RandomAccessInputStream s = new RandomAccessInputStream(stack2.timestampFile);){
                    s.seek(0L);
                    if (s.read() != 73) {
                        ms.littleEndian = false;
                    }
                    s.seek(17L);
                    s.order(this.isLittleEndian());
                    ms.sizeT = s.readInt();
                    Double firstStamp = null;
                    Double[] stamps = new Double[ms.sizeT];
                    for (int t = 0; t < ms.sizeT; ++t) {
                        double timestamp = (double)s.readLong() / 1000000.0;
                        if (firstStamp == null) {
                            firstStamp = timestamp;
                        }
                        stamps[t] = timestamp - firstStamp;
                    }
                    this.timestamps.add(stamps);
                }
            } else {
                ms.sizeT = 1;
            }
            ms.rgb = false;
            ms.interleaved = true;
            ms.dimensionOrder = "XYCZT";
            try (RandomAccessInputStream s = new RandomAccessInputStream(stack2.pixelsFiles[0]);){
                s.order(this.isLittleEndian());
                if (VolocityReader.checkSuffix((String)stack2.pixelsFiles[0], (String)"aisf")) {
                    s.seek(18L);
                    stack2.blockSize = s.readShort() * 256;
                    s.skipBytes(5);
                    int x = s.readInt();
                    int y = s.readInt();
                    int zStart = s.readInt();
                    int w = s.readInt();
                    int h = s.readInt();
                    if (w - x < 0 || h - y < 0 || (w - x) * (h - y) < 0) {
                        ms.littleEndian = !this.isLittleEndian();
                        s.order(this.isLittleEndian());
                        s.seek(s.getFilePointer() - 20L);
                        x = s.readInt();
                        y = s.readInt();
                        zStart = s.readInt();
                        w = s.readInt();
                        h = s.readInt();
                    }
                    ms.sizeX = w - x;
                    ms.sizeY = h - y;
                    ms.sizeZ = s.readInt() - zStart;
                    ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                    ms.pixelType = 0;
                    int planesPerFile = this.getSizeZ() * this.getSizeT();
                    int planeSize = FormatTools.getPlaneSize((IFormatReader)this);
                    int bytesPerPixel = 0;
                    for (int bytesPerPlane = (int)((s.length() - (long)stack2.blockSize) / (long)planesPerFile); bytesPerPlane >= planeSize; bytesPerPlane -= planeSize) {
                        ++bytesPerPixel;
                    }
                    if (bytesPerPixel % 3 == 0) {
                        ms.sizeC *= 3;
                        ms.rgb = true;
                        bytesPerPixel /= 3;
                    }
                    ms.pixelType = FormatTools.pixelTypeFromBytes((int)bytesPerPixel, (boolean)false, (bytesPerPixel > 2 ? 1 : 0) != 0);
                    int timepoint = FormatTools.getPlaneSize((IFormatReader)this) * this.getSizeZ();
                    stack2.planePadding = stack2.blockSize - timepoint % stack2.blockSize;
                    if (stack2.planePadding != stack2.blockSize) continue;
                    stack2.planePadding = 0;
                    continue;
                }
                boolean embedded = Location.getMappedFile((String)EMBEDDED_STREAM) != null;
                s.seek(0L);
                if (s.read() != 73) {
                    ms.littleEndian = false;
                    s.order(false);
                }
                s.seek(22L);
                ms.sizeX = s.readInt();
                ms.sizeY = s.readInt();
                ms.sizeZ = s.readInt();
                ms.sizeC = embedded ? 1 : 4;
                ms.imageCount = this.getSizeZ() * this.getSizeT();
                ms.rgb = ms.sizeC > 1;
                ms.pixelType = 1;
                stack2.blockSize = embedded ? (int)s.getFilePointer() : 99;
                stack2.planePadding = 0;
                if (s.length() > (long)(ms.sizeX * ms.sizeY * ms.sizeZ * 6)) {
                    ms.pixelType = 3;
                    ms.sizeC = 3;
                    ms.rgb = true;
                }
                if (s.length() >= (long)(ms.sizeX * ms.sizeY * ms.sizeZ * ms.sizeC)) continue;
                ms.rgb = false;
                ms.sizeC = 1;
                long pixels = ms.sizeX * ms.sizeY * ms.sizeZ;
                double approximateBytes = (double)s.length() / (double)pixels;
                int bytes = (int)Math.ceil(approximateBytes);
                if (bytes == 0) {
                    bytes = 1;
                } else if (bytes == 3) {
                    bytes = 2;
                }
                ms.pixelType = FormatTools.pixelTypeFromBytes((int)bytes, (boolean)false, (boolean)false);
                s.seek(70L);
                stack2.blockSize = s.readInt();
                stack2.clippingData = true;
                continue;
            }
        }
        this.setSeries(0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.setSeries(i);
            Stack stack3 = this.stacks.get(i);
            this.addSeriesMeta("Name", stackNames.get(i));
            this.addSeriesMeta("Pixel width (in microns)", stack3.physicalX);
            this.addSeriesMeta("Pixel height (in microns)", stack3.physicalY);
            this.addSeriesMeta("Z step (in microns)", stack3.physicalZ);
            this.addSeriesMeta("Objective magnification", stack3.magnification);
            this.addSeriesMeta("Camera/Detector", stack3.detector);
            this.addSeriesMeta("Description", stack3.description);
            this.addSeriesMeta("X Location", stack3.xLocation);
            this.addSeriesMeta("Y Location", stack3.yLocation);
            this.addSeriesMeta("Z Location", stack3.zLocation);
            if (stack3.channelNames == null) continue;
            for (int c = 0; c < stack3.channelNames.length; ++c) {
                this.addSeriesMetaList("Channel", stack3.channelNames[c]);
            }
        }
        this.setSeries(0);
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrument, 0);
        for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
            store.setImageInstrumentRef(instrument, i3);
            this.setSeries(i3);
            Stack stack4 = this.stacks.get(i3);
            store.setImageName((String)stackNames.get(i3), i3);
            store.setImageDescription(stack4.description, i3);
            if (stack4.channelNames != null) {
                for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                    store.setChannelName(stack4.channelNames[c], i3, c);
                }
            }
            Length sizeX = FormatTools.getPhysicalSizeX((Double)stack4.physicalX);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)stack4.physicalY);
            Length sizeZ = FormatTools.getPhysicalSizeZ((Double)stack4.physicalZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, i3);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, i3);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, i3);
            }
            String objective = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, i3});
            store.setObjectiveID(objective, 0, i3);
            store.setObjectiveNominalMagnification(stack4.magnification, 0, i3);
            store.setObjectiveCorrection(MetadataTools.getCorrection((String)"Other"), 0, i3);
            store.setObjectiveImmersion(MetadataTools.getImmersion((String)"Other"), 0, i3);
            store.setObjectiveSettingsID(objective, i3);
            String detectorID = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, i3});
            store.setDetectorID(detectorID, 0, i3);
            store.setDetectorModel(stack4.detector, 0, i3);
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                store.setDetectorSettingsID(detectorID, i3, c);
            }
            for (int img = 0; img < this.getImageCount(); ++img) {
                int[] coords = this.getZCTCoords(img);
                int z = coords[0];
                Length xLoc = new Length((Number)stack4.xLocation, UNITS.REFERENCEFRAME);
                Length yLoc = new Length((Number)stack4.yLocation, UNITS.REFERENCEFRAME);
                store.setPlanePositionX(xLoc, i3, img);
                store.setPlanePositionY(yLoc, i3, img);
                if (stack4.physicalZ != null) {
                    double zLocNumber = stack4.zLocation + (double)z * stack4.physicalZ;
                    Length zLoc = new Length((Number)zLocNumber, UNITS.REFERENCEFRAME);
                    store.setPlanePositionZ(zLoc, i3, img);
                }
                if (i3 >= this.timestamps.size() || coords[2] >= this.timestamps.get(i3).length || this.timestamps.get(i3)[coords[2]] == null) continue;
                store.setPlaneDeltaT(new Time((Number)this.timestamps.get(i3)[coords[2]], UNITS.SECOND), i3, img);
            }
        }
        this.setSeries(0);
    }

    private String getParentName(Integer parentID) {
        String parentName = "";
        while (parentID != 1) {
            Integer originalID = parentID;
            for (int row = 0; row < this.sampleTable.length; ++row) {
                if (parentID.intValue() != ((Integer)this.sampleTable[row][0]).intValue()) continue;
                parentName = this.getString((Integer)this.sampleTable[row][11]) + "/" + parentName;
                parentID = (Integer)this.sampleTable[row][1];
                break;
            }
            if (!parentID.equals(originalID)) continue;
            break;
        }
        return parentName;
    }

    private String getString(Integer stringID) {
        for (int row = 0; row < this.stringTable.length; ++row) {
            if (!stringID.equals(this.stringTable[row][0])) continue;
            String s = (String)this.stringTable[row][1];
            if (s != null) {
                s = s.trim();
            }
            return s;
        }
        return null;
    }

    private int getChildIndex(Integer parentID, String childName) {
        for (int row = 0; row < this.sampleTable.length; ++row) {
            String name;
            if (!parentID.equals(this.sampleTable[row][1]) || !childName.equals(name = this.getString((Integer)this.sampleTable[row][11]))) continue;
            return row;
        }
        return -1;
    }

    private Integer[] getAllChildren(Integer parentID) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        for (int row = 0; row < this.sampleTable.length; ++row) {
            if (!parentID.equals(this.sampleTable[row][1])) continue;
            children.add(row);
        }
        return children.toArray(new Integer[children.size()]);
    }

    private RandomAccessInputStream getStream(int row) throws IOException {
        Object o = this.sampleTable[row][14];
        String fileLink = o == null ? "0" : o.toString().trim();
        RandomAccessInputStream data = null;
        if (fileLink.equals("0")) {
            data = new RandomAccessInputStream((byte[])this.sampleTable[row][13]);
        } else {
            fileLink = new Location(this.dir, fileLink + ".dat").getAbsolutePath();
            data = new RandomAccessInputStream(fileLink);
        }
        data.order(true);
        return data;
    }

    private String getFile(Integer parent, String dir) {
        for (int row = 0; row < this.sampleTable.length; ++row) {
            Object o;
            if (!parent.equals(this.sampleTable[row][0]) || (o = this.sampleTable[row][14]) == null) continue;
            String fileLink = o.toString().trim() + ".dat";
            return new Location(dir, fileLink).getAbsolutePath();
        }
        return null;
    }

    class Stack {
        public String[] pixelsFiles;
        public String timestampFile;
        public int planePadding;
        public int blockSize;
        public boolean clippingData;
        public CoreMetadata core;
        public String[] channelNames;
        public Double physicalX;
        public Double physicalY;
        public Double physicalZ;
        public Double magnification;
        public String detector;
        public String description;
        public double xLocation;
        public double yLocation;
        public double zLocation;

        Stack() {
        }
    }
}

