/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.convert;

import ch.systemsx.cisd.base.convert.NativeData;

public final class NativeArrayEncoding
extends Enum<NativeArrayEncoding> {
    public static final /* enum */ NativeArrayEncoding INT8_NATIVE = new NativeArrayEncoding(false, 1, NativeData.ByteOrder.NATIVE);
    public static final /* enum */ NativeArrayEncoding INT16_LITTLE_ENDIAN = new NativeArrayEncoding(false, 2, NativeData.ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ NativeArrayEncoding INT32_LITTLE_ENDIAN = new NativeArrayEncoding(false, 4, NativeData.ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ NativeArrayEncoding INT64_LITTLE_ENDIAN = new NativeArrayEncoding(false, 8, NativeData.ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ NativeArrayEncoding INT16_BIG_ENDIAN = new NativeArrayEncoding(false, 2, NativeData.ByteOrder.BIG_ENDIAN);
    public static final /* enum */ NativeArrayEncoding INT32_BIG_ENDIAN = new NativeArrayEncoding(false, 4, NativeData.ByteOrder.BIG_ENDIAN);
    public static final /* enum */ NativeArrayEncoding INT64_BIG_ENDIAN = new NativeArrayEncoding(false, 8, NativeData.ByteOrder.BIG_ENDIAN);
    public static final /* enum */ NativeArrayEncoding FLOAT32_LITTLE_ENDIAN = new NativeArrayEncoding(true, 4, NativeData.ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ NativeArrayEncoding FLOAT64_LITTLE_ENDIAN = new NativeArrayEncoding(true, 8, NativeData.ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ NativeArrayEncoding FLOAT32_BIG_ENDIAN = new NativeArrayEncoding(true, 4, NativeData.ByteOrder.BIG_ENDIAN);
    public static final /* enum */ NativeArrayEncoding FLOAT64_BIG_ENDIAN = new NativeArrayEncoding(true, 8, NativeData.ByteOrder.BIG_ENDIAN);
    private static final int MIN_ENCODING_HEADER_SIZE = 8;
    private static final int CHAR_N = 78;
    private static final int CHAR_B = 66;
    private static final int CHAR_L = 76;
    private static final int CHAR_I = 73;
    private static final int CHAR_F = 70;
    private boolean floatingPoint;
    private NativeData.ByteOrder byteOrder;
    private byte sizeInBytes;
    private byte[] magic;
    private static final /* synthetic */ NativeArrayEncoding[] ENUM$VALUES;

    static {
        ENUM$VALUES = new NativeArrayEncoding[]{INT8_NATIVE, INT16_LITTLE_ENDIAN, INT32_LITTLE_ENDIAN, INT64_LITTLE_ENDIAN, INT16_BIG_ENDIAN, INT32_BIG_ENDIAN, INT64_BIG_ENDIAN, FLOAT32_LITTLE_ENDIAN, FLOAT64_LITTLE_ENDIAN, FLOAT32_BIG_ENDIAN, FLOAT64_BIG_ENDIAN};
    }

    private NativeArrayEncoding(boolean floatingPoint, byte sizeInBytes, NativeData.ByteOrder byteOrder) {
        this.floatingPoint = floatingPoint;
        this.byteOrder = byteOrder;
        this.sizeInBytes = sizeInBytes;
        this.magic = new byte[]{(byte)(floatingPoint ? 70 : 73), (byte)(byteOrder == NativeData.ByteOrder.LITTLE_ENDIAN ? 76 : (byteOrder == NativeData.ByteOrder.BIG_ENDIAN ? 66 : 78)), sizeInBytes};
    }

    public boolean isFloatingPoint() {
        return this.floatingPoint;
    }

    public boolean isInteger() {
        return !this.floatingPoint;
    }

    public NativeData.ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public byte getSizeInBytes() {
        return this.sizeInBytes;
    }

    byte[] getMagic() {
        return this.magic;
    }

    static NativeArrayEncoding tryGetIntEncoding(NativeData.ByteOrder byteOrder, byte sizeInBytes) {
        assert (byteOrder != null);
        if (sizeInBytes == 1 && byteOrder == NativeData.ByteOrder.NATIVE) {
            return INT8_NATIVE;
        }
        if (sizeInBytes == 2) {
            return byteOrder == NativeData.ByteOrder.LITTLE_ENDIAN ? INT16_LITTLE_ENDIAN : INT16_BIG_ENDIAN;
        }
        if (sizeInBytes == 4) {
            return byteOrder == NativeData.ByteOrder.LITTLE_ENDIAN ? INT32_LITTLE_ENDIAN : INT32_BIG_ENDIAN;
        }
        if (sizeInBytes == 8) {
            return byteOrder == NativeData.ByteOrder.LITTLE_ENDIAN ? INT64_LITTLE_ENDIAN : INT64_BIG_ENDIAN;
        }
        return null;
    }

    static NativeArrayEncoding tryGetFloatEncoding(NativeData.ByteOrder byteOrder, byte sizeInBytes) {
        assert (byteOrder != null);
        if (sizeInBytes == 4) {
            return byteOrder == NativeData.ByteOrder.LITTLE_ENDIAN ? FLOAT32_LITTLE_ENDIAN : FLOAT32_BIG_ENDIAN;
        }
        if (sizeInBytes == 8) {
            return byteOrder == NativeData.ByteOrder.LITTLE_ENDIAN ? FLOAT64_LITTLE_ENDIAN : FLOAT64_BIG_ENDIAN;
        }
        return null;
    }

    public static NativeArrayEncoding tryGetEncoding(byte[] byteArr) {
        NativeData.ByteOrder byteOrder;
        if (byteArr.length < 8) {
            return null;
        }
        NativeData.ByteOrder byteOrder2 = byteArr[1] == 76 ? NativeData.ByteOrder.LITTLE_ENDIAN : (byteOrder = byteArr[1] == 66 ? NativeData.ByteOrder.BIG_ENDIAN : null);
        if (byteOrder == null) {
            return null;
        }
        if (byteArr[0] == 70) {
            return NativeArrayEncoding.tryGetFloatEncoding(byteOrder, byteArr[2]);
        }
        if (byteArr[0] == 73) {
            return NativeArrayEncoding.tryGetIntEncoding(byteOrder, byteArr[2]);
        }
        return null;
    }

    public static NativeArrayEncoding[] values() {
        NativeArrayEncoding[] nativeArrayEncodingArray = ENUM$VALUES;
        int n = nativeArrayEncodingArray.length;
        NativeArrayEncoding[] nativeArrayEncodingArray2 = new NativeArrayEncoding[n];
        System.arraycopy(ENUM$VALUES, 0, nativeArrayEncodingArray2, 0, n);
        return nativeArrayEncodingArray2;
    }

    public static NativeArrayEncoding valueOf(String string) {
        return Enum.valueOf(NativeArrayEncoding.class, string);
    }
}

