/*
 * Decompiled with CFR 0.152.
 */
package loci.tests;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;
import loci.formats.gui.AWTImageTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTester
extends JPanel
implements WindowListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageTester.class);
    private BufferedImage[][] img;

    public ImageTester(BufferedImage[][] img) {
        this.img = img;
    }

    @Override
    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, size.width, size.height);
        int xoff = 0;
        int yoff = 0;
        for (int y = 0; y < this.img.length; ++y) {
            int maxh = 0;
            for (int x = 0; x < this.img[y].length; ++x) {
                int w = this.img[y][x].getWidth();
                int h = this.img[y][x].getHeight();
                g.drawImage(this.img[y][x], xoff, yoff, this);
                xoff += w;
                if (h <= maxh) continue;
                maxh = h;
            }
            xoff = 0;
            yoff += maxh;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        for (int y = 0; y < this.img.length; ++y) {
            int wsum = 0;
            int maxh = 0;
            for (int x = 0; x < this.img[y].length; ++x) {
                int w = this.img[y][x].getWidth();
                int h = this.img[y][x].getHeight();
                wsum += w;
                if (h <= maxh) continue;
                maxh = h;
            }
            if (wsum > width) {
                width = wsum;
            }
            height += maxh;
        }
        return new Dimension(width, height);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public static void main(String[] args) {
        int q;
        int[] chan = new int[]{1, 3, 4};
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int wpad = 50;
        int hpad = 100;
        int w = (screen.width - wpad) / chan.length;
        int h = (screen.height - hpad) / 6;
        LOGGER.info("Using images of size {} x {}", (Object)w, (Object)h);
        int size = w * h;
        BufferedImage[] bimg1 = new BufferedImage[chan.length];
        BufferedImage[] bimg2 = new BufferedImage[chan.length];
        BufferedImage[] bimg3 = new BufferedImage[chan.length];
        BufferedImage[] simg1 = new BufferedImage[chan.length];
        BufferedImage[] simg2 = new BufferedImage[chan.length];
        BufferedImage[] simg3 = new BufferedImage[chan.length];
        for (q = 0; q < chan.length; ++q) {
            int c = chan[q];
            LOGGER.info("Building c={} images", (Object)c);
            byte[][] bdata1 = new byte[c][size];
            byte[] bdata2 = new byte[c * size];
            byte[] bdata3 = new byte[c * size];
            short[][] sdata1 = new short[c][size];
            short[] sdata2 = new short[c * size];
            short[] sdata3 = new short[c * size];
            for (int i = 0; i < c; ++i) {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        int ndx1 = w * y + x;
                        int ndx2 = c * ndx1 + i;
                        int ndx3 = i * size + ndx1;
                        float val = i == 0 ? (float)(x + y) / (float)(w + h) : (i == 1 ? (float)(x - y + h - 1) / (float)(w + h) : (i == 2 ? (float)(y - x + w - 1) / (float)(w + h) : (i == 3 ? (float)(x * y) / (float)size : (float)Math.random())));
                        int bval = (int)(256.0f * val);
                        int sval = (int)(65536.0f * val);
                        bdata1[i][ndx1] = (byte)bval;
                        bdata2[ndx2] = (byte)bval;
                        bdata3[ndx3] = (byte)bval;
                        sdata1[i][ndx1] = (short)sval;
                        sdata2[ndx2] = (short)sval;
                        sdata3[ndx3] = (short)sval;
                    }
                }
            }
            boolean signedBytes = false;
            bimg1[q] = AWTImageTools.makeImage((byte[][])bdata1, (int)w, (int)h, (boolean)signedBytes);
            bimg2[q] = AWTImageTools.makeImage((byte[])bdata2, (int)w, (int)h, (int)c, (boolean)true, (boolean)signedBytes);
            bimg3[q] = AWTImageTools.makeImage((byte[])bdata3, (int)w, (int)h, (int)c, (boolean)false, (boolean)signedBytes);
            boolean signedShorts = false;
            simg1[q] = AWTImageTools.makeImage((short[][])sdata1, (int)w, (int)h, (boolean)signedShorts);
            simg2[q] = AWTImageTools.makeImage((short[])sdata2, (int)w, (int)h, (int)c, (boolean)true, (boolean)signedShorts);
            simg3[q] = AWTImageTools.makeImage((short[])sdata3, (int)w, (int)h, (int)c, (boolean)false, (boolean)signedShorts);
        }
        LOGGER.info("Rows are: byte[][], byte[] (interleaved), byte[] (sequential)");
        LOGGER.info("  short[][], short[] (interleaved), short[] (sequential)");
        LOGGER.info("Columns are:");
        for (q = 0; q < chan.length; ++q) {
            if (q > 0) {
                LOGGER.info(",");
            }
            LOGGER.info(" c={}", (Object)chan[q]);
        }
        LOGGER.info("");
        JFrame frame = new JFrame("ImageTester");
        BufferedImage[][] img = new BufferedImage[][]{bimg1, bimg2, bimg3, simg1, simg2, simg3};
        ImageTester pane = new ImageTester(img);
        frame.addWindowListener(pane);
        frame.setContentPane(pane);
        frame.pack();
        frame.setVisible(true);
    }
}

