/*
 * Decompiled with CFR 0.152.
 */
package ome.specification;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import ome.specification.SchemaResolver;
import org.w3c.dom.Document;

public class OmeValidator {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public boolean isValidFile(File file, File schema) {
        try {
            this.parseFile(file, schema);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidFile(File file, StreamSource[] schemaStreamArray) {
        try {
            this.parseFileWithStreamArray(file, schemaStreamArray);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void validateFile(File file, StreamSource[] schemaStreamArray) throws Exception {
        this.parseFileWithStreamArray(file, schemaStreamArray);
    }

    public void validateFile(File file, File schema) throws Exception {
        this.parseFile(file, schema);
    }

    public void validateFileToStdError(File file, StreamSource[] schemaStreamArray) throws Exception {
        this.parseFileWithStreamArrayToSdtErr(file, schemaStreamArray);
    }

    public Document parseFile(File file) throws Exception {
        return this.parseFile(file, null);
    }

    public Document parseFile(File file, File schema) throws Exception {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("No file to parse.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        if (schema != null) {
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, schema);
        }
        try (FileInputStream is = null;){
            DocumentBuilder builder = dbf.newDocumentBuilder();
            is = new FileInputStream(file);
            Document document = builder.parse(is);
            return document;
        }
    }

    public Document parseFileWithStreamArray(File file, StreamSource[] schemaStreamArray) throws Exception {
        Document document;
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("No file to parse.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SchemaFactory sFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        SchemaResolver theTestClassResolver = new SchemaResolver();
        sFactory.setResourceResolver(theTestClassResolver);
        Schema theSchema = sFactory.newSchema(schemaStreamArray);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        FileInputStream is = new FileInputStream(file);
        try {
            Document theDoc = builder.parse(is);
            Validator validator = theSchema.newValidator();
            validator.validate(new DOMSource(theDoc));
            document = theDoc;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new Exception("Cannot parse the file", e);
            }
        }
        is.close();
        return document;
    }

    public Document parseFileWithStreamArrayToSdtErr(File file, StreamSource[] schemaStreamArray) throws Exception {
        if (file == null || !file.exists()) {
            throw new IllegalArgumentException("No file to parse.");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        SchemaFactory sFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
        SchemaResolver theTestClassResolver = new SchemaResolver();
        sFactory.setResourceResolver(theTestClassResolver);
        Schema theSchema = sFactory.newSchema(schemaStreamArray);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try (FileInputStream is = null;){
            dbf.setSchema(theSchema);
            is = new FileInputStream(file);
            Document document = builder.parse(is);
            return document;
        }
    }
}

