/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.SigmaMakernoteDirectory;

public class SigmaMakernoteDescriptor
extends TagDescriptor<SigmaMakernoteDirectory> {
    public SigmaMakernoteDescriptor(@NotNull SigmaMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 8: {
                return this.getExposureModeDescription();
            }
            case 9: {
                return this.getMeteringModeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String getMeteringModeDescription() {
        String value = ((SigmaMakernoteDirectory)this._directory).getString(9);
        if (value == null || value.length() == 0) {
            return null;
        }
        switch (value.charAt(0)) {
            case '8': {
                return "Multi Segment";
            }
            case 'A': {
                return "Average";
            }
            case 'C': {
                return "Center Weighted Average";
            }
        }
        return value;
    }

    @Nullable
    private String getExposureModeDescription() {
        String value = ((SigmaMakernoteDirectory)this._directory).getString(8);
        if (value == null || value.length() == 0) {
            return null;
        }
        switch (value.charAt(0)) {
            case 'A': {
                return "Aperture Priority AE";
            }
            case 'M': {
                return "Manual";
            }
            case 'P': {
                return "Program AE";
            }
            case 'S': {
                return "Shutter Speed Priority AE";
            }
        }
        return value;
    }
}

