/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteCharsTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testWriteSequential() throws IOException {
        this.fileHandle.writeChars("ab");
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChars("cd");
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChars("ef");
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeChars("gh");
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        this.fileHandle.seek(0L);
        for (byte i = 97; i < 105; i = (byte)(i + 1)) {
            AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
            AssertJUnit.assertEquals((byte)i, (byte)this.fileHandle.readByte());
        }
    }

    @Test
    public void testWrite() throws IOException {
        this.fileHandle.writeChars("ab");
        AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.getFilePointer());
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)97, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)98, (byte)this.fileHandle.readByte());
    }

    @Test
    public void testWriteOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.writeChars("wx");
        AssertJUnit.assertEquals((long)20L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)20L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)119, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)120, (byte)this.fileHandle.readByte());
    }

    @Test
    public void testWriteTwiceOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.writeChars("wx");
        this.fileHandle.writeChars("yz");
        AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)119, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)120, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)121, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)0, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((byte)122, (byte)this.fileHandle.readByte());
    }
}

