/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.Region;
import loci.common.services.ServiceException;
import loci.formats.services.JPEGTurboService;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.scijava.nativelib.NativeLibraryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEGTurboServiceImpl
implements JPEGTurboService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPEGTurboServiceImpl.class);
    private static final String NATIVE_LIB_CLASS = "org.scijava.nativelib.NativeLibraryUtil";
    private static final int SOF0 = 65472;
    private static final int DRI = 65501;
    private static final int SOS = 65498;
    private static final int RST0 = 65488;
    private static final int RST7 = 65495;
    private static final int EOI = 65497;
    private transient java.util.logging.Logger logger;
    private int imageWidth;
    private int imageHeight;
    private long offset;
    private RandomAccessInputStream in;
    private int restartInterval = 1;
    private long sos;
    private long imageDimensions;
    private int mcuWidth;
    private int mcuHeight;
    private int tileWidth;
    private int tileHeight;
    private int xTiles;
    private int yTiles;
    private ArrayList<Long> restartMarkers = new ArrayList();
    private byte[] header;
    private static boolean libraryLoaded = false;

    public JPEGTurboServiceImpl() {
        this.logger = java.util.logging.Logger.getLogger(NATIVE_LIB_CLASS);
        this.logger.setLevel(Level.SEVERE);
        if (!libraryLoaded) {
            libraryLoaded = NativeLibraryUtil.loadNativeLibrary(TJ.class, (String)"turbojpeg");
        }
    }

    @Override
    public void setRestartMarkers(long[] markers) {
        this.restartMarkers.clear();
        if (markers != null) {
            for (long marker : markers) {
                this.restartMarkers.add(marker);
            }
        }
    }

    @Override
    public long[] getRestartMarkers() {
        long[] markers = new long[this.restartMarkers.size()];
        for (int i = 0; i < markers.length; ++i) {
            markers[i] = this.restartMarkers.get(i);
        }
        return markers;
    }

    @Override
    public void initialize(RandomAccessInputStream jpeg, int width, int height) throws ServiceException, IOException {
        this.in = jpeg;
        this.imageWidth = width;
        this.imageHeight = height;
        this.offset = jpeg.getFilePointer();
        this.in.skipBytes(2);
        int marker = this.in.readShort() & 0xFFFF;
        boolean inImage = false;
        while (!inImage && this.in.getFilePointer() + 2L < this.in.length()) {
            int length = this.in.readShort() & 0xFFFF;
            long end = this.in.getFilePointer() + (long)length - 2L;
            LOGGER.debug("found marker = {} at pointer = {}", (Object)marker, (Object)this.in.getFilePointer());
            if (marker == 65501) {
                this.restartInterval = this.in.readShort() & 0xFFFF;
                LOGGER.debug("set restart interval to {}", (Object)this.restartInterval);
            } else if (marker == 65472) {
                this.imageDimensions = this.in.getFilePointer() + 1L;
                this.parseSOF();
            } else {
                if (marker > 65472 && marker < 65488 && marker % 4 != 0) {
                    throw new IOException("Unsupported JPEG SOF marker: " + marker);
                }
                if (marker == 65498) {
                    this.sos = end;
                    inImage = true;
                    if (this.restartMarkers.size() != 0) {
                        long diff = this.sos - this.restartMarkers.get(0);
                        for (int i = 0; i < this.restartMarkers.size(); ++i) {
                            long original = this.restartMarkers.get(i);
                            this.restartMarkers.set(i, original += diff);
                        }
                        break;
                    }
                    this.restartMarkers.add(this.sos);
                }
            }
            if (end >= this.in.length() || inImage) continue;
            this.in.seek(end);
            marker = this.in.readShort() & 0xFFFF;
        }
        if (this.restartMarkers.size() == 1) {
            this.in.seek(this.restartMarkers.get(0).longValue());
            byte[] buf = new byte[0xA00000];
            this.in.read(buf, 0, 4);
            while (this.in.getFilePointer() < this.in.length()) {
                int n = this.in.read(buf, 4, (int)Math.min((long)(buf.length - 4), this.in.length() - this.in.getFilePointer()));
                n += 4;
                for (int i = 0; i < n - 1; ++i) {
                    marker = DataTools.bytesToShort((byte[])buf, (int)i, (int)2, (boolean)false) & 0xFFFF;
                    if (marker < 65488 || marker > 65495) continue;
                    this.restartMarkers.add(this.in.getFilePointer() - (long)n + (long)i + 2L);
                    LOGGER.debug("adding RST marker at {}", (Object)this.restartMarkers.get(this.restartMarkers.size() - 1));
                    i += this.restartInterval;
                }
                System.arraycopy(buf, n - 4, buf, 0, 4);
            }
        }
        this.tileWidth = this.restartInterval * this.mcuWidth;
        this.tileHeight = Math.min(this.tileWidth, 512);
        this.xTiles = this.imageWidth / this.tileWidth;
        this.yTiles = this.imageHeight / this.tileHeight;
        if (this.xTiles * this.tileWidth != this.imageWidth) {
            ++this.xTiles;
        }
        if (this.yTiles * this.tileHeight != this.imageHeight) {
            ++this.yTiles;
        }
        if (this.restartInterval == 1 && this.restartMarkers.size() <= 1) {
            throw new IOException("The tiled-JPEG reader only supports images encoded with restart markers");
        }
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }

    @Override
    public int getTileRows() {
        return this.yTiles;
    }

    @Override
    public int getTileColumns() {
        return this.xTiles;
    }

    @Override
    public byte[] getTile(byte[] buf, int xCoordinate, int yCoordinate, int width, int height) throws IOException {
        Region image = new Region(xCoordinate, yCoordinate, width, height);
        int bufX = 0;
        int bufY = 0;
        int outputRowLen = width * 3;
        Region intersection = null;
        Region tileBoundary = new Region(0, 0, 0, 0);
        byte[] tile = null;
        for (int row = 0; row < this.yTiles; ++row) {
            tileBoundary.height = row < this.yTiles - 1 ? this.tileHeight : this.imageHeight - this.tileHeight * row;
            tileBoundary.y = row * this.tileHeight;
            for (int col = 0; col < this.xTiles; ++col) {
                tileBoundary.x = col * this.tileWidth;
                int n = tileBoundary.width = col < this.xTiles - 1 ? this.tileWidth : this.imageWidth - this.tileWidth * col;
                if (!tileBoundary.intersects(image)) continue;
                intersection = image.intersection(tileBoundary);
                tile = this.getTile(col, row);
                int rowLen = 3 * Math.min(tileBoundary.width, intersection.width);
                int outputOffset = bufY * outputRowLen + bufX;
                int intersectionX = 0;
                if (tileBoundary.x < image.x) {
                    intersectionX = image.x - tileBoundary.x;
                }
                for (int trow = 0; trow < intersection.height; ++trow) {
                    int realRow = trow + intersection.y - tileBoundary.y;
                    int inputOffset = 3 * (realRow * this.tileWidth + intersectionX);
                    System.arraycopy(tile, inputOffset, buf, outputOffset, rowLen);
                    outputOffset += outputRowLen;
                }
                bufX += rowLen;
            }
            if (intersection != null) {
                bufX = 0;
                bufY += intersection.height;
            }
            if (bufY >= height) break;
        }
        return buf;
    }

    @Override
    public byte[] getTile(int tileX, int tileY) throws IOException {
        byte[] compressedData = this.getCompressedTile(tileX, tileY);
        try {
            int pixelType = 0;
            int pixelSize = TJ.getPixelSize((int)pixelType);
            TJDecompressor decoder = new TJDecompressor(compressedData);
            byte[] decompressed = decoder.decompress(this.tileWidth, this.tileWidth * pixelSize, this.tileHeight, pixelType, pixelType);
            compressedData = null;
            decoder.close();
            return decompressed;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    @Override
    public byte[] getCompressedTile(int tileX, int tileY) throws IOException {
        if (this.header == null) {
            this.header = this.getFixedHeader();
        }
        long dataLength = this.header.length + 2;
        int mult = this.tileHeight / this.mcuHeight;
        int start = tileX + tileY * this.xTiles * mult;
        for (int row = 0; row < this.tileHeight / this.mcuHeight; ++row) {
            int end = start + 1;
            long startOffset = this.restartMarkers.get(start);
            long endOffset = this.in.length();
            if (end < this.restartMarkers.size()) {
                endOffset = this.restartMarkers.get(end);
            }
            dataLength += endOffset - startOffset;
            if ((start += this.xTiles) >= this.restartMarkers.size()) break;
        }
        byte[] data = new byte[(int)dataLength];
        return this.getCompressedTile(data, tileX, tileY);
    }

    @Override
    public byte[] getCompressedTile(byte[] data, int tileX, int tileY) throws IOException {
        if (this.header == null) {
            this.header = this.getFixedHeader();
        }
        int offset = 0;
        System.arraycopy(this.header, 0, data, offset, this.header.length);
        offset += this.header.length;
        int mult = this.tileHeight / this.mcuHeight;
        int start = tileX + tileY * this.xTiles * mult;
        for (int row = 0; row < this.tileHeight / this.mcuHeight; ++row) {
            int end = start + 1;
            long endOffset = this.in.length();
            if (end < this.restartMarkers.size()) {
                endOffset = this.restartMarkers.get(end);
            }
            long startOffset = this.restartMarkers.get(start);
            this.in.seek(startOffset);
            int toRead = (int)(endOffset - startOffset - 2L);
            this.in.read(data, offset, toRead);
            DataTools.unpackBytes((long)(65488 + row % 8), (byte[])data, (int)(offset += toRead), (int)2, (boolean)false);
            offset += 2;
            if ((start += this.xTiles) >= this.restartMarkers.size()) break;
        }
        DataTools.unpackBytes((long)65497L, (byte[])data, (int)offset, (int)2, (boolean)false);
        return data;
    }

    @Override
    public void close() throws IOException {
        this.logger = null;
        this.imageWidth = 0;
        this.imageHeight = 0;
        if (this.in != null) {
            this.in.close();
        }
        this.in = null;
        this.offset = 0L;
        this.restartMarkers.clear();
        this.restartInterval = 1;
        this.sos = 0L;
        this.imageDimensions = 0L;
        this.mcuWidth = 0;
        this.mcuHeight = 0;
        this.tileWidth = 0;
        this.tileHeight = 0;
        this.xTiles = 0;
        this.yTiles = 0;
        this.header = null;
    }

    @Override
    public boolean isLibraryLoaded() {
        return libraryLoaded;
    }

    private byte[] getFixedHeader() throws IOException {
        this.in.seek(this.offset);
        byte[] header = new byte[(int)(this.sos - this.offset)];
        this.in.read(header);
        int index = (int)(this.imageDimensions - this.offset);
        DataTools.unpackBytes((long)this.tileHeight, (byte[])header, (int)index, (int)2, (boolean)false);
        DataTools.unpackBytes((long)this.tileWidth, (byte[])header, (int)(index + 2), (int)2, (boolean)false);
        return header;
    }

    private void parseSOF() throws IOException {
        int bpc = this.in.readByte() & 0xFF;
        if (bpc != 8) {
            throw new IOException("Only 8-bit channels supported by this reader");
        }
        this.in.skipBytes(4);
        int channels = this.in.readByte() & 0xFF;
        if (channels != 3) {
            throw new IOException("Only images with 3 channels are supported by this reader");
        }
        int maxX = 0;
        int maxY = 0;
        for (int i = 0; i < channels; ++i) {
            int componentId = this.in.readByte() & 0xFF;
            byte rates = this.in.readByte();
            int X = rates & 0xF0;
            int Y = rates & 0xF;
            maxX = Math.max(maxX, X);
            maxY = Math.max(maxY, Y);
            int n = this.in.readByte() & 0xFF;
        }
        this.mcuWidth = (maxX >> 4) * 8;
        this.mcuHeight = maxY * 8;
    }
}

