/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.in;

import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import loci.common.Location;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ImporterTest {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ImporterTest.class);
    static final boolean RUN_SPECIAL_TESTS = false;
    private static final boolean[] BOOLEAN_STATES = new boolean[]{false, true};
    private static final int[] MINIMAL_PIXEL_TYPES = new int[]{1, 3};
    private static Color[] DEFAULT_COLOR_ORDER = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.WHITE, Color.CYAN, Color.MAGENTA, Color.YELLOW};
    private static Color[] CUSTOM_COLOR_ORDER = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.MAGENTA, Color.YELLOW, Color.CYAN, Color.WHITE};
    private static final boolean NOT_INDEXED = false;
    private static final boolean INDEXED = true;
    private static final boolean FALSE_COLOR = true;
    private static final boolean REAL_COLOR = false;
    private static final int ONE_SERIES = 1;
    private static final String[] FAKE_FILES;
    private static final String FAKE_PATTERN;
    private static final int FAKE_PLANE_COUNT = 7;
    private static final int FAKE_CHANNEL_COUNT = 3;
    private static final int FAKE_TIMEPOINT_COUNT = 5;
    private static final int FAKE_SIZE_X = 50;
    private static final int FAKE_SIZE_Y = 50;

    private static String constructFakeFilename(String title, int pixelType, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int numSeries, boolean indexed, int rgb, boolean falseColor, int lutLength) {
        if (sizeX < 41) {
            throw new IllegalArgumentException("Width < 41 can break some tests");
        }
        StringBuffer filename = new StringBuffer(title);
        filename.append("&pixelType=");
        filename.append(FormatTools.getPixelTypeString((int)pixelType));
        filename.append("&sizeX=");
        filename.append(sizeX);
        filename.append("&sizeY=");
        filename.append(sizeY);
        filename.append("&sizeZ=");
        filename.append(sizeZ);
        filename.append("&sizeC=");
        filename.append(sizeC);
        filename.append("&sizeT=");
        filename.append(sizeT);
        if (numSeries > 0) {
            filename.append("&series=");
            filename.append(numSeries);
        }
        if (indexed) {
            filename.append("&indexed=true");
        }
        if (rgb != -1) {
            filename.append("&rgb=");
            filename.append(rgb);
        }
        if (falseColor) {
            filename.append("&falseColor=true");
        }
        if (lutLength > 0) {
            filename.append("&lutLength=");
            filename.append(lutLength);
        }
        filename.append(".fake");
        return filename.toString();
    }

    private int sIndex(ImageProcessor proc) {
        return (int)proc.getPixelValue(0, 0);
    }

    private int iIndex(ImageProcessor proc) {
        return (int)proc.getPixelValue(10, 0);
    }

    private int zIndex(ImageProcessor proc) {
        return (int)proc.getPixelValue(20, 0);
    }

    private int cIndex(ImageProcessor proc) {
        return (int)proc.getPixelValue(30, 0);
    }

    private int tIndex(ImageProcessor proc) {
        return (int)proc.getPixelValue(40, 0);
    }

    private int sIndex(ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor) {
        return this.getPixelValue(0, 0, imp, z, c, t, indexed, falseColor);
    }

    private int iIndex(ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor) {
        return this.getPixelValue(10, 0, imp, z, c, t, indexed, falseColor);
    }

    private int zIndex(ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor) {
        return this.getPixelValue(20, 0, imp, z, c, t, indexed, falseColor);
    }

    private int cIndex(ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor) {
        return this.getPixelValue(30, 0, imp, z, c, t, indexed, falseColor);
    }

    private int tIndex(ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor) {
        return this.getPixelValue(40, 0, imp, z, c, t, indexed, falseColor);
    }

    private char axisChar(String order, int d) {
        if (d < 0 || d > 2) {
            throw new IllegalArgumentException("index out of bounds [0..2]: " + d);
        }
        return order.charAt(d);
    }

    private Axis axis(String order, int d) {
        char dimChar = this.axisChar(order, d);
        if (dimChar == 'Z') {
            return Axis.Z;
        }
        if (dimChar == 'C') {
            return Axis.C;
        }
        if (dimChar == 'T') {
            return Axis.T;
        }
        throw new IllegalArgumentException("unknown dimension : (" + dimChar + ")");
    }

    private int value(Axis axis, int z, int c, int t) {
        if (axis == Axis.Z) {
            return z;
        }
        if (axis == Axis.C) {
            return c;
        }
        if (axis == Axis.T) {
            return t;
        }
        throw new IllegalArgumentException("unknown axis: " + (Object)((Object)axis));
    }

    private int index(Axis axis, ImageProcessor proc) {
        if (axis == Axis.Z) {
            return this.zIndex(proc);
        }
        if (axis == Axis.C) {
            return this.cIndex(proc);
        }
        if (axis == Axis.T) {
            return this.tIndex(proc);
        }
        throw new IllegalArgumentException("unknown axis: " + (Object)((Object)axis));
    }

    private String bfChanOrd(ChannelOrder order) {
        return "XY" + order.toString();
    }

    private int numInSeries(int from, int to, int by) {
        if (by < 1) {
            throw new IllegalArgumentException("stepBy < 1");
        }
        int count = 0;
        for (int i = from; i <= to; i += by) {
            ++count;
        }
        return count;
    }

    private int getSizeZ(ImagePlus imp) {
        return imp.getDimensions()[3];
    }

    private int getSizeT(ImagePlus imp) {
        return imp.getDimensions()[4];
    }

    private int getEffectiveSizeC(ImagePlus imp) {
        return imp.getDimensions()[2];
    }

    private void setCztPosition(ImagePlus imp, int z, int c, int t) {
        int sliceNumber = c + z * imp.getNChannels() + t * imp.getNSlices() * imp.getNChannels();
        imp.setSlice(sliceNumber + 1);
    }

    private void setZctPosition(ImagePlus imp, int z, int c, int t) {
        int sliceNumber = z + c * imp.getNSlices() + t * imp.getNSlices() * imp.getNChannels();
        imp.setSlice(sliceNumber + 1);
    }

    private LUT getColorTable(ImagePlus imp, int channel) {
        if (imp instanceof CompositeImage) {
            return ((CompositeImage)imp).getChannelLut(channel + 1);
        }
        IndexColorModel icm = (IndexColorModel)imp.getProcessor().getColorModel();
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        return new LUT(reds, greens, blues);
    }

    private int getPixelValue(int x, int y, ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor) {
        this.setCztPosition(imp, z, c, t);
        int rawValue = (int)imp.getProcessor().getPixelValue(x, y);
        if (!indexed || falseColor) {
            return rawValue;
        }
        LUT lut = this.getColorTable(imp, c);
        int value = lut.getRed(rawValue);
        return value;
    }

    private int effectiveC(int sizeC, int rgb, int lutLen, boolean indexed, boolean falseColor) {
        int effC = sizeC;
        if (indexed) {
            effC = falseColor ? (effC /= rgb) : (effC *= lutLen);
        }
        return effC;
    }

    private void impsCountTest(ImagePlus[] imps, int numExpected) {
        Assert.assertNotNull((Object)imps);
        Assert.assertEquals((int)numExpected, (int)imps.length);
    }

    private void stackTest(ImagePlus imp, int expectedSize) {
        Assert.assertNotNull((Object)imp);
        Assert.assertEquals((int)expectedSize, (int)imp.getStack().getSize());
    }

    private void xyzctTest(ImagePlus imp, int x, int y, int z, int c, int t) {
        Assert.assertNotNull((Object)imp);
        Assert.assertEquals((int)x, (int)imp.getWidth());
        Assert.assertEquals((int)y, (int)imp.getHeight());
        Assert.assertEquals((int)z, (int)this.getSizeZ(imp));
        Assert.assertEquals((int)c, (int)this.getEffectiveSizeC(imp));
        Assert.assertEquals((int)t, (int)this.getSizeT(imp));
    }

    private void lutTest(CompositeImage ci, int channel, int minR, int minG, int minB, int maxR, int maxG, int maxB) {
        LUT lut = ci.getChannelLut(channel + 1);
        byte[] reds = new byte[256];
        byte[] blues = new byte[256];
        byte[] greens = new byte[256];
        lut.getReds(reds);
        lut.getGreens(greens);
        lut.getBlues(blues);
        Assert.assertEquals((byte)((byte)minR), (byte)reds[0]);
        Assert.assertEquals((byte)((byte)maxR), (byte)reds[255]);
        Assert.assertEquals((byte)((byte)minG), (byte)greens[0]);
        Assert.assertEquals((byte)((byte)maxG), (byte)greens[255]);
        Assert.assertEquals((byte)((byte)minB), (byte)blues[0]);
        Assert.assertEquals((byte)((byte)maxB), (byte)blues[255]);
    }

    private void colorTests(CompositeImage ci, int numChannels, Color[] expectedColors) {
        for (int i = 0; i < numChannels; ++i) {
            Color color = expectedColors[i];
            this.lutTest(ci, i, 0, 0, 0, color.getRed(), color.getGreen(), color.getBlue());
        }
    }

    private void verifyCropInput(int sizeX, int sizeY, int originCropX, int originCropY, int sizeCrop) {
        Assert.assertTrue((sizeX > 50 || sizeY > 10 ? 1 : 0) != 0);
        Assert.assertTrue((sizeX < 256 ? 1 : 0) != 0);
        Assert.assertTrue((sizeY < 256 ? 1 : 0) != 0);
        Assert.assertTrue((sizeCrop > 0 ? 1 : 0) != 0);
        Assert.assertTrue((originCropX >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((originCropY >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((originCropX > 50 || originCropY > 10 ? 1 : 0) != 0);
        Assert.assertTrue((originCropX + sizeCrop <= sizeX ? 1 : 0) != 0);
        Assert.assertTrue((originCropY + sizeCrop <= sizeY ? 1 : 0) != 0);
    }

    private boolean indexValuesTest(ImagePlus imp, int z, int c, int t, boolean indexed, boolean falseColor, int expS, int expZ, int expC, int expT) {
        int tempS = this.sIndex(imp, z, c, t, indexed, falseColor);
        int tempZ = this.zIndex(imp, z, c, t, indexed, falseColor);
        int tempC = this.cIndex(imp, z, c, t, indexed, falseColor);
        int tempT = this.tIndex(imp, z, c, t, indexed, falseColor);
        if (expS != tempS || expZ != tempZ || expC != tempC || expT != tempT) {
            return false;
        }
        Assert.assertEquals((int)expS, (int)tempS);
        Assert.assertEquals((int)expZ, (int)tempZ);
        Assert.assertEquals((int)expC, (int)tempC);
        Assert.assertEquals((int)expT, (int)tempT);
        return true;
    }

    private void stackInZctOrderTest(ImagePlus imp, int maxZ, int maxC, int maxT, boolean indexed, boolean falseColor) {
        LOGGER.debug("stackInZctOrderTest()");
        boolean success = true;
        this.stackTest(imp, maxZ * maxC * maxT);
        int iIndex = 0;
        for (int t = 0; t < maxT; ++t) {
            for (int c = 0; c < maxC; ++c) {
                for (int z = 0; z < maxZ; ++z) {
                    int expectedS = 0;
                    int expectedZ = z;
                    int expectedC = c;
                    int expectedT = t;
                    ++iIndex;
                    success &= this.indexValuesTest(imp, z, c, t, indexed, falseColor, expectedS, expectedZ, expectedC, expectedT);
                }
            }
        }
        Assert.assertTrue((boolean)success);
    }

    private void stackInCztOrderTest(ImagePlus imp, int maxZ, int maxC, int maxT, boolean indexed, boolean falseColor) {
        LOGGER.debug("stackInCztOrderTest()");
        boolean success = true;
        this.stackTest(imp, maxZ * maxC * maxT);
        int iIndex = 0;
        for (int t = 0; t < maxT; ++t) {
            for (int z = 0; z < maxZ; ++z) {
                for (int c = 0; c < maxC; ++c) {
                    int expectedS = 0;
                    int expectedZ = z;
                    int expectedC = c;
                    int expectedT = t;
                    ++iIndex;
                    success &= this.indexValuesTest(imp, z, c, t, indexed, falseColor, expectedS, expectedZ, expectedC, expectedT);
                }
            }
        }
        Assert.assertTrue((boolean)success);
    }

    private void multipleSeriesInCztOrderTest(ImagePlus imp, int numSeries, int maxZ, int maxC, int maxT) {
        this.stackTest(imp, numSeries * maxZ * maxC * maxT);
        ImageStack st = imp.getStack();
        int slice = 0;
        for (int sIndex = 0; sIndex < numSeries; ++sIndex) {
            for (int tIndex = 0; tIndex < maxT; ++tIndex) {
                for (int zIndex = 0; zIndex < maxZ; ++zIndex) {
                    for (int cIndex = 0; cIndex < maxC; ++cIndex) {
                        ImageProcessor proc = st.getProcessor(++slice);
                        Assert.assertEquals((int)sIndex, (int)this.sIndex(proc));
                        Assert.assertEquals((int)zIndex, (int)this.zIndex(proc));
                        Assert.assertEquals((int)cIndex, (int)this.cIndex(proc));
                        Assert.assertEquals((int)tIndex, (int)this.tIndex(proc));
                    }
                }
            }
        }
    }

    private void stackInSpecificOrderTest(ImagePlus imp, String chOrder) {
        ImageStack st = imp.getStack();
        int x = imp.getWidth();
        int y = imp.getHeight();
        int z = imp.getNSlices();
        int c = imp.getNChannels();
        int t = imp.getNFrames();
        Axis fastest = this.axis(chOrder, 0);
        Axis middle = this.axis(chOrder, 1);
        Axis slowest = this.axis(chOrder, 2);
        int maxI = this.value(slowest, z, c, t);
        int maxJ = this.value(middle, z, c, t);
        int maxK = this.value(fastest, z, c, t);
        int slice = 0;
        for (int i = 0; i < maxI; ++i) {
            for (int j = 0; j < maxJ; ++j) {
                for (int k = 0; k < maxK; ++k) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    Assert.assertNotNull((Object)proc);
                    Assert.assertEquals((int)x, (int)proc.getWidth());
                    Assert.assertEquals((int)y, (int)proc.getHeight());
                    Assert.assertEquals((int)0, (int)this.sIndex(proc));
                    Assert.assertEquals((int)i, (int)this.index(slowest, proc));
                    Assert.assertEquals((int)j, (int)this.index(middle, proc));
                    Assert.assertEquals((int)k, (int)this.index(fastest, proc));
                }
            }
        }
    }

    private void pixelsTest(ImagePlus imp, int pixType, boolean indexed, boolean falseColor) {
        Assert.assertTrue((pixType == 1 ? 1 : 0) != 0);
        Assert.assertTrue((imp.getHeight() > 10 ? 1 : 0) != 0);
        int max = imp.getWidth();
        if (max > 255) {
            max = 255;
        }
        for (int t = 0; t < imp.getNFrames(); ++t) {
            for (int c = 0; c < imp.getNChannels(); ++c) {
                for (int z = 0; z < imp.getNSlices(); ++z) {
                    for (int i = 0; i < max; ++i) {
                        Assert.assertEquals((int)i, (int)this.getPixelValue(i, 10, imp, z, c, t, indexed, falseColor));
                    }
                }
            }
        }
    }

    private void croppedPixelsTest(ImagePlus imp, int ox, int cropSize) {
        ImageProcessor proc = imp.getProcessor();
        for (int ix = 0; ix < cropSize; ++ix) {
            for (int iy = 0; iy < cropSize; ++iy) {
                Assert.assertEquals((float)(ox + ix), (float)proc.getPixelValue(ix, iy), (float)0.0f);
            }
        }
    }

    private void groupedFilesTest(ImagePlus imp, int expNumZ, int expNumC, int expNumT) {
        this.stackTest(imp, expNumZ * expNumC * expNumT);
        ImageStack st = imp.getStack();
        int slice = 0;
        for (int t = 0; t < expNumT; ++t) {
            for (int z = 0; z < expNumZ; ++z) {
                for (int c = 0; c < expNumC; ++c) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    Assert.assertEquals((int)0, (int)this.sIndex(proc));
                    Assert.assertEquals((int)z, (int)this.iIndex(proc));
                    Assert.assertEquals((int)z, (int)this.zIndex(proc));
                    Assert.assertEquals((int)0, (int)this.cIndex(proc));
                    Assert.assertEquals((int)0, (int)this.tIndex(proc));
                }
            }
        }
    }

    private void swappedZtTest(ImagePlus imp, int pixType, boolean virtual, int originalZ, int originalC, int originalT) {
        LOGGER.debug("swappedZtTest() : virtual {} pixType {}", (Object)virtual, (Object)FormatTools.getPixelTypeString((int)pixType));
        this.stackTest(imp, originalZ * originalC * originalT);
        ImageStack st = imp.getStack();
        int actualSizeZ = imp.getNSlices();
        int actualSizeC = imp.getNChannels();
        int actualSizeT = imp.getNFrames();
        Assert.assertEquals((int)originalT, (int)actualSizeZ);
        Assert.assertEquals((int)originalC, (int)actualSizeC);
        Assert.assertEquals((int)originalZ, (int)actualSizeT);
        int slice = 0;
        for (int tIndex = 0; tIndex < actualSizeT; ++tIndex) {
            for (int zIndex = 0; zIndex < actualSizeZ; ++zIndex) {
                for (int cIndex = 0; cIndex < actualSizeC; ++cIndex) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    int actualZ = this.tIndex(proc);
                    int actualC = this.cIndex(proc);
                    int actualT = this.zIndex(proc);
                    Assert.assertEquals((int)zIndex, (int)actualZ);
                    Assert.assertEquals((int)cIndex, (int)actualC);
                    Assert.assertEquals((int)tIndex, (int)actualT);
                }
            }
        }
    }

    private void seriesInZctOrderTest(ImagePlus imp, boolean indexed, boolean falseColor, int zFrom, int zTo, int zBy, int cFrom, int cTo, int cBy, int tFrom, int tTo, int tBy) {
        int zs = this.numInSeries(zFrom, zTo, zBy);
        int cs = this.numInSeries(cFrom, cTo, cBy);
        int ts = this.numInSeries(tFrom, tTo, tBy);
        this.stackTest(imp, zs * cs * ts);
        for (int t = 0; t < ts; ++t) {
            for (int c = 0; c < cs; ++c) {
                for (int z = 0; z < zs; ++z) {
                    int zIndex = this.zIndex(imp, z, c, t, indexed, falseColor);
                    int cIndex = this.cIndex(imp, z, c, t, indexed, falseColor);
                    int tIndex = this.tIndex(imp, z, c, t, indexed, falseColor);
                    int zVal = zFrom + z * zBy;
                    int cVal = cFrom + c * cBy;
                    int tVal = tFrom + t * tBy;
                    Assert.assertEquals((int)zVal, (int)zIndex);
                    Assert.assertEquals((int)cVal, (int)cIndex);
                    Assert.assertEquals((int)tVal, (int)tIndex);
                }
            }
        }
    }

    private void imagesZInCtOrderTest(ImagePlus[] imps, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        for (int z = 0; z < sizeZ; ++z) {
            ImagePlus imp = imps[z];
            this.xyzctTest(imp, sizeX, sizeY, 1, sizeC, sizeT);
            this.stackTest(imp, sizeC * sizeT);
            ImageStack st = imp.getStack();
            int slice = 0;
            for (int t = 0; t < sizeT; ++t) {
                for (int c = 0; c < sizeC; ++c) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    Assert.assertEquals((int)z, (int)this.zIndex(proc));
                    Assert.assertEquals((int)c, (int)this.cIndex(proc));
                    Assert.assertEquals((int)t, (int)this.tIndex(proc));
                }
            }
        }
    }

    private void imagesCInZtOrderTest(ImagePlus[] imps, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        for (int c = 0; c < sizeC; ++c) {
            ImagePlus imp = imps[c];
            this.xyzctTest(imp, sizeX, sizeY, sizeZ, 1, sizeT);
            this.stackTest(imp, sizeZ * sizeT);
            ImageStack st = imp.getStack();
            int slice = 0;
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    Assert.assertEquals((int)z, (int)this.zIndex(proc));
                    Assert.assertEquals((int)c, (int)this.cIndex(proc));
                    Assert.assertEquals((int)t, (int)this.tIndex(proc));
                }
            }
        }
    }

    private void imagesTInCzOrderTest(ImagePlus[] imps, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        for (int t = 0; t < sizeT; ++t) {
            ImagePlus imp = imps[t];
            this.xyzctTest(imp, sizeX, sizeY, sizeZ, sizeC, 1);
            this.stackTest(imp, sizeZ * sizeC);
            ImageStack st = imp.getStack();
            int slice = 0;
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    Assert.assertEquals((int)z, (int)this.zIndex(proc));
                    Assert.assertEquals((int)c, (int)this.cIndex(proc));
                    Assert.assertEquals((int)t, (int)this.tIndex(proc));
                }
            }
        }
    }

    private void imageSeriesZInCtOrderTest(ImagePlus[] imps, int numSeries, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        for (int z = 0; z < sizeZ; ++z) {
            ImagePlus imp = imps[z];
            this.xyzctTest(imp, sizeX, sizeY, 1, sizeC, sizeT * numSeries);
            this.stackTest(imp, numSeries * sizeC * sizeT);
            ImageStack st = imp.getStack();
            for (int s = 0; s < numSeries; ++s) {
                int slice = s * sizeC * sizeT;
                for (int t = 0; t < sizeT; ++t) {
                    for (int c = 0; c < sizeC; ++c) {
                        ImageProcessor proc = st.getProcessor(++slice);
                        Assert.assertEquals((int)z, (int)this.zIndex(proc));
                        Assert.assertEquals((int)c, (int)this.cIndex(proc));
                        Assert.assertEquals((int)t, (int)this.tIndex(proc));
                        Assert.assertEquals((int)s, (int)this.sIndex(proc));
                    }
                }
            }
        }
    }

    private void imageSeriesCInZtOrderTest(ImagePlus[] imps, int numSeries, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        for (int c = 0; c < sizeC; ++c) {
            ImagePlus imp = imps[c];
            this.xyzctTest(imp, sizeX, sizeY, sizeZ, 1, sizeT * numSeries);
            this.stackTest(imp, numSeries * sizeZ * sizeT);
            ImageStack st = imp.getStack();
            for (int s = 0; s < numSeries; ++s) {
                int slice = s * sizeZ * sizeT;
                for (int t = 0; t < sizeT; ++t) {
                    for (int z = 0; z < sizeZ; ++z) {
                        ImageProcessor proc = st.getProcessor(++slice);
                        Assert.assertEquals((int)z, (int)this.zIndex(proc));
                        Assert.assertEquals((int)c, (int)this.cIndex(proc));
                        Assert.assertEquals((int)t, (int)this.tIndex(proc));
                        Assert.assertEquals((int)s, (int)this.sIndex(proc));
                    }
                }
            }
        }
    }

    private void imageSeriesTInCzOrderTest(ImagePlus[] imps, int numSeries, int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT) {
        int imageNum = 0;
        for (int s = 0; s < numSeries; ++s) {
            for (int t = 0; t < sizeT; ++t) {
                ImagePlus imp = imps[imageNum++];
                this.xyzctTest(imp, sizeX, sizeY, sizeZ, sizeC, 1);
                this.stackTest(imp, sizeZ * sizeC);
                ImageStack st = imp.getStack();
                int slice = 0;
                for (int z = 0; z < sizeZ; ++z) {
                    for (int c = 0; c < sizeC; ++c) {
                        ImageProcessor proc = st.getProcessor(++slice);
                        Assert.assertEquals((int)z, (int)this.zIndex(proc));
                        Assert.assertEquals((int)c, (int)this.cIndex(proc));
                        Assert.assertEquals((int)t, (int)this.tIndex(proc));
                        Assert.assertEquals((int)s, (int)this.sIndex(proc));
                    }
                }
            }
        }
    }

    private void stackCtzSwappedAndCroppedTest(ImagePlus[] imps, int cropSizeX, int cropSizeY, int origSizeZ, int origSizeC, int origSizeT, int start, int stepBy) {
        int newMaxT = origSizeC;
        int numC = this.numInSeries(start, origSizeC - 1, stepBy);
        int newZ = origSizeT;
        int newC = origSizeZ;
        int newT = numC;
        for (int zIndex = 0; zIndex < newZ; ++zIndex) {
            ImagePlus imp = imps[zIndex];
            this.xyzctTest(imp, cropSizeX, cropSizeY, 1, newC, newT);
            this.stackTest(imp, newC * newT);
            ImageStack st = imp.getStack();
            int slice = 0;
            for (int tIndex = start; tIndex < newMaxT; tIndex += stepBy) {
                for (int cIndex = 0; cIndex < newC; ++cIndex) {
                    ImageProcessor proc = st.getProcessor(++slice);
                    Assert.assertEquals((int)cropSizeX, (int)proc.getWidth());
                    Assert.assertEquals((int)cropSizeY, (int)proc.getHeight());
                    int actualZ = this.tIndex(proc);
                    int actualC = this.zIndex(proc);
                    int actualT = this.cIndex(proc);
                    Assert.assertEquals((int)zIndex, (int)actualZ);
                    Assert.assertEquals((int)cIndex, (int)actualC);
                    Assert.assertEquals((int)tIndex, (int)actualT);
                }
            }
        }
    }

    private void defaultBehaviorTester(int pixType, int x, int y, int z, int c, int t) {
        String path = ImporterTest.constructFakeFilename("default", pixType, x, y, z, c, t, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            imps = BF.openImagePlus((String)path);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        ImagePlus imp = imps[0];
        this.xyzctTest(imp, x, y, z, c, t);
    }

    private void outputStackOrderTester(boolean virtual, int pixType, ChannelOrder order, int x, int y, int z, int c, int t) {
        String bfChOrder = this.bfChanOrd(order);
        String chOrder = order.toString();
        String path = ImporterTest.constructFakeFilename("stack", pixType, x, y, z, c, t, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setId(path);
            options.setStackOrder(bfChOrder);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, x, y, z, c, t);
        this.stackTest((ImagePlus)imp, z * c * t);
        this.stackInSpecificOrderTest((ImagePlus)imp, chOrder);
    }

    private void datasetGroupFilesTester(boolean virtual) {
        String path = FAKE_FILES[0];
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setGroupFiles(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
            Assert.assertEquals((String)FAKE_PATTERN, (String)options.getId());
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        this.xyzctTest((ImagePlus)imps[0], 50, 50, 7, 3, 5);
        this.groupedFilesTest(imps[0], 7, 3, 5);
    }

    private void datasetOpenFilesIndividuallyTester(boolean virtual) {
        ImporterOptions options;
        String path = "2channel_stack_raw01.pic";
        ImagePlus[] imps = null;
        try {
            options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setUngroupFiles(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        this.stackTest((ImagePlus)imps[0], 16);
        try {
            options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setUngroupFiles(false);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        this.stackTest(imps[0], 32);
    }

    private void datasetSwapDimsTester(boolean virtual, int pixType, int x, int y, int z, int t) {
        LOGGER.debug("datsetSwapDimsTester() virtual = {} pixType = {}", (Object)virtual, (Object)FormatTools.getPixelTypeString((int)pixType));
        int c = 3;
        ChannelOrder swappedOrder = ChannelOrder.TCZ;
        String path = ImporterTest.constructFakeFilename("swapDims", pixType, x, y, z, c, t, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setId(path);
            options.setSwapDimensions(true);
            options.setInputOrder(0, this.bfChanOrd(swappedOrder));
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, x, y, t, c, z);
        this.swappedZtTest((ImagePlus)imp, pixType, virtual, z, c, t);
    }

    private ImagePlus[] openSeriesTest(String fakeFileName, boolean virtual, boolean openAllValue) {
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setId(fakeFileName);
            options.setOpenAllSeries(openAllValue);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        return imps;
    }

    private void datasetOpenAllSeriesTester(boolean virtual, boolean openAll) {
        int x = 55;
        int y = 20;
        int z = 2;
        int c = 3;
        int t = 4;
        int numSeries = 5;
        String path = ImporterTest.constructFakeFilename("openAllSeries", 5, x, y, z, c, t, numSeries, false, -1, false, -1);
        int expectedNumImps = 1;
        if (openAll) {
            expectedNumImps = numSeries;
        }
        ImagePlus[] imps = this.openSeriesTest(path, virtual, openAll);
        this.impsCountTest(imps, expectedNumImps);
        for (int i = 0; i < expectedNumImps; ++i) {
            this.xyzctTest(imps[i], x, y, z, c, t);
        }
    }

    private void datasetConcatenateTester(int pixType, int x, int y, int z, int c, int t, int s) {
        Assert.assertTrue((s >= 1 ? 1 : 0) != 0);
        String path = ImporterTest.constructFakeFilename("concat", pixType, x, y, z, c, t, s, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setId(path);
            options.setOpenAllSeries(true);
            options.setConcatenate(true);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, x, y, z, c, t * s);
        this.multipleSeriesInCztOrderTest((ImagePlus)imp, s, z, c, t);
    }

    private void ascendingValuesTest(byte[] data, int expectedLength) {
        Assert.assertEquals((int)expectedLength, (int)data.length);
        for (int i = 0; i < expectedLength; ++i) {
            Assert.assertEquals((int)i, (int)(data[i] & 0xFF));
        }
    }

    private void imagePlusLutTest(ImagePlus imp, boolean indexed, boolean falseColor, Color color) {
        Assert.assertFalse((boolean)(imp instanceof CompositeImage));
        if (indexed) {
            Assert.fail((String)"not yet supporting indexed");
        }
        LUT lut = this.getColorTable(imp, 0);
        byte[] data = new byte[256];
        if (color.getRed() > 0) {
            lut.getReds(data);
            this.ascendingValuesTest(data, 256);
        }
        if (color.getGreen() > 0) {
            lut.getGreens(data);
            this.ascendingValuesTest(data, 256);
        }
        if (color.getBlue() > 0) {
            lut.getBlues(data);
            this.ascendingValuesTest(data, 256);
        }
    }

    private void colorDefaultTester(boolean virtual, int pixType, boolean indexed, int channels, int chanPerPlane, boolean falseColor, int numSeries, boolean wantLutDefined) {
        int sizeX = 55;
        int sizeY = 71;
        int sizeZ = 3;
        int sizeT = 4;
        String path = ImporterTest.constructFakeFilename("colorDefault", pixType, sizeX, sizeY, sizeZ, channels, sizeT, numSeries, indexed, chanPerPlane, falseColor, -1);
        LOGGER.debug("colorDefaultTester: {}", (Object)path);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setColorMode("Default");
            if (indexed && wantLutDefined) {
                for (int s = 0; s < numSeries; ++s) {
                    options.setCustomColor(s, 0, Color.PINK);
                }
            }
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        int lutLen = 3;
        int expectedSizeC = this.effectiveC(channels, chanPerPlane, lutLen, indexed, falseColor);
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, expectedSizeC, sizeT);
        if (expectedSizeC >= 2 && expectedSizeC <= 7) {
            Color[] colorOrder;
            int expectedType;
            Assert.assertTrue((boolean)imp.isComposite());
            CompositeImage ci = (CompositeImage)imp;
            Assert.assertEquals((chanPerPlane > 1 ? 1 : 0) != 0, (boolean)ci.hasCustomLuts());
            if (chanPerPlane > 1) {
                expectedType = 1;
                colorOrder = DEFAULT_COLOR_ORDER;
            } else if (indexed && wantLutDefined) {
                expectedType = 2;
                colorOrder = new Color[]{Color.PINK, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
            } else {
                expectedType = 3;
                colorOrder = DEFAULT_COLOR_ORDER;
            }
            Assert.assertEquals((int)expectedType, (int)ci.getMode());
            this.colorTests(ci, expectedSizeC, colorOrder);
        } else {
            Assert.assertFalse((boolean)imp.isComposite());
            this.imagePlusLutTest((ImagePlus)imp, indexed, falseColor, DEFAULT_COLOR_ORDER[0]);
        }
        this.stackInCztOrderTest((ImagePlus)imp, sizeZ, expectedSizeC, sizeT, indexed, falseColor);
    }

    private void colorCompositeTester(boolean virtual, int pixType, boolean indexed, int channels, int chanPerPlane, boolean falseColor, int numSeries) {
        int sizeX = 55;
        int sizeY = 71;
        int sizeZ = 3;
        int sizeT = 4;
        String path = ImporterTest.constructFakeFilename("colorComposite", pixType, sizeX, sizeY, sizeZ, channels, sizeT, numSeries, indexed, chanPerPlane, falseColor, -1);
        LOGGER.debug("colorCompositeTester: {}", (Object)path);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setColorMode("Composite");
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        int lutLen = 3;
        int expectedSizeC = this.effectiveC(channels, chanPerPlane, lutLen, indexed, falseColor);
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, expectedSizeC, sizeT);
        if (expectedSizeC >= 2 && expectedSizeC <= 7) {
            Assert.assertTrue((boolean)imp.isComposite());
            CompositeImage ci = (CompositeImage)imp;
            Assert.assertTrue((boolean)ci.hasCustomLuts());
            Assert.assertEquals((int)1, (int)ci.getMode());
            this.colorTests(ci, expectedSizeC, DEFAULT_COLOR_ORDER);
        } else {
            Assert.assertFalse((boolean)imp.isComposite());
            this.imagePlusLutTest((ImagePlus)imp, indexed, falseColor, DEFAULT_COLOR_ORDER[0]);
        }
        this.stackInCztOrderTest((ImagePlus)imp, sizeZ, expectedSizeC, sizeT, indexed, falseColor);
    }

    private void colorColorizedTester(boolean virtual, int pixType, boolean indexed, int channels, int chanPerPlane, boolean falseColor, int numSeries) {
        int sizeX = 55;
        int sizeY = 71;
        int sizeZ = 3;
        int sizeT = 4;
        String path = ImporterTest.constructFakeFilename("colorColorized", pixType, sizeX, sizeY, sizeZ, channels, sizeT, numSeries, indexed, chanPerPlane, falseColor, -1);
        LOGGER.debug("colorColorizedTester: {}", (Object)path);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setColorMode("Colorized");
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        int lutLen = 3;
        int expectedSizeC = this.effectiveC(channels, chanPerPlane, lutLen, indexed, falseColor);
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, expectedSizeC, sizeT);
        if (expectedSizeC >= 2 && expectedSizeC <= 7) {
            Assert.assertTrue((boolean)imp.isComposite());
            CompositeImage ci = (CompositeImage)imp;
            Assert.assertTrue((boolean)ci.hasCustomLuts());
            Assert.assertEquals((int)2, (int)ci.getMode());
            this.colorTests(ci, expectedSizeC, DEFAULT_COLOR_ORDER);
        } else {
            Assert.assertFalse((boolean)imp.isComposite());
            this.imagePlusLutTest((ImagePlus)imp, indexed, falseColor, DEFAULT_COLOR_ORDER[0]);
        }
        this.stackInCztOrderTest((ImagePlus)imp, sizeZ, expectedSizeC, sizeT, indexed, falseColor);
    }

    private void colorGrayscaleTester(boolean virtual, int pixType, boolean indexed, int channels, int chanPerPlane, boolean falseColor, int numSeries) {
        int sizeX = 55;
        int sizeY = 71;
        int sizeZ = 3;
        int sizeT = 4;
        String path = ImporterTest.constructFakeFilename("colorGrayscale", pixType, sizeX, sizeY, sizeZ, channels, sizeT, numSeries, indexed, chanPerPlane, falseColor, -1);
        LOGGER.debug("colorGrayscaleTester: {}", (Object)path);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setColorMode("Grayscale");
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        int lutLen = 3;
        int expectedSizeC = this.effectiveC(channels, chanPerPlane, lutLen, indexed, falseColor);
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, expectedSizeC, sizeT);
        if (expectedSizeC >= 2 && expectedSizeC <= 7) {
            Assert.assertTrue((boolean)imp.isComposite());
            CompositeImage ci = (CompositeImage)imp;
            Assert.assertFalse((boolean)ci.hasCustomLuts());
            Assert.assertEquals((int)3, (int)ci.getMode());
            this.colorTests(ci, expectedSizeC, DEFAULT_COLOR_ORDER);
        } else {
            Assert.assertFalse((boolean)imp.isComposite());
            this.imagePlusLutTest((ImagePlus)imp, indexed, falseColor, DEFAULT_COLOR_ORDER[0]);
        }
        this.stackInCztOrderTest((ImagePlus)imp, sizeZ, expectedSizeC, sizeT, indexed, falseColor);
    }

    private void colorCustomTester(boolean virtual, int pixType, boolean indexed, int channels, int chanPerPlane, boolean falseColor, int numSeries) {
        int sizeX = 55;
        int sizeY = 71;
        int sizeZ = 3;
        int sizeT = 4;
        String path = ImporterTest.constructFakeFilename("colorCustom", pixType, sizeX, sizeY, sizeZ, channels, sizeT, numSeries, indexed, chanPerPlane, falseColor, -1);
        LOGGER.debug("colorCustomTester: {}", (Object)path);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setVirtual(virtual);
            options.setColorMode("Custom");
            int maxChannels = channels <= 7 ? channels : 7;
            for (int s = 0; s < numSeries; ++s) {
                for (int c = 0; c < maxChannels; ++c) {
                    options.setCustomColor(s, c, CUSTOM_COLOR_ORDER[c]);
                }
            }
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        int lutLen = 3;
        int expectedSizeC = this.effectiveC(channels, chanPerPlane, lutLen, indexed, falseColor);
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, expectedSizeC, sizeT);
        if (expectedSizeC >= 2 && expectedSizeC <= 7) {
            Assert.assertTrue((boolean)imp.isComposite());
            CompositeImage ci = (CompositeImage)imp;
            Assert.assertTrue((boolean)ci.hasCustomLuts());
            Assert.assertEquals((int)2, (int)ci.getMode());
            this.colorTests(ci, expectedSizeC, CUSTOM_COLOR_ORDER);
        } else {
            Assert.assertFalse((boolean)imp.isComposite());
            this.imagePlusLutTest((ImagePlus)imp, indexed, falseColor, CUSTOM_COLOR_ORDER[0]);
        }
        this.stackInCztOrderTest((ImagePlus)imp, sizeZ, expectedSizeC, sizeT, indexed, falseColor);
    }

    private void memoryVirtualStackTester(boolean desireVirtual) {
        int x = 604;
        int y = 531;
        int z = 7;
        int c = 1;
        int t = 1;
        String path = ImporterTest.constructFakeFilename("vstack", 3, x, y, z, c, t, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setId(path);
            options.setVirtual(desireVirtual);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, x, y, z, c, t);
        Assert.assertEquals((boolean)desireVirtual, (boolean)imp.getStack().isVirtual());
    }

    private void memorySpecifyRangeTester(int z, int c, int t, int zFrom, int zTo, int zBy, int cFrom, int cTo, int cBy, int tFrom, int tTo, int tBy) {
        int pixType = 1;
        int x = 50;
        int y = 5;
        String path = ImporterTest.constructFakeFilename("range", pixType, x, y, z, c, t, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setId(path);
            if (zFrom != 0) {
                options.setZBegin(0, zFrom);
            }
            if (zTo != z - 1) {
                options.setZEnd(0, zTo);
            }
            if (zBy != 1) {
                options.setZStep(0, zBy);
            }
            if (cFrom != 0) {
                options.setCBegin(0, cFrom);
            }
            if (cTo != c - 1) {
                options.setCEnd(0, cTo);
            }
            if (cBy != 1) {
                options.setCStep(0, cBy);
            }
            if (tFrom != 0) {
                options.setTBegin(0, tFrom);
            }
            if (tTo != t - 1) {
                options.setTEnd(0, tTo);
            }
            if (tBy != 1) {
                options.setTStep(0, tBy);
            }
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, x, y, this.numInSeries(zFrom, zTo, zBy), this.numInSeries(cFrom, cTo, cBy), this.numInSeries(tFrom, tTo, tBy));
        this.seriesInZctOrderTest((ImagePlus)imp, false, false, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
    }

    private void memoryCropTester(int x, int y, int ox, int oy, int cropSize) {
        this.verifyCropInput(x, y, ox, oy, cropSize);
        String path = ImporterTest.constructFakeFilename("crop", 1, x, y, 1, 1, 1, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setId(path);
            options.setCrop(true);
            options.setCropRegion(0, new Region(ox, oy, cropSize, cropSize));
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, cropSize, cropSize, 1, 1, 1);
        this.croppedPixelsTest((ImagePlus)imp, ox, cropSize);
    }

    private void splitChannelsTester() {
        int sizeX = 50;
        int sizeY = 20;
        int sizeZ = 5;
        int sizeC = 3;
        int sizeT = 7;
        String path = ImporterTest.constructFakeFilename("splitC", 1, 50, 20, 5, 3, 7, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setSplitChannels(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 3);
        this.imagesCInZtOrderTest(imps, 50, 20, 5, 3, 7);
    }

    private void splitFocalPlanesTester() {
        int sizeX = 50;
        int sizeY = 20;
        int sizeZ = 5;
        int sizeC = 3;
        int sizeT = 7;
        String path = ImporterTest.constructFakeFilename("splitZ", 1, 50, 20, 5, 3, 7, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setSplitFocalPlanes(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 5);
        this.imagesZInCtOrderTest(imps, 50, 20, 5, 3, 7);
    }

    private void splitTimepointsTester() {
        int sizeX = 50;
        int sizeY = 20;
        int sizeZ = 5;
        int sizeC = 3;
        int sizeT = 7;
        String path = ImporterTest.constructFakeFilename("splitT", 1, 50, 20, 5, 3, 7, -1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setSplitTimepoints(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 7);
        this.imagesTInCzOrderTest(imps, 50, 20, 5, 3, 7);
    }

    private void comboConcatSplitFocalPlanesTester() {
        int sizeX = 50;
        int sizeY = 20;
        int sizeZ = 3;
        int sizeC = 5;
        int sizeT = 7;
        int series = 4;
        String path = ImporterTest.constructFakeFilename("concatSplitZ", 1, 50, 20, 3, 5, 7, 4, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setOpenAllSeries(true);
            options.setConcatenate(true);
            options.setSplitFocalPlanes(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 3);
        this.imageSeriesZInCtOrderTest(imps, 4, 50, 20, 3, 5, 7);
    }

    private void comboConcatSplitChannelsTester() {
        int sizeX = 50;
        int sizeY = 20;
        int sizeZ = 3;
        int sizeC = 5;
        int sizeT = 7;
        int series = 4;
        String path = ImporterTest.constructFakeFilename("concatSplitC", 1, 50, 20, 3, 5, 7, 4, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setOpenAllSeries(true);
            options.setConcatenate(true);
            options.setSplitChannels(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 5);
        this.imageSeriesCInZtOrderTest(imps, 4, 50, 20, 3, 5, 7);
    }

    private void comboConcatSplitTimepointsTester() {
        int sizeX = 50;
        int sizeY = 20;
        int sizeZ = 3;
        int sizeC = 5;
        int sizeT = 7;
        int numSeries = 4;
        String path = ImporterTest.constructFakeFilename("concatSplitT", 1, 50, 20, 3, 5, 7, 4, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setOpenAllSeries(true);
            options.setConcatenate(true);
            options.setSplitTimepoints(true);
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 28);
        this.imageSeriesTInCzOrderTest(imps, 4, 50, 20, 3, 5, 7);
    }

    private void compositeSubcaseTester(int sizeC, boolean indexed) {
        int pixType = 1;
        int sizeX = 60;
        int sizeY = 30;
        int sizeZ = 2;
        int sizeT = 3;
        int numSeries = 1;
        int rgb = -1;
        int lutLen = -1;
        boolean falseColor = false;
        String path = ImporterTest.constructFakeFilename("colorComposite", pixType, sizeX, sizeY, sizeZ, sizeC, sizeT, numSeries, indexed, rgb, falseColor, lutLen);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setColorMode("Composite");
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, sizeC, sizeT);
        Assert.assertTrue((boolean)imp.isComposite());
        CompositeImage ci = (CompositeImage)imp;
        Assert.assertTrue((boolean)ci.hasCustomLuts());
        Assert.assertEquals((int)1, (int)ci.getMode());
        this.colorTests(ci, sizeC, DEFAULT_COLOR_ORDER);
        this.stackInZctOrderTest((ImagePlus)imp, sizeZ, sizeC, sizeT, indexed, falseColor);
        this.pixelsTest((ImagePlus)imp, pixType, indexed, falseColor);
    }

    @Test
    public void testDefaultBehavior() {
        this.defaultBehaviorTester(1, 57, 78, 5, 4, 3);
        this.defaultBehaviorTester(5, 323, 206, 3, 2, 1);
        this.defaultBehaviorTester(3, 400, 300, 1, 1, 1);
        this.defaultBehaviorTester(0, 232, 153, 3, 7, 5);
        this.defaultBehaviorTester(2, 107, 414, 1, 1, 1);
        this.defaultBehaviorTester(4, 158, 99, 2, 3, 4);
        this.defaultBehaviorTester(6, 73, 99, 3, 4, 5);
        this.defaultBehaviorTester(7, 106, 44, 5, 5, 4);
    }

    @Test
    public void testOutputStackOrder() {
        for (ChannelOrder order : ChannelOrder.values()) {
            for (boolean virtual : BOOLEAN_STATES) {
                this.outputStackOrderTester(virtual, 1, order, 82, 47, 2, 3, 4);
            }
        }
    }

    @Test
    public void testDatasetGroupFiles() {
        for (boolean virtual : BOOLEAN_STATES) {
            this.datasetGroupFilesTester(virtual);
        }
    }

    @Test
    public void testDatasetOpenFilesIndividually() {
    }

    @Test
    public void testDatasetSwapDims() {
        for (boolean virtual : BOOLEAN_STATES) {
            this.datasetSwapDimsTester(virtual, 1, 82, 47, 1, 3);
            this.datasetSwapDimsTester(virtual, 3, 82, 47, 3, 1);
            this.datasetSwapDimsTester(virtual, 3, 82, 47, 5, 2);
            this.datasetSwapDimsTester(virtual, 5, 82, 47, 5, 2);
            this.datasetSwapDimsTester(virtual, 6, 67, 109, 4, 3);
            this.datasetSwapDimsTester(virtual, 7, 67, 100, 3, 2);
            this.datasetSwapDimsTester(virtual, 0, 44, 108, 1, 4);
            this.datasetSwapDimsTester(virtual, 2, 44, 108, 2, 1);
            this.datasetSwapDimsTester(virtual, 4, 44, 108, 4, 3);
        }
    }

    @Test
    public void testDatasetOpenAllSeries() {
        for (boolean virtual : BOOLEAN_STATES) {
            for (boolean openAll : BOOLEAN_STATES) {
                this.datasetOpenAllSeriesTester(virtual, openAll);
                this.datasetOpenAllSeriesTester(virtual, openAll);
            }
        }
    }

    @Test
    public void testDatasetConcatenate() {
        this.datasetConcatenateTester(1, 82, 47, 1, 1, 1, 1);
        this.datasetConcatenateTester(1, 82, 47, 1, 1, 1, 17);
        this.datasetConcatenateTester(1, 82, 47, 4, 5, 2, 9);
    }

    @Test
    public void testColorDefault() {
        for (int pixType : MINIMAL_PIXEL_TYPES) {
            for (boolean virtual : BOOLEAN_STATES) {
                for (boolean defineLutEntry : BOOLEAN_STATES) {
                    this.colorDefaultTester(virtual, pixType, false, 1, 1, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 2, 2, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 7, 7, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 8, 8, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 4, 4, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 6, 3, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 12, 3, false, 1, defineLutEntry);
                    this.colorDefaultTester(virtual, pixType, false, 3, 1, false, 1, defineLutEntry);
                }
            }
        }
    }

    @Test
    public void testColorComposite() {
        for (boolean virtual : BOOLEAN_STATES) {
            this.colorCompositeTester(virtual, 1, false, 1, 1, false, 1);
            this.colorCompositeTester(virtual, 1, false, 2, 2, false, 1);
            this.colorCompositeTester(virtual, 1, false, 7, 7, false, 1);
            this.colorCompositeTester(virtual, 1, false, 8, 8, false, 1);
            this.colorCompositeTester(virtual, 1, false, 4, 4, false, 1);
            this.colorCompositeTester(virtual, 1, false, 6, 3, false, 1);
            this.colorCompositeTester(virtual, 1, false, 12, 3, false, 1);
            this.colorCompositeTester(virtual, 1, false, 3, 1, false, 1);
            int[] channels = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
            int[] series = new int[]{1, 2, 3, 4};
            int[] channelsPerPlaneVals = new int[]{1, 2, 3};
            for (int pixFormat : MINIMAL_PIXEL_TYPES) {
                for (int chanCount : channels) {
                    for (int numSeries : series) {
                        for (int channelsPerPlane : channelsPerPlaneVals) {
                            if (chanCount % channelsPerPlane != 0) continue;
                            this.colorCompositeTester(virtual, pixFormat, false, chanCount, channelsPerPlane, false, numSeries);
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testColorColorized() {
        for (int pixType : MINIMAL_PIXEL_TYPES) {
            for (boolean virtual : BOOLEAN_STATES) {
                this.colorColorizedTester(virtual, pixType, false, 1, 1, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 2, 2, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 7, 7, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 8, 8, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 4, 4, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 6, 3, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 12, 3, false, 1);
                this.colorColorizedTester(virtual, pixType, false, 3, 1, false, 1);
            }
        }
    }

    @Test
    public void testColorGrayscale() {
        for (int pixType : MINIMAL_PIXEL_TYPES) {
            for (boolean virtual : BOOLEAN_STATES) {
                this.colorGrayscaleTester(virtual, pixType, false, 1, 1, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 2, 2, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 7, 7, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 8, 8, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 4, 4, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 6, 3, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 12, 3, false, 1);
                this.colorGrayscaleTester(virtual, pixType, false, 3, 1, false, 1);
            }
        }
    }

    @Test
    public void testColorCustom() {
        for (int pixType : MINIMAL_PIXEL_TYPES) {
            for (boolean virtual : BOOLEAN_STATES) {
                this.colorCustomTester(virtual, pixType, false, 1, 1, false, 1);
                this.colorCustomTester(virtual, pixType, false, 2, 2, false, 1);
                this.colorCustomTester(virtual, pixType, false, 7, 7, false, 1);
                this.colorCustomTester(virtual, pixType, false, 8, 8, false, 1);
                this.colorCustomTester(virtual, pixType, false, 4, 4, false, 1);
                this.colorCustomTester(virtual, pixType, false, 6, 3, false, 1);
                this.colorCustomTester(virtual, pixType, false, 12, 3, false, 1);
                this.colorCustomTester(virtual, pixType, false, 3, 1, false, 1);
            }
        }
    }

    @Test
    public void testMemoryVirtualStack() {
        for (boolean virtual : BOOLEAN_STATES) {
            this.memoryVirtualStackTester(virtual);
        }
    }

    @Test
    public void testMemorySpecifyRange() {
        int z = 8;
        int c = 3;
        int t = 2;
        int zFrom = 2;
        int zTo = z - 1;
        int zBy = 1;
        int cFrom = 0;
        int cTo = c - 1;
        int cBy = 1;
        int tFrom = 0;
        int tTo = t - 1;
        int tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 8;
        c = 3;
        t = 2;
        zFrom = 0;
        zTo = 4;
        zBy = 1;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 8;
        c = 3;
        t = 2;
        zFrom = 0;
        zTo = z - 1;
        zBy = 3;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 8;
        c = 3;
        t = 2;
        zFrom = 2;
        zTo = 7;
        zBy = 3;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 6;
        c = 14;
        t = 4;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 3;
        cTo = c - 1;
        cBy = 1;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 6;
        c = 14;
        t = 4;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = 6;
        cBy = 1;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 6;
        c = 14;
        t = 4;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = c - 1;
        cBy = 4;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 6;
        c = 14;
        t = 4;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = 12;
        cBy = 4;
        tFrom = 0;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 3;
        c = 5;
        t = 13;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 4;
        tTo = t - 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 3;
        c = 5;
        t = 13;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 0;
        tTo = 8;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 3;
        c = 5;
        t = 13;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 0;
        tTo = t - 1;
        tBy = 2;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 3;
        c = 5;
        t = 13;
        zFrom = 0;
        zTo = z - 1;
        zBy = 1;
        cFrom = 0;
        cTo = c - 1;
        cBy = 1;
        tFrom = 4;
        tTo = 13;
        tBy = 2;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 2;
        c = 2;
        t = 2;
        zFrom = 0;
        zTo = 0;
        zBy = 2;
        cFrom = 1;
        cTo = 1;
        cBy = 1;
        tFrom = 0;
        tTo = 1;
        tBy = 1;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 5;
        c = 4;
        t = 6;
        zFrom = 1;
        zTo = 4;
        zBy = 2;
        cFrom = 1;
        cTo = 3;
        cBy = 1;
        tFrom = 2;
        tTo = 5;
        tBy = 2;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        z = 7;
        c = 7;
        t = 7;
        zFrom = 3;
        zTo = 6;
        zBy = 4;
        cFrom = 1;
        cTo = 6;
        cBy = 3;
        tFrom = 0;
        tTo = 2;
        tBy = 2;
        this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = -1;
            zTo = z - 1;
            zBy = 1;
            cFrom = 0;
            cTo = c - 1;
            cBy = 1;
            tFrom = 0;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z;
            zBy = 1;
            cFrom = 0;
            cTo = c - 1;
            cBy = 1;
            tFrom = 0;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 0;
            cFrom = 0;
            cTo = c - 1;
            cBy = 1;
            tFrom = 0;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 1;
            cFrom = -1;
            cTo = c - 1;
            cBy = 1;
            tFrom = 0;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 1;
            cFrom = 0;
            cTo = c;
            cBy = 1;
            tFrom = 0;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 1;
            cFrom = 0;
            cTo = c - 1;
            cBy = 0;
            tFrom = 0;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 1;
            cFrom = 0;
            cTo = c - 1;
            cBy = 1;
            tFrom = -1;
            tTo = t - 1;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 1;
            cFrom = 0;
            cTo = c - 1;
            cBy = 1;
            tFrom = 0;
            tTo = t;
            tBy = 1;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            z = 7;
            c = 7;
            t = 7;
            zFrom = 0;
            zTo = z - 1;
            zBy = 1;
            cFrom = 0;
            cTo = c - 1;
            cBy = 1;
            tFrom = 0;
            tTo = t - 1;
            tBy = 0;
            this.memorySpecifyRangeTester(z, c, t, zFrom, zTo, zBy, cFrom, cTo, cBy, tFrom, tTo, tBy);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMemoryCrop() {
        this.memoryCropTester(203, 255, 55, 20, 3);
        this.memoryCropTester(203, 184, 55, 40, 2);
        this.memoryCropTester(101, 76, 0, 25, 4);
        this.memoryCropTester(100, 122, 0, 15, 3);
    }

    @Test
    public void testSplitChannels() {
        this.splitChannelsTester();
    }

    @Test
    public void testSplitFocalPlanes() {
        this.splitFocalPlanesTester();
    }

    @Test
    public void testSplitTimepoints() {
        this.splitTimepointsTester();
    }

    @Test
    public void testComboConcatSplitFocalPlanes() {
        this.comboConcatSplitFocalPlanesTester();
    }

    @Test
    public void testComboConcatSplitChannels() {
        this.comboConcatSplitChannelsTester();
    }

    @Test
    public void testComboConcatSplitTimepoints() {
        this.comboConcatSplitTimepointsTester();
    }

    @Test
    public void testComboManyOptions() {
        int pixType = 3;
        int sizeX = 106;
        int sizeY = 33;
        int sizeZ = 3;
        int sizeC = 5;
        int sizeT = 7;
        int cropOriginX = 0;
        int cropOriginY = 0;
        int cropSizeX = 55;
        int cropSizeY = 16;
        int start = 1;
        int stepBy = 2;
        ChannelOrder swappedOrder = ChannelOrder.CTZ;
        String path = ImporterTest.constructFakeFilename("superCombo", pixType, sizeX, sizeY, sizeZ, sizeC, sizeT, 1, false, -1, false, -1);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setId(path);
            options.setSwapDimensions(true);
            options.setInputOrder(0, this.bfChanOrd(swappedOrder));
            options.setCrop(true);
            options.setCropRegion(0, new Region(cropOriginX, cropOriginY, cropSizeX, cropSizeY));
            options.setTStep(0, stepBy);
            options.setTBegin(0, start);
            options.setSplitFocalPlanes(true);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, sizeT);
        this.stackCtzSwappedAndCroppedTest(imps, cropSizeX, cropSizeY, sizeZ, sizeC, sizeT, start, stepBy);
    }

    private void colorizeSubcaseTester(int pixType, int sizeC, int rgb, boolean indexed, boolean falseColor, int lutLen) {
        if (pixType != 1 && pixType != 3) {
            throw new IllegalArgumentException("Invalid pixelType: not UINT8 or UINT16 (" + pixType + ")");
        }
        if (sizeC % rgb != 0) {
            throw new IllegalArgumentException("Bad combo of sizeC and rgb: " + sizeC + " " + rgb);
        }
        int channelsPerPlane = rgb;
        if (channelsPerPlane > 7) {
            throw new IllegalArgumentException("Bad sizeC; channelsPerPlane > 7 : " + channelsPerPlane);
        }
        int sizeX = 60;
        int sizeY = 30;
        int sizeZ = 1;
        int sizeT = 1;
        int numSeries = 1;
        String path = ImporterTest.constructFakeFilename("colorColorized", pixType, sizeX, sizeY, sizeZ, sizeC, sizeT, numSeries, indexed, rgb, falseColor, lutLen);
        LOGGER.debug("colorizeSubcaseTester: {}", (Object)path);
        ImagePlus[] imps = null;
        try {
            ImporterOptions options = new ImporterOptions();
            options.setAutoscale(false);
            options.setColorMode("Colorized");
            options.setId(path);
            imps = BF.openImagePlus((ImporterOptions)options);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (FormatException e) {
            Assert.fail((String)e.getMessage());
        }
        this.impsCountTest(imps, 1);
        void imp = imps[0];
        if (lutLen == -1) {
            lutLen = 3;
        }
        int expectedSizeC = this.effectiveC(sizeC, rgb, lutLen, indexed, falseColor);
        this.xyzctTest((ImagePlus)imp, sizeX, sizeY, sizeZ, expectedSizeC, sizeT);
        if (imp.isComposite()) {
            CompositeImage ci = (CompositeImage)imp;
            Assert.assertTrue((boolean)ci.hasCustomLuts());
            Assert.assertEquals((int)2, (int)ci.getMode());
            if (!falseColor) {
                this.colorTests(ci, expectedSizeC, DEFAULT_COLOR_ORDER);
            }
        } else {
            LOGGER.debug("  Not a composite image");
        }
    }

    @Test
    public void testColorizeSubcases() {
        LOGGER.debug("testColorizeSubcases()");
        this.colorizeSubcaseTester(1, 1, 1, true, false, -1);
        this.colorizeSubcaseTester(1, 1, 1, true, true, -1);
        this.colorizeSubcaseTester(1, 1, 1, true, false, 2);
        this.colorizeSubcaseTester(3, 1, 1, true, false, -1);
        this.colorizeSubcaseTester(3, 1, 1, true, true, -1);
        this.colorizeSubcaseTester(3, 1, 1, true, false, 2);
        this.colorizeSubcaseTester(1, 3, 1, true, false, -1);
        this.colorizeSubcaseTester(1, 3, 1, true, true, -1);
        this.colorizeSubcaseTester(1, 3, 3, true, false, -1);
        this.colorizeSubcaseTester(1, 4, 4, false, false, -1);
        this.colorizeSubcaseTester(1, 6, 3, false, false, -1);
        this.colorizeSubcaseTester(1, 12, 3, false, false, -1);
    }

    @Test
    public void testCompositeSubcases() {
        for (boolean indexed : BOOLEAN_STATES) {
            for (int channels = 2; channels <= 7; ++channels) {
                if (indexed) continue;
                this.compositeSubcaseTester(channels, indexed);
            }
        }
        LOGGER.debug("compositeSubcases() unfinished but 2<=sizeC<=7 nonindexed working");
    }

    static {
        String template = ImporterTest.constructFakeFilename("test_C%s_TP%s", 1, 50, 50, 7, 1, 1, -1, false, -1, false, -1);
        FAKE_FILES = new String[]{String.format(template, "1", "1"), String.format(template, "2", "1"), String.format(template, "3", "1"), String.format(template, "1", "2"), String.format(template, "2", "2"), String.format(template, "3", "2"), String.format(template, "1", "3"), String.format(template, "2", "3"), String.format(template, "3", "3"), String.format(template, "1", "4"), String.format(template, "2", "4"), String.format(template, "3", "4"), String.format(template, "1", "5"), String.format(template, "2", "5"), String.format(template, "3", "5")};
        FAKE_PATTERN = String.format(template, "<1-3>", "<1-5>");
        for (String file : FAKE_FILES) {
            Location.mapId((String)file, (String)"iThinkI'mImportantButI'mNot");
        }
    }

    private static enum Axis {
        Z,
        C,
        T;

    }

    private static enum ChannelOrder {
        ZCT,
        ZTC,
        CZT,
        CTZ,
        TZC,
        TCZ;

    }
}

