/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.StringTokenizer;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class PGMReader
extends FormatReader {
    public static final char PGM_MAGIC_CHAR = 'P';
    private boolean rawBits;
    private long offset;

    public PGMReader() {
        super("Portable Any Map", new String[]{"pbm", "pgm", "ppm"});
        this.domains = new String[]{"Graphics"};
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.read() == 80 && Character.isDigit((char)stream.read());
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.offset);
        if (this.rawBits) {
            this.readPlane(this.in, x, y, w, h2, buf);
        } else {
            ByteArrayHandle handle = new ByteArrayHandle();
            RandomAccessOutputStream out = new RandomAccessOutputStream(handle);
            out.order(this.isLittleEndian());
            while (this.in.getFilePointer() < this.in.length()) {
                String line = this.in.readLine().trim();
                line = line.replaceAll("[^0-9]", " ");
                StringTokenizer t2 = new StringTokenizer(line, " ");
                while (t2.hasMoreTokens()) {
                    int q = Integer.parseInt(t2.nextToken().trim());
                    if (this.getPixelType() == 3) {
                        out.writeShort(q);
                        continue;
                    }
                    out.writeByte(q);
                }
            }
            out.close();
            try (RandomAccessInputStream s2 = new RandomAccessInputStream(handle);){
                s2.seek(0L);
                this.readPlane(s2, x, y, w, h2, buf);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.rawBits = false;
            this.offset = 0L;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        Byte c;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        String magic = this.in.readString(2);
        this.rawBits = magic.equals("P4") || magic.equals("P5") || magic.equals("P6");
        m4.sizeC = magic.equals("P3") || magic.equals("P6") ? 3 : 1;
        boolean isBlackAndWhite = magic.equals("P1") || magic.equals("P4");
        StreamTokenizer st = new StreamTokenizer(this.in);
        st.commentChar(35);
        int token = st.nextToken();
        m4.sizeX = (int)st.nval;
        token = st.nextToken();
        m4.sizeY = (int)st.nval;
        if (!isBlackAndWhite) {
            token = st.nextToken();
            int max = (int)st.nval;
            m4.pixelType = max > 255 ? 3 : 1;
        }
        do {
            if ((c = Byte.valueOf(this.in.readByte())) != 35) continue;
            while ((c = Byte.valueOf(this.in.readByte())) != 13 && c != 10) {
            }
        } while (c == 32 || c == 13 || c == 10 || c == 9 || c == 11 || c == 12);
        this.offset = this.in.getFilePointer() - 1L;
        this.addGlobalMeta("Black and white", isBlackAndWhite);
        m4.rgb = this.getSizeC() == 3;
        m4.dimensionOrder = "XYCZT";
        m4.littleEndian = true;
        m4.interleaved = true;
        m4.sizeZ = 1;
        m4.sizeT = 1;
        m4.indexed = false;
        m4.falseColor = false;
        m4.imageCount = 1;
        m4.metadataComplete = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

