/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import loci.poi.hssf.model.DrawingManager2;
import loci.poi.hssf.model.FormulaParser;
import loci.poi.hssf.model.Model;
import loci.poi.hssf.record.BOFRecord;
import loci.poi.hssf.record.BlankRecord;
import loci.poi.hssf.record.BottomMarginRecord;
import loci.poi.hssf.record.CalcCountRecord;
import loci.poi.hssf.record.CalcModeRecord;
import loci.poi.hssf.record.CellValueRecordInterface;
import loci.poi.hssf.record.ColumnInfoRecord;
import loci.poi.hssf.record.DefaultColWidthRecord;
import loci.poi.hssf.record.DefaultRowHeightRecord;
import loci.poi.hssf.record.DeltaRecord;
import loci.poi.hssf.record.DimensionsRecord;
import loci.poi.hssf.record.DrawingRecord;
import loci.poi.hssf.record.EOFRecord;
import loci.poi.hssf.record.EscherAggregate;
import loci.poi.hssf.record.FooterRecord;
import loci.poi.hssf.record.FormulaRecord;
import loci.poi.hssf.record.GridsetRecord;
import loci.poi.hssf.record.GutsRecord;
import loci.poi.hssf.record.HCenterRecord;
import loci.poi.hssf.record.HeaderRecord;
import loci.poi.hssf.record.IndexRecord;
import loci.poi.hssf.record.IterationRecord;
import loci.poi.hssf.record.LabelSSTRecord;
import loci.poi.hssf.record.LeftMarginRecord;
import loci.poi.hssf.record.Margin;
import loci.poi.hssf.record.MergeCellsRecord;
import loci.poi.hssf.record.NumberRecord;
import loci.poi.hssf.record.ObjRecord;
import loci.poi.hssf.record.ObjectProtectRecord;
import loci.poi.hssf.record.PageBreakRecord;
import loci.poi.hssf.record.PaneRecord;
import loci.poi.hssf.record.PasswordRecord;
import loci.poi.hssf.record.PrintGridlinesRecord;
import loci.poi.hssf.record.PrintHeadersRecord;
import loci.poi.hssf.record.PrintSetupRecord;
import loci.poi.hssf.record.ProtectRecord;
import loci.poi.hssf.record.Record;
import loci.poi.hssf.record.RefModeRecord;
import loci.poi.hssf.record.RightMarginRecord;
import loci.poi.hssf.record.RowRecord;
import loci.poi.hssf.record.SCLRecord;
import loci.poi.hssf.record.SaveRecalcRecord;
import loci.poi.hssf.record.ScenarioProtectRecord;
import loci.poi.hssf.record.SelectionRecord;
import loci.poi.hssf.record.TopMarginRecord;
import loci.poi.hssf.record.VCenterRecord;
import loci.poi.hssf.record.WSBoolRecord;
import loci.poi.hssf.record.WindowTwoRecord;
import loci.poi.hssf.record.aggregates.ColumnInfoRecordsAggregate;
import loci.poi.hssf.record.aggregates.FormulaRecordAggregate;
import loci.poi.hssf.record.aggregates.RowRecordsAggregate;
import loci.poi.hssf.record.aggregates.ValueRecordsAggregate;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.hssf.util.PaneInformation;
import loci.poi.util.POILogFactory;
import loci.poi.util.POILogger;

public class Sheet
implements Model {
    public static final short LeftMargin = 0;
    public static final short RightMargin = 1;
    public static final short TopMargin = 2;
    public static final short BottomMargin = 3;
    private static POILogger log = POILogFactory.getLogger(Sheet.class);
    protected ArrayList records = null;
    int preoffset = 0;
    int loc = 0;
    protected int dimsloc = 0;
    protected DimensionsRecord dims;
    protected DefaultColWidthRecord defaultcolwidth = null;
    protected DefaultRowHeightRecord defaultrowheight = null;
    protected GridsetRecord gridset = null;
    protected PrintSetupRecord printSetup = null;
    protected HeaderRecord header = null;
    protected FooterRecord footer = null;
    protected PrintGridlinesRecord printGridlines = null;
    protected WindowTwoRecord windowTwo = null;
    protected MergeCellsRecord merged = null;
    protected Margin[] margins = null;
    protected List mergedRecords = new ArrayList();
    protected int numMergedRegions = 0;
    protected SelectionRecord selection = null;
    protected ColumnInfoRecordsAggregate columns = null;
    protected ValueRecordsAggregate cells = null;
    protected RowRecordsAggregate rows = null;
    private Iterator valueRecIterator = null;
    private Iterator rowRecIterator = null;
    protected int eofLoc = 0;
    protected ProtectRecord protect = null;
    protected PageBreakRecord rowBreaks = null;
    protected PageBreakRecord colBreaks = null;
    protected ObjectProtectRecord objprotect = null;
    protected ScenarioProtectRecord scenprotect = null;
    protected PasswordRecord password = null;
    public static final byte PANE_LOWER_RIGHT = 0;
    public static final byte PANE_UPPER_RIGHT = 1;
    public static final byte PANE_LOWER_LEFT = 2;
    public static final byte PANE_UPPER_LEFT = 3;

    public static Sheet createSheet(List recs, int sheetnum, int offset) {
        if (log.check(1)) {
            log.logFormatted(1, "Sheet createSheet (existing file) with %", new Integer(recs.size()));
        }
        Sheet retval = new Sheet();
        ArrayList<Record> records = new ArrayList<Record>(recs.size() / 5);
        boolean isfirstcell = true;
        boolean isfirstrow = true;
        int bofEofNestingLevel = 0;
        for (int k = offset; k < recs.size(); ++k) {
            Record rec = (Record)recs.get(k);
            if (rec.getSid() == 2057) {
                ++bofEofNestingLevel;
                if (log.check(1)) {
                    log.log(1, "Hit BOF record. Nesting increased to " + bofEofNestingLevel);
                }
            } else if (rec.getSid() == 10) {
                --bofEofNestingLevel;
                if (log.check(1)) {
                    log.log(1, "Hit EOF record. Nesting decreased to " + bofEofNestingLevel);
                }
                if (bofEofNestingLevel == 0) {
                    records.add(rec);
                    retval.eofLoc = k;
                    break;
                }
            } else if (rec.getSid() == 512) {
                if (retval.columns == null) {
                    retval.columns = new ColumnInfoRecordsAggregate();
                    records.add(retval.columns);
                }
                retval.dims = (DimensionsRecord)rec;
                retval.dimsloc = records.size();
            } else if (rec.getSid() == 229) {
                retval.mergedRecords.add(rec);
                retval.merged = (MergeCellsRecord)rec;
                retval.numMergedRegions += retval.merged.getNumAreas();
            } else if (rec.getSid() == 125) {
                ColumnInfoRecord col = (ColumnInfoRecord)rec;
                if (retval.columns != null) {
                    rec = null;
                } else {
                    retval.columns = new ColumnInfoRecordsAggregate();
                    rec = retval.columns;
                }
                retval.columns.insertColumn(col);
            } else if (rec.getSid() == 85) {
                retval.defaultcolwidth = (DefaultColWidthRecord)rec;
            } else if (rec.getSid() == 549) {
                retval.defaultrowheight = (DefaultRowHeightRecord)rec;
            } else if (rec.isValue() && bofEofNestingLevel == 1) {
                if (isfirstcell) {
                    retval.cells = new ValueRecordsAggregate();
                    rec = retval.cells;
                    retval.cells.construct(k, recs);
                    isfirstcell = false;
                } else {
                    rec = null;
                }
            } else if (rec.getSid() == 519) {
                rec = null;
            } else if (rec.getSid() == 520) {
                RowRecord row = (RowRecord)rec;
                if (!isfirstrow) {
                    rec = null;
                }
                if (isfirstrow) {
                    retval.rows = new RowRecordsAggregate();
                    rec = retval.rows;
                    isfirstrow = false;
                }
                retval.rows.insertRow(row);
            } else if (rec.getSid() == 43) {
                retval.printGridlines = (PrintGridlinesRecord)rec;
            } else if (rec.getSid() == 130) {
                retval.gridset = (GridsetRecord)rec;
            } else if (rec.getSid() == 20 && bofEofNestingLevel == 1) {
                retval.header = (HeaderRecord)rec;
            } else if (rec.getSid() == 21 && bofEofNestingLevel == 1) {
                retval.footer = (FooterRecord)rec;
            } else if (rec.getSid() == 161 && bofEofNestingLevel == 1) {
                retval.printSetup = (PrintSetupRecord)rec;
            } else if (rec.getSid() == 38) {
                retval.getMargins()[0] = (LeftMarginRecord)rec;
            } else if (rec.getSid() == 39) {
                retval.getMargins()[1] = (RightMarginRecord)rec;
            } else if (rec.getSid() == 40) {
                retval.getMargins()[2] = (TopMarginRecord)rec;
            } else if (rec.getSid() == 41) {
                retval.getMargins()[3] = (BottomMarginRecord)rec;
            } else if (rec.getSid() == 29) {
                retval.selection = (SelectionRecord)rec;
            } else if (rec.getSid() == 574) {
                retval.windowTwo = (WindowTwoRecord)rec;
            } else if (rec.getSid() == 215) {
                rec = null;
            } else if (rec.getSid() == 523) {
                rec = null;
            } else if (rec.getSid() == 18) {
                retval.protect = (ProtectRecord)rec;
            } else if (rec.getSid() == 99) {
                retval.objprotect = (ObjectProtectRecord)rec;
            } else if (rec.getSid() == 221) {
                retval.scenprotect = (ScenarioProtectRecord)rec;
            } else if (rec.getSid() == 19) {
                retval.password = (PasswordRecord)rec;
            } else if (rec.getSid() == 27) {
                retval.rowBreaks = (PageBreakRecord)rec;
            } else if (rec.getSid() == 26) {
                retval.colBreaks = (PageBreakRecord)rec;
            }
            if (rec == null) continue;
            records.add(rec);
        }
        retval.records = records;
        retval.checkCells();
        retval.checkRows();
        if (log.check(1)) {
            log.log(1, "sheet createSheet (existing file) exited");
        }
        return retval;
    }

    public Sheet cloneSheet() {
        ArrayList<Record> clonedRecords = new ArrayList<Record>(this.records.size());
        for (int i = 0; i < this.records.size(); ++i) {
            Record rec = (Record)((Record)this.records.get(i)).clone();
            if (rec instanceof RowRecordsAggregate) {
                RowRecordsAggregate rrAgg = (RowRecordsAggregate)rec;
                Iterator rowIter = rrAgg.getIterator();
                while (rowIter.hasNext()) {
                    Record rowRec = (Record)rowIter.next();
                    clonedRecords.add(rowRec);
                }
                continue;
            }
            if (rec instanceof ValueRecordsAggregate) {
                ValueRecordsAggregate vrAgg = (ValueRecordsAggregate)rec;
                Iterator cellIter = vrAgg.getIterator();
                while (cellIter.hasNext()) {
                    Record valRec = (Record)cellIter.next();
                    if (valRec instanceof FormulaRecordAggregate) {
                        FormulaRecordAggregate fmAgg = (FormulaRecordAggregate)valRec;
                        Record fmAggRec = fmAgg.getFormulaRecord();
                        if (fmAggRec != null) {
                            clonedRecords.add(fmAggRec);
                        }
                        if ((fmAggRec = fmAgg.getStringRecord()) == null) continue;
                        clonedRecords.add(fmAggRec);
                        continue;
                    }
                    clonedRecords.add(valRec);
                }
                continue;
            }
            if (rec instanceof FormulaRecordAggregate) {
                FormulaRecordAggregate fmAgg = (FormulaRecordAggregate)rec;
                Record fmAggRec = fmAgg.getFormulaRecord();
                if (fmAggRec != null) {
                    clonedRecords.add(fmAggRec);
                }
                if ((fmAggRec = fmAgg.getStringRecord()) == null) continue;
                clonedRecords.add(fmAggRec);
                continue;
            }
            clonedRecords.add(rec);
        }
        return Sheet.createSheet(clonedRecords, 0, 0);
    }

    public static Sheet createSheet(List records, int sheetnum) {
        if (log.check(1)) {
            log.log(1, "Sheet createSheet (exisiting file) assumed offset 0");
        }
        return Sheet.createSheet(records, sheetnum, 0);
    }

    public static Sheet createSheet() {
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch called");
        }
        Sheet retval = new Sheet();
        ArrayList<Record> records = new ArrayList<Record>(30);
        records.add(retval.createBOF());
        records.add(retval.createCalcMode());
        records.add(retval.createCalcCount());
        records.add(retval.createRefMode());
        records.add(retval.createIteration());
        records.add(retval.createDelta());
        records.add(retval.createSaveRecalc());
        records.add(retval.createPrintHeaders());
        retval.printGridlines = (PrintGridlinesRecord)retval.createPrintGridlines();
        records.add(retval.printGridlines);
        retval.gridset = (GridsetRecord)retval.createGridset();
        records.add(retval.gridset);
        records.add(retval.createGuts());
        retval.defaultrowheight = (DefaultRowHeightRecord)retval.createDefaultRowHeight();
        records.add(retval.defaultrowheight);
        records.add(retval.createWSBool());
        retval.rowBreaks = new PageBreakRecord(27);
        records.add(retval.rowBreaks);
        retval.colBreaks = new PageBreakRecord(26);
        records.add(retval.colBreaks);
        retval.header = (HeaderRecord)retval.createHeader();
        records.add(retval.header);
        retval.footer = (FooterRecord)retval.createFooter();
        records.add(retval.footer);
        records.add(retval.createHCenter());
        records.add(retval.createVCenter());
        retval.printSetup = (PrintSetupRecord)retval.createPrintSetup();
        records.add(retval.printSetup);
        retval.defaultcolwidth = (DefaultColWidthRecord)retval.createDefaultColWidth();
        records.add(retval.defaultcolwidth);
        ColumnInfoRecordsAggregate columns = new ColumnInfoRecordsAggregate();
        records.add(columns);
        retval.columns = columns;
        retval.dims = (DimensionsRecord)retval.createDimensions();
        records.add(retval.dims);
        retval.dimsloc = records.size() - 1;
        retval.windowTwo = retval.createWindowTwo();
        records.add(retval.windowTwo);
        retval.setLoc(records.size() - 1);
        retval.selection = (SelectionRecord)retval.createSelection();
        records.add(retval.selection);
        retval.protect = (ProtectRecord)retval.createProtect();
        records.add(retval.protect);
        records.add(retval.createEOF());
        retval.records = records;
        if (log.check(1)) {
            log.log(1, "Sheet createsheet from scratch exit");
        }
        return retval;
    }

    private void checkCells() {
        if (this.cells == null) {
            this.cells = new ValueRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.cells);
        }
    }

    private void checkRows() {
        if (this.rows == null) {
            this.rows = new RowRecordsAggregate();
            this.records.add(this.getDimsLoc() + 1, this.rows);
        }
    }

    public int addMergedRegion(int rowFrom, short colFrom, int rowTo, short colTo) {
        if (this.merged == null || this.merged.getNumAreas() == 1027) {
            this.merged = (MergeCellsRecord)this.createMergedCells();
            this.mergedRecords.add(this.merged);
            this.records.add(this.records.size() - 1, this.merged);
        }
        this.merged.addArea(rowFrom, colFrom, rowTo, colTo);
        return this.numMergedRegions++;
    }

    public void removeMergedRegion(int index) {
        if (index >= this.numMergedRegions || this.mergedRecords.size() == 0) {
            return;
        }
        int pos = 0;
        int startNumRegions = 0;
        if (this.numMergedRegions - index < this.merged.getNumAreas()) {
            pos = this.mergedRecords.size() - 1;
            startNumRegions = this.numMergedRegions - this.merged.getNumAreas();
        } else {
            for (int n = 0; n < this.mergedRecords.size(); ++n) {
                MergeCellsRecord record = (MergeCellsRecord)this.mergedRecords.get(n);
                if (startNumRegions + record.getNumAreas() > index) {
                    pos = n;
                    break;
                }
                startNumRegions += record.getNumAreas();
            }
        }
        MergeCellsRecord rec = (MergeCellsRecord)this.mergedRecords.get(pos);
        rec.removeAreaAt(index - startNumRegions);
        --this.numMergedRegions;
        if (rec.getNumAreas() == 0) {
            this.mergedRecords.remove(pos);
            this.records.remove(this.merged);
            if (this.merged == rec) {
                this.merged = this.mergedRecords.size() > 0 ? (MergeCellsRecord)this.mergedRecords.get(this.mergedRecords.size() - 1) : null;
            }
        }
    }

    public MergeCellsRecord.MergedRegion getMergedRegionAt(int index) {
        if (index >= this.numMergedRegions || this.mergedRecords.size() == 0) {
            return null;
        }
        int pos = 0;
        int startNumRegions = 0;
        if (this.numMergedRegions - index < this.merged.getNumAreas()) {
            pos = this.mergedRecords.size() - 1;
            startNumRegions = this.numMergedRegions - this.merged.getNumAreas();
        } else {
            for (int n = 0; n < this.mergedRecords.size(); ++n) {
                MergeCellsRecord record = (MergeCellsRecord)this.mergedRecords.get(n);
                if (startNumRegions + record.getNumAreas() > index) {
                    pos = n;
                    break;
                }
                startNumRegions += record.getNumAreas();
            }
        }
        return ((MergeCellsRecord)this.mergedRecords.get(pos)).getAreaAt(index - startNumRegions);
    }

    public int getNumMergedRegions() {
        return this.numMergedRegions;
    }

    public int getNumRecords() {
        this.checkCells();
        this.checkRows();
        if (log.check(1)) {
            log.log(1, "Sheet.getNumRecords");
            log.logFormatted(1, "returning % + % + % - 2 = %", new int[]{this.records.size(), this.cells.getPhysicalNumberOfCells(), this.rows.getPhysicalNumberOfRows(), this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2});
        }
        return this.records.size() + this.cells.getPhysicalNumberOfCells() + this.rows.getPhysicalNumberOfRows() - 2;
    }

    public void setDimensions(int firstrow, short firstcol, int lastrow, short lastcol) {
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions");
            log.log(1, new StringBuffer("firstrow").append(firstrow).append("firstcol").append(firstcol).append("lastrow").append(lastrow).append("lastcol").append(lastcol).toString());
        }
        this.dims.setFirstCol(firstcol);
        this.dims.setFirstRow(firstrow);
        this.dims.setLastCol(lastcol);
        this.dims.setLastRow(lastrow);
        if (log.check(1)) {
            log.log(1, "Sheet.setDimensions exiting");
        }
    }

    public void setLoc(int loc) {
        this.valueRecIterator = null;
        if (log.check(1)) {
            log.log(1, "sheet.setLoc(): " + loc);
        }
        this.loc = loc;
    }

    public int getLoc() {
        if (log.check(1)) {
            log.log(1, "sheet.getLoc():" + this.loc);
        }
        return this.loc;
    }

    public void setPreOffset(int offset) {
        this.preoffset = offset;
    }

    public int getPreOffset() {
        return this.preoffset;
    }

    public int serialize(int offset, byte[] data) {
        if (log.check(1)) {
            log.log(1, "Sheet.serialize using offsets");
        }
        int pos = offset;
        boolean haveSerializedIndex = false;
        for (int k = 0; k < this.records.size(); ++k) {
            Record record = (Record)this.records.get(k);
            if (record instanceof RowRecordsAggregate) {
                pos += ((RowRecordsAggregate)record).serialize(pos, data, this.cells);
            } else if (!(record instanceof ValueRecordsAggregate)) {
                pos += record.serialize(pos, data);
            }
            if (record.getSid() != 2057 || this.rows == null || haveSerializedIndex) continue;
            haveSerializedIndex = true;
            pos += this.serializeIndexRecord(k, pos, data);
        }
        if (log.check(1)) {
            log.log(1, "Sheet.serialize returning ");
        }
        return pos - offset;
    }

    private int serializeIndexRecord(int BOFRecordIndex, int offset, byte[] data) {
        Record tmpRec;
        IndexRecord index = new IndexRecord();
        index.setFirstRow(this.rows.getFirstRowNum());
        index.setLastRowAdd1(this.rows.getLastRowNum() + 1);
        int sheetRecSize = 0;
        for (int j = BOFRecordIndex + 1; j < this.records.size() && !((tmpRec = (Record)this.records.get(j)) instanceof RowRecordsAggregate); ++j) {
            sheetRecSize += tmpRec.getRecordSize();
        }
        int blockCount = this.rows.getRowBlockCount();
        int indexRecSize = IndexRecord.getRecordSizeForBlockCount(blockCount);
        int rowBlockOffset = 0;
        int cellBlockOffset = 0;
        int dbCellOffset = 0;
        for (int block = 0; block < blockCount; ++block) {
            index.addDbcell(offset + indexRecSize + sheetRecSize + dbCellOffset + (rowBlockOffset += this.rows.getRowBlockSize(block)) + (cellBlockOffset += null == this.cells ? 0 : this.cells.getRowCellBlockSize(this.rows.getStartRowNumberForBlock(block), this.rows.getEndRowNumberForBlock(block))));
            dbCellOffset += 8 + this.rows.getRowCountForBlock(block) * 2;
        }
        return index.serialize(offset, data);
    }

    public RowRecord createRow(int row) {
        return RowRecordsAggregate.createRow(row);
    }

    public LabelSSTRecord createLabelSST(int row, short col, int index) {
        log.logFormatted(1, "create labelsst row,col,index %,%,%", new int[]{row, col, index});
        LabelSSTRecord rec = new LabelSSTRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setSSTIndex(index);
        rec.setXFIndex((short)15);
        return rec;
    }

    public NumberRecord createNumber(int row, short col, double value) {
        log.logFormatted(1, "create number row,col,value %,%,%", new double[]{row, col, value});
        NumberRecord rec = new NumberRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setValue(value);
        rec.setXFIndex((short)15);
        return rec;
    }

    public BlankRecord createBlank(int row, short col) {
        log.logFormatted(1, "create blank row,col %,%", new int[]{row, col});
        BlankRecord rec = new BlankRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setXFIndex((short)15);
        return rec;
    }

    public FormulaRecord createFormula(int row, short col, String formula) {
        log.logFormatted(1, "create formula row,col,formula %,%,%", new int[]{row, col}, formula);
        FormulaRecord rec = new FormulaRecord();
        rec.setRow(row);
        rec.setColumn(col);
        rec.setOptions((short)2);
        rec.setValue(0.0);
        rec.setXFIndex((short)15);
        FormulaParser fp = new FormulaParser(formula, null);
        fp.parse();
        Ptg[] ptg = fp.getRPNPtg();
        int size = 0;
        for (int k = 0; k < ptg.length; ++k) {
            size += ptg[k].getSize();
            rec.pushExpressionToken(ptg[k]);
        }
        rec.setExpressionLength((short)size);
        return rec;
    }

    public void addValueRecord(int row, CellValueRecordInterface col) {
        this.checkCells();
        if (log.check(1)) {
            log.logFormatted(1, "add value record  row,loc %,%", new int[]{row, this.loc});
        }
        DimensionsRecord d = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (col.getColumn() > d.getLastCol()) {
            d.setLastCol((short)(col.getColumn() + 1));
        }
        if (col.getColumn() < d.getFirstCol()) {
            d.setFirstCol(col.getColumn());
        }
        this.cells.insertCell(col);
    }

    public void removeValueRecord(int row, CellValueRecordInterface col) {
        this.checkCells();
        log.logFormatted(1, "remove value record row,dimsloc %,%", new int[]{row, this.dimsloc});
        this.loc = this.dimsloc;
        this.cells.removeCell(col);
    }

    public void replaceValueRecord(CellValueRecordInterface newval) {
        this.checkCells();
        this.setLoc(this.dimsloc);
        if (log.check(1)) {
            log.log(1, "replaceValueRecord ");
        }
        this.cells.removeCell(newval);
        this.cells.insertCell(newval);
    }

    public void addRow(RowRecord row) {
        RowRecord existingRow;
        this.checkRows();
        if (log.check(1)) {
            log.log(1, "addRow ");
        }
        DimensionsRecord d = (DimensionsRecord)this.records.get(this.getDimsLoc());
        if (row.getRowNumber() >= d.getLastRow()) {
            d.setLastRow(row.getRowNumber() + 1);
        }
        if (row.getRowNumber() < d.getFirstRow()) {
            d.setFirstRow(row.getRowNumber());
        }
        if ((existingRow = this.rows.getRow(row.getRowNumber())) != null) {
            this.rows.removeRow(existingRow);
        }
        this.rows.insertRow(row);
        if (log.check(1)) {
            log.log(1, "exit addRow");
        }
    }

    public void removeRow(RowRecord row) {
        this.checkRows();
        this.setLoc(this.getDimsLoc());
        this.rows.removeRow(row);
    }

    public CellValueRecordInterface getNextValueRecord() {
        if (log.check(1)) {
            log.log(1, "getNextValue loc= " + this.loc);
        }
        if (this.valueRecIterator == null) {
            this.valueRecIterator = this.cells.getIterator();
        }
        if (!this.valueRecIterator.hasNext()) {
            return null;
        }
        return (CellValueRecordInterface)this.valueRecIterator.next();
    }

    public RowRecord getNextRow() {
        if (log.check(1)) {
            log.log(1, "getNextRow loc= " + this.loc);
        }
        if (this.rowRecIterator == null) {
            this.rowRecIterator = this.rows.getIterator();
        }
        if (!this.rowRecIterator.hasNext()) {
            return null;
        }
        return (RowRecord)this.rowRecIterator.next();
    }

    public RowRecord getRow(int rownum) {
        if (log.check(1)) {
            log.log(1, "getNextRow loc= " + this.loc);
        }
        return this.rows.getRow(rownum);
    }

    protected Record createBOF() {
        BOFRecord retval = new BOFRecord();
        retval.setVersion((short)1536);
        retval.setType((short)16);
        retval.setBuild((short)3515);
        retval.setBuildYear((short)1996);
        retval.setHistoryBitMask(193);
        retval.setRequiredVersion(6);
        return retval;
    }

    protected Record createIndex() {
        IndexRecord retval = new IndexRecord();
        retval.setFirstRow(0);
        retval.setLastRowAdd1(0);
        return retval;
    }

    protected Record createCalcMode() {
        CalcModeRecord retval = new CalcModeRecord();
        retval.setCalcMode((short)1);
        return retval;
    }

    protected Record createCalcCount() {
        CalcCountRecord retval = new CalcCountRecord();
        retval.setIterations((short)100);
        return retval;
    }

    protected Record createRefMode() {
        RefModeRecord retval = new RefModeRecord();
        retval.setMode((short)1);
        return retval;
    }

    protected Record createIteration() {
        IterationRecord retval = new IterationRecord();
        retval.setIteration(false);
        return retval;
    }

    protected Record createDelta() {
        DeltaRecord retval = new DeltaRecord();
        retval.setMaxChange(0.001);
        return retval;
    }

    protected Record createSaveRecalc() {
        SaveRecalcRecord retval = new SaveRecalcRecord();
        retval.setRecalc(true);
        return retval;
    }

    protected Record createPrintHeaders() {
        PrintHeadersRecord retval = new PrintHeadersRecord();
        retval.setPrintHeaders(false);
        return retval;
    }

    protected Record createPrintGridlines() {
        PrintGridlinesRecord retval = new PrintGridlinesRecord();
        retval.setPrintGridlines(false);
        return retval;
    }

    protected Record createGridset() {
        GridsetRecord retval = new GridsetRecord();
        retval.setGridset(true);
        return retval;
    }

    protected Record createGuts() {
        GutsRecord retval = new GutsRecord();
        retval.setLeftRowGutter((short)0);
        retval.setTopColGutter((short)0);
        retval.setRowLevelMax((short)0);
        retval.setColLevelMax((short)0);
        return retval;
    }

    protected Record createDefaultRowHeight() {
        DefaultRowHeightRecord retval = new DefaultRowHeightRecord();
        retval.setOptionFlags((short)0);
        retval.setRowHeight((short)255);
        return retval;
    }

    protected Record createWSBool() {
        WSBoolRecord retval = new WSBoolRecord();
        retval.setWSBool1((byte)4);
        retval.setWSBool2((byte)-63);
        return retval;
    }

    protected Record createHeader() {
        HeaderRecord retval = new HeaderRecord();
        retval.setHeaderLength((byte)0);
        retval.setHeader(null);
        return retval;
    }

    protected Record createFooter() {
        FooterRecord retval = new FooterRecord();
        retval.setFooterLength((byte)0);
        retval.setFooter(null);
        return retval;
    }

    protected Record createHCenter() {
        HCenterRecord retval = new HCenterRecord();
        retval.setHCenter(false);
        return retval;
    }

    protected Record createVCenter() {
        VCenterRecord retval = new VCenterRecord();
        retval.setVCenter(false);
        return retval;
    }

    protected Record createPrintSetup() {
        PrintSetupRecord retval = new PrintSetupRecord();
        retval.setPaperSize((short)1);
        retval.setScale((short)100);
        retval.setPageStart((short)1);
        retval.setFitWidth((short)1);
        retval.setFitHeight((short)1);
        retval.setOptions((short)2);
        retval.setHResolution((short)300);
        retval.setVResolution((short)300);
        retval.setHeaderMargin(0.5);
        retval.setFooterMargin(0.5);
        retval.setCopies((short)0);
        return retval;
    }

    protected Record createDefaultColWidth() {
        DefaultColWidthRecord retval = new DefaultColWidthRecord();
        retval.setColWidth((short)8);
        return retval;
    }

    protected Record createColInfo() {
        return ColumnInfoRecordsAggregate.createColInfo();
    }

    public short getDefaultColumnWidth() {
        return this.defaultcolwidth.getColWidth();
    }

    public boolean isGridsPrinted() {
        if (this.gridset == null) {
            this.gridset = (GridsetRecord)this.createGridset();
            int loc = this.findFirstRecordLocBySid((short)10);
            this.records.add(loc, this.gridset);
        }
        return !this.gridset.getGridset();
    }

    public void setGridsPrinted(boolean value) {
        this.gridset.setGridset(!value);
    }

    public void setDefaultColumnWidth(short dcw) {
        this.defaultcolwidth.setColWidth(dcw);
    }

    public void setDefaultRowHeight(short dch) {
        this.defaultrowheight.setRowHeight(dch);
    }

    public short getDefaultRowHeight() {
        return this.defaultrowheight.getRowHeight();
    }

    public short getColumnWidth(short column) {
        short retval = 0;
        ColumnInfoRecord ci = null;
        if (this.columns != null) {
            int count = this.columns.getNumColumns();
            for (int k = 0; k < count && ((ci = this.columns.getColInfo(k)).getFirstColumn() > column || column > ci.getLastColumn()); ++k) {
                ci = null;
            }
        }
        retval = ci != null ? ci.getColumnWidth() : this.defaultcolwidth.getColWidth();
        return retval;
    }

    public short getXFIndexForColAt(short column) {
        short retval = 0;
        ColumnInfoRecord ci = null;
        if (this.columns != null) {
            int count = this.columns.getNumColumns();
            for (int k = 0; k < count && ((ci = this.columns.getColInfo(k)).getFirstColumn() > column || column > ci.getLastColumn()); ++k) {
                ci = null;
            }
        }
        retval = ci != null ? (short)ci.getXFIndex() : (short)15;
        return retval;
    }

    public void setColumnWidth(short column, short width) {
        this.setColumn(column, new Short(width), null, null, null);
    }

    public boolean isColumnHidden(short column) {
        boolean retval = false;
        ColumnInfoRecord ci = null;
        if (this.columns != null) {
            Iterator iterator = this.columns.getIterator();
            while (iterator.hasNext() && ((ci = (ColumnInfoRecord)iterator.next()).getFirstColumn() > column || column > ci.getLastColumn())) {
                ci = null;
            }
        }
        if (ci != null) {
            retval = ci.getHidden();
        }
        return retval;
    }

    public void setColumnHidden(short column, boolean hidden) {
        this.setColumn(column, null, null, new Boolean(hidden), null);
    }

    public void setColumn(short column, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        if (this.columns == null) {
            this.columns = new ColumnInfoRecordsAggregate();
        }
        this.columns.setColumn(column, null, width, level, hidden, collapsed);
    }

    public void setColumn(short column, Short xfStyle, Short width, Integer level, Boolean hidden, Boolean collapsed) {
        if (this.columns == null) {
            this.columns = new ColumnInfoRecordsAggregate();
        }
        this.columns.setColumn(column, xfStyle, width, level, hidden, collapsed);
    }

    public void groupColumnRange(short fromColumn, short toColumn, boolean indent) {
        this.columns.groupColumnRange(fromColumn, toColumn, indent);
        int maxLevel = 0;
        int count = this.columns.getNumColumns();
        for (int k = 0; k < count; ++k) {
            ColumnInfoRecord columnInfoRecord = this.columns.getColInfo(k);
            maxLevel = Math.max(columnInfoRecord.getOutlineLevel(), maxLevel);
        }
        GutsRecord guts = (GutsRecord)this.findFirstRecordBySid((short)128);
        guts.setColLevelMax((short)(maxLevel + 1));
        if (maxLevel == 0) {
            guts.setTopColGutter((short)0);
        } else {
            guts.setTopColGutter((short)(29 + 12 * (maxLevel - 1)));
        }
    }

    protected Record createDimensions() {
        DimensionsRecord retval = new DimensionsRecord();
        retval.setFirstCol((short)0);
        retval.setLastRow(1);
        retval.setFirstRow(0);
        retval.setLastCol((short)1);
        return retval;
    }

    protected WindowTwoRecord createWindowTwo() {
        WindowTwoRecord retval = new WindowTwoRecord();
        retval.setOptions((short)1718);
        retval.setTopRow((short)0);
        retval.setLeftCol((short)0);
        retval.setHeaderColor(64);
        retval.setPageBreakZoom((short)0);
        retval.setNormalZoom((short)0);
        return retval;
    }

    protected Record createSelection() {
        SelectionRecord retval = new SelectionRecord();
        retval.setPane((byte)3);
        retval.setActiveCellCol((short)0);
        retval.setActiveCellRow(0);
        retval.setNumRefs((short)0);
        return retval;
    }

    public short getTopRow() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getTopRow();
    }

    public void setTopRow(short topRow) {
        if (this.windowTwo != null) {
            this.windowTwo.setTopRow(topRow);
        }
    }

    public void setLeftCol(short leftCol) {
        if (this.windowTwo != null) {
            this.windowTwo.setLeftCol(leftCol);
        }
    }

    public short getLeftCol() {
        return this.windowTwo == null ? (short)0 : this.windowTwo.getLeftCol();
    }

    public int getActiveCellRow() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellRow();
    }

    public void setActiveCellRow(int row) {
        if (this.selection != null) {
            this.selection.setActiveCellRow(row);
        }
    }

    public short getActiveCellCol() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.getActiveCellCol();
    }

    public void setActiveCellCol(short col) {
        if (this.selection != null) {
            this.selection.setActiveCellCol(col);
        }
    }

    protected Record createMergedCells() {
        MergeCellsRecord retval = new MergeCellsRecord();
        retval.setNumAreas((short)0);
        return retval;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    public int getDimsLoc() {
        if (log.check(1)) {
            log.log(1, "getDimsLoc dimsloc= " + this.dimsloc);
        }
        return this.dimsloc;
    }

    public void checkDimsLoc(Record rec, int recloc) {
        if (rec.getSid() == 512) {
            this.loc = recloc;
            this.dimsloc = recloc;
        }
    }

    public int getSize() {
        int retval = 0;
        for (int k = 0; k < this.records.size(); ++k) {
            retval += ((Record)this.records.get(k)).getRecordSize();
        }
        if (this.rows != null) {
            int blocks = this.rows.getRowBlockCount();
            retval += IndexRecord.getRecordSizeForBlockCount(blocks);
            retval += 8 * blocks;
            Iterator itr = this.rows.getIterator();
            while (itr.hasNext()) {
                RowRecord row = (RowRecord)itr.next();
                if (this.cells == null || !this.cells.rowHasCells(row.getRowNumber())) continue;
                retval += 2;
            }
        }
        return retval;
    }

    public List getRecords() {
        return this.records;
    }

    public GridsetRecord getGridsetRecord() {
        return this.gridset;
    }

    public Record findFirstRecordBySid(short sid) {
        for (Record record : this.records) {
            if (record.getSid() != sid) continue;
            return record;
        }
        return null;
    }

    public void setSCLRecord(SCLRecord sclRecord) {
        int oldRecordLoc = this.findFirstRecordLocBySid((short)160);
        if (oldRecordLoc == -1) {
            int windowRecordLoc = this.findFirstRecordLocBySid((short)574);
            this.records.add(windowRecordLoc + 1, sclRecord);
        } else {
            this.records.set(oldRecordLoc, sclRecord);
        }
    }

    public int findFirstRecordLocBySid(short sid) {
        int index = 0;
        for (Record record : this.records) {
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public HeaderRecord getHeader() {
        return this.header;
    }

    public void setHeader(HeaderRecord newHeader) {
        this.header = newHeader;
    }

    public FooterRecord getFooter() {
        return this.footer;
    }

    public void setFooter(FooterRecord newFooter) {
        this.footer = newFooter;
    }

    public PrintSetupRecord getPrintSetup() {
        return this.printSetup;
    }

    public void setPrintSetup(PrintSetupRecord newPrintSetup) {
        this.printSetup = newPrintSetup;
    }

    public PrintGridlinesRecord getPrintGridlines() {
        return this.printGridlines;
    }

    public void setPrintGridlines(PrintGridlinesRecord newPrintGridlines) {
        this.printGridlines = newPrintGridlines;
    }

    public void setSelected(boolean sel) {
        this.windowTwo.setSelected(sel);
    }

    public double getMargin(short margin) {
        if (this.getMargins()[margin] != null) {
            return this.margins[margin].getMargin();
        }
        switch (margin) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return 1.0;
            }
        }
        throw new RuntimeException("Unknown margin constant:  " + margin);
    }

    public void setMargin(short margin, double size) {
        Margin m = this.getMargins()[margin];
        if (m == null) {
            switch (margin) {
                case 0: {
                    m = new LeftMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                case 1: {
                    m = new RightMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                case 2: {
                    m = new TopMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                case 3: {
                    m = new BottomMarginRecord();
                    this.records.add(this.getDimsLoc() + 1, m);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown margin constant:  " + margin);
                }
            }
            this.margins[margin] = m;
        }
        m.setMargin(size);
    }

    public int getEofLoc() {
        return this.eofLoc;
    }

    public void createFreezePane(int colSplit, int rowSplit, int topRow, int leftmostColumn) {
        int paneLoc = this.findFirstRecordLocBySid((short)65);
        if (paneLoc != -1) {
            this.records.remove(paneLoc);
        }
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord pane = new PaneRecord();
        pane.setX((short)colSplit);
        pane.setY((short)rowSplit);
        pane.setTopRow((short)topRow);
        pane.setLeftColumn((short)leftmostColumn);
        if (rowSplit == 0) {
            pane.setTopRow((short)0);
            pane.setActivePane((short)1);
        } else if (colSplit == 0) {
            pane.setLeftColumn((short)64);
            pane.setActivePane((short)2);
        } else {
            pane.setActivePane((short)0);
        }
        this.records.add(loc + 1, pane);
        this.windowTwo.setFreezePanes(true);
        this.windowTwo.setFreezePanesNoSplit(true);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)pane.getActivePane());
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int topRow, int leftmostColumn, int activePane) {
        int paneLoc = this.findFirstRecordLocBySid((short)65);
        if (paneLoc != -1) {
            this.records.remove(paneLoc);
        }
        int loc = this.findFirstRecordLocBySid((short)574);
        PaneRecord r = new PaneRecord();
        r.setX((short)xSplitPos);
        r.setY((short)ySplitPos);
        r.setTopRow((short)topRow);
        r.setLeftColumn((short)leftmostColumn);
        r.setActivePane((short)activePane);
        this.records.add(loc + 1, r);
        this.windowTwo.setFreezePanes(false);
        this.windowTwo.setFreezePanesNoSplit(false);
        SelectionRecord sel = (SelectionRecord)this.findFirstRecordBySid((short)29);
        sel.setPane((byte)0);
    }

    public PaneInformation getPaneInformation() {
        PaneRecord rec = (PaneRecord)this.findFirstRecordBySid((short)65);
        if (rec == null) {
            return null;
        }
        return new PaneInformation(rec.getX(), rec.getY(), rec.getTopRow(), rec.getLeftColumn(), (byte)rec.getActivePane(), this.windowTwo.getFreezePanes());
    }

    public SelectionRecord getSelection() {
        return this.selection;
    }

    public void setSelection(SelectionRecord selection) {
        this.selection = selection;
    }

    protected Record createProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ProtectRecord retval = new ProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected ObjectProtectRecord createObjectProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ObjectProtectRecord retval = new ObjectProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected ScenarioProtectRecord createScenarioProtect() {
        if (log.check(1)) {
            log.log(1, "create protect record with protection disabled");
        }
        ScenarioProtectRecord retval = new ScenarioProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    public ProtectRecord getProtect() {
        if (this.protect == null) {
            this.protect = (ProtectRecord)this.createProtect();
            int loc = this.findFirstRecordLocBySid((short)10);
            this.records.add(loc, this.protect);
        }
        return this.protect;
    }

    public PasswordRecord getPassword() {
        if (this.password == null) {
            this.password = this.createPassword();
            int loc = this.findFirstRecordLocBySid((short)10);
            this.records.add(loc, this.password);
        }
        return this.password;
    }

    protected PasswordRecord createPassword() {
        if (log.check(1)) {
            log.log(1, "create password record with 00 password");
        }
        PasswordRecord retval = new PasswordRecord();
        retval.setPassword((short)0);
        return retval;
    }

    public void setDisplayGridlines(boolean show) {
        this.windowTwo.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this.windowTwo.getDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this.windowTwo.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this.windowTwo.getDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this.windowTwo.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this.windowTwo.getDisplayRowColHeadings();
    }

    protected Margin[] getMargins() {
        if (this.margins == null) {
            this.margins = new Margin[4];
        }
        return this.margins;
    }

    public int aggregateDrawingRecords(DrawingManager2 drawingManager) {
        boolean noDrawingRecordsFound;
        int loc = this.findFirstRecordLocBySid((short)236);
        boolean bl = noDrawingRecordsFound = loc == -1;
        if (noDrawingRecordsFound) {
            EscherAggregate aggregate = new EscherAggregate(drawingManager);
            loc = this.findFirstRecordLocBySid((short)9876);
            if (loc == -1) {
                loc = this.findFirstRecordLocBySid((short)574);
            } else {
                this.getRecords().remove(loc);
            }
            this.getRecords().add(loc, aggregate);
            return loc;
        }
        List records = this.getRecords();
        EscherAggregate r = EscherAggregate.createAggregate(records, loc, drawingManager);
        int startloc = loc;
        while (loc + 1 < records.size() && records.get(loc) instanceof DrawingRecord && records.get(loc + 1) instanceof ObjRecord) {
            loc += 2;
        }
        int endloc = loc - 1;
        for (int i = 0; i < endloc - startloc + 1; ++i) {
            records.remove(startloc);
        }
        records.add(startloc, r);
        return startloc;
    }

    public void preSerialize() {
        for (Record r : this.getRecords()) {
            if (!(r instanceof EscherAggregate)) continue;
            r.getRecordSize();
        }
    }

    public void shiftBreaks(PageBreakRecord breaks, short start, short stop, int count) {
        if (this.rowBreaks == null) {
            return;
        }
        Iterator iterator = breaks.getBreaksIterator();
        ArrayList<PageBreakRecord.Break> shiftedBreak = new ArrayList<PageBreakRecord.Break>();
        while (iterator.hasNext()) {
            boolean inEnd;
            PageBreakRecord.Break breakItem = (PageBreakRecord.Break)iterator.next();
            short breakLocation = breakItem.main;
            boolean inStart = breakLocation >= start;
            boolean bl = inEnd = breakLocation <= stop;
            if (!inStart || !inEnd) continue;
            shiftedBreak.add(breakItem);
        }
        for (PageBreakRecord.Break breakItem : shiftedBreak) {
            breaks.removeBreak(breakItem.main);
            breaks.addBreak((short)(breakItem.main + count), breakItem.subFrom, breakItem.subTo);
        }
    }

    public void setRowBreak(int row, short fromCol, short toCol) {
        if (this.rowBreaks == null) {
            int loc = this.findFirstRecordLocBySid((short)574);
            this.rowBreaks = new PageBreakRecord(27);
            this.records.add(loc, this.rowBreaks);
        }
        this.rowBreaks.addBreak((short)row, fromCol, toCol);
    }

    public void removeRowBreak(int row) {
        if (this.rowBreaks == null) {
            throw new IllegalArgumentException("Sheet does not define any row breaks");
        }
        this.rowBreaks.removeBreak((short)row);
    }

    public boolean isRowBroken(int row) {
        return this.rowBreaks == null ? false : this.rowBreaks.getBreak((short)row) != null;
    }

    public void setColumnBreak(short column, short fromRow, short toRow) {
        if (this.colBreaks == null) {
            int loc = this.findFirstRecordLocBySid((short)574);
            this.colBreaks = new PageBreakRecord(26);
            this.records.add(loc, this.colBreaks);
        }
        this.colBreaks.addBreak(column, fromRow, toRow);
    }

    public void removeColumnBreak(short column) {
        if (this.colBreaks == null) {
            throw new IllegalArgumentException("Sheet does not define any column breaks");
        }
        this.colBreaks.removeBreak(column);
    }

    public boolean isColumnBroken(short column) {
        return this.colBreaks == null ? false : this.colBreaks.getBreak(column) != null;
    }

    public void shiftRowBreaks(int startingRow, int endingRow, int count) {
        this.shiftBreaks(this.rowBreaks, (short)startingRow, (short)endingRow, (short)count);
    }

    public void shiftColumnBreaks(short startingCol, short endingCol, short count) {
        this.shiftBreaks(this.colBreaks, startingCol, endingCol, count);
    }

    public Iterator getRowBreaks() {
        return this.rowBreaks.getBreaksIterator();
    }

    public int getNumRowBreaks() {
        return this.rowBreaks == null ? 0 : (int)this.rowBreaks.getNumBreaks();
    }

    public Iterator getColumnBreaks() {
        return this.colBreaks.getBreaksIterator();
    }

    public int getNumColumnBreaks() {
        return this.colBreaks == null ? 0 : (int)this.colBreaks.getNumBreaks();
    }

    public void setColumnGroupCollapsed(short columnNumber, boolean collapsed) {
        if (collapsed) {
            this.columns.collapseColumn(columnNumber);
        } else {
            this.columns.expandColumn(columnNumber);
        }
    }

    public void protectSheet(String password, boolean objects, boolean scenarios) {
        int protIdx = -1;
        ProtectRecord prec = this.getProtect();
        PasswordRecord pass = this.getPassword();
        prec.setProtect(true);
        pass.setPassword(PasswordRecord.hashPassword(password));
        if (this.objprotect == null && objects || this.scenprotect != null && scenarios) {
            protIdx = this.records.indexOf(this.protect);
        }
        if (this.objprotect == null && objects) {
            ObjectProtectRecord rec = this.createObjectProtect();
            rec.setProtect(true);
            this.records.add(protIdx + 1, rec);
            this.objprotect = rec;
        }
        if (this.scenprotect == null && scenarios) {
            ScenarioProtectRecord srec = this.createScenarioProtect();
            srec.setProtect(true);
            this.records.add(protIdx + 2, srec);
            this.scenprotect = srec;
        }
    }

    public void unprotectSheet(boolean sheet, boolean objects, boolean scenarios) {
        int protIdx = -1;
        if (!sheet) {
            ProtectRecord prec = this.getProtect();
            prec.setProtect(sheet);
            PasswordRecord pass = this.getPassword();
            pass.setPassword((short)0);
        }
        if (this.objprotect != null && !objects) {
            this.objprotect.setProtect(false);
        }
        if (this.scenprotect != null && !scenarios) {
            this.scenprotect.setProtect(false);
        }
    }

    public boolean[] isProtected() {
        return new boolean[]{this.protect != null && this.protect.getProtect(), this.objprotect != null && this.objprotect.getProtect(), this.scenprotect != null && this.scenprotect.getProtect()};
    }

    public void groupRowRange(int fromRow, int toRow, boolean indent) {
        this.checkRows();
        for (int rowNum = fromRow; rowNum <= toRow; ++rowNum) {
            RowRecord row = this.getRow(rowNum);
            if (row == null) {
                row = this.createRow(rowNum);
                this.addRow(row);
            }
            int level = row.getOutlineLevel();
            level = indent ? ++level : --level;
            level = Math.max(0, level);
            level = Math.min(7, level);
            row.setOutlineLevel((short)level);
        }
        this.recalcRowGutter();
    }

    private void recalcRowGutter() {
        int maxLevel = 0;
        Iterator iterator = this.rows.getIterator();
        while (iterator.hasNext()) {
            RowRecord rowRecord = (RowRecord)iterator.next();
            maxLevel = Math.max(rowRecord.getOutlineLevel(), maxLevel);
        }
        GutsRecord guts = (GutsRecord)this.findFirstRecordBySid((short)128);
        guts.setRowLevelMax((short)(maxLevel + 1));
        guts.setLeftRowGutter((short)(29 + 12 * maxLevel));
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        if (collapse) {
            this.rows.collapseRow(row);
        } else {
            this.rows.expandRow(row);
        }
    }
}

