/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.remote;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import java.util.zip.InflaterInputStream;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.ma2.Array;
import ucar.nc2.ft2.coverage.CoordAxisReader;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageReader;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.remote.CdmrFeatureProto;
import ucar.nc2.ft2.coverage.remote.CdmrfReader;
import ucar.nc2.ft2.coverage.remote.CoverageDataResponse;
import ucar.nc2.ft2.coverage.remote.GeoArrayResponse;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamReader;

public class CdmrCoverageReader
implements CoverageReader,
CoordAxisReader {
    private Escaper urlParamEscaper = UrlEscapers.urlFormParameterEscaper();
    String endpoint;
    HTTPSession httpClient;
    boolean showCompression = true;
    boolean showRequest = true;

    CdmrCoverageReader(String endpoint, HTTPSession httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public String getLocation() {
        return this.endpoint;
    }

    @Override
    public GeoReferencedArray readData(Coverage coverage, SubsetParams subset, boolean canonicalOrder) throws IOException {
        if (this.httpClient == null) {
            this.httpClient = HTTPFactory.newSession(this.endpoint);
        }
        Formatter f = new Formatter();
        f.format("%s?", this.endpoint);
        subset.encodeForCdmrfDataRequest(f, coverage.getName());
        if (this.showRequest) {
            System.out.printf("CdmrFeature data request for gridCoverage: %s%n url=%s", coverage.getName(), f);
        }
        long start = System.currentTimeMillis();
        try (HTTPMethod method = HTTPFactory.Get(this.httpClient, f.toString());){
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(CdmrCoverageReader.getErrorMessage(method));
            }
            if (statusCode >= 300) {
                throw new IOException(CdmrCoverageReader.getErrorMessage(method));
            }
            int readLen = 0;
            Optional<String> value = method.getResponseHeaderValue("Content-Length");
            if (value.isPresent()) {
                readLen = Integer.parseInt(value.get());
            }
            CdmrfReader cdmrfReader = new CdmrfReader(this.endpoint);
            InputStream is = method.getResponseAsStream();
            if (!NcStream.readAndTest(is, NcStream.MAGIC_DATACOV)) {
                throw new IOException("Data transfer corrupted");
            }
            int psize = NcStream.readVInt(is);
            if (psize < 0 || psize > readLen && readLen > 0) {
                throw new IOException("Data transfer corrupted");
            }
            byte[] dp = new byte[psize];
            NcStream.readFully(is, dp);
            CdmrFeatureProto.CoverageDataResponse dproto = CdmrFeatureProto.CoverageDataResponse.parseFrom(dp);
            CoverageDataResponse dataResponse = cdmrfReader.decodeDataResponse(dproto);
            List<GeoReferencedArray> geoArrays = dataResponse.arrayResponse;
            assert (geoArrays.size() == 1);
            if (this.showRequest) {
                System.out.printf(" took %d msecs%n", System.currentTimeMillis() - start);
            }
            GeoReferencedArray geoReferencedArray = geoArrays.get(0);
            return geoReferencedArray;
        }
    }

    public GeoReferencedArray readData(CoverageDataResponse dataResponse, GeoArrayResponse arrayResponse, InputStream is) throws IOException {
        int sizeIn = NcStream.readVInt(is);
        if (arrayResponse.deflate) {
            float ratio;
            is = new InflaterInputStream(is);
            float f = ratio = sizeIn == 0 ? 0.0f : (float)arrayResponse.uncompressedSize / (float)sizeIn;
            if (this.showCompression) {
                System.out.printf("  readData data message compress= %d decompress=%d compress=%f%n", sizeIn, arrayResponse.uncompressedSize, Float.valueOf(ratio));
            }
        }
        byte[] datab = new byte[(int)arrayResponse.uncompressedSize];
        NcStream.readFully(is, datab);
        Array data = Array.factory(arrayResponse.dataType, arrayResponse.shape, ByteBuffer.wrap(datab));
        CoverageCoordSys csys = dataResponse.findCoordSys(arrayResponse.coordSysName);
        if (csys == null) {
            throw new IOException("Misformed response - no coordsys");
        }
        return new GeoReferencedArray(arrayResponse.coverageName, arrayResponse.dataType, data, csys);
    }

    private static String getErrorMessage(HTTPMethod method) {
        String path = method.getURI().toString();
        String status = method.getStatusLine();
        String content = method.getResponseAsString();
        return content == null ? path + " " + status : path + " " + status + "\n " + content;
    }

    @Override
    public double[] readCoordValues(CoverageCoordAxis coordAxis) throws IOException {
        if (this.httpClient == null) {
            this.httpClient = HTTPFactory.newSession(this.endpoint);
        }
        Formatter f = new Formatter();
        f.format("%s?req=coord&var=%s", this.endpoint, this.urlParamEscaper.escape(coordAxis.getName()));
        if (this.showRequest) {
            System.out.printf("CdmrFeature data request for gridCoverage: %s%n url=%s", coordAxis.getName(), f);
        }
        long start = System.currentTimeMillis();
        try (HTTPMethod method = HTTPFactory.Get(this.httpClient, f.toString());){
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(CdmrCoverageReader.getErrorMessage(method));
            }
            if (statusCode >= 300) {
                throw new IOException(CdmrCoverageReader.getErrorMessage(method));
            }
            InputStream is = method.getResponseAsStream();
            NcStreamReader reader = new NcStreamReader();
            NcStreamReader.DataResult result = reader.readData(is, null, this.endpoint);
            if (this.showRequest) {
                System.out.printf(" took %d msecs%n", System.currentTimeMillis() - start);
            }
            double[] dArray = (double[])result.data.getStorage();
            return dArray;
        }
    }
}

